/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.map;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.map.MapContainer;
import com.github.jonathanxd.iutils.map.MapRegistry;
import com.github.jonathanxd.iutils.map.SimpleNodeOff;
import com.github.jonathanxd.iutils.reflection.Reflection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Map<K, V>
extends MapContainer<K, V> {
    private static final long serialVersionUID = -8307678606769422541L;
    protected final Arrays<MapContainer.Node<K, V>> nodes = new Arrays<MapContainer.Node>(new MapContainer.Node[0]);
    protected Arrays<SimpleNodeOff<K, V>> nodeOff = new Arrays<SimpleNodeOff>(new SimpleNodeOff[0]);
    protected boolean wMod = false;

    public Map() {
    }

    public Map(MapRegistry register) {
        register.init(this);
    }

    @Override
    public synchronized V putInit(Object key, Object value) {
        if (Reflection.isOnClassInit(Map.class)) {
            this.update();
            return (V)this.put(key, value);
        }
        throw new RuntimeException("Cannot put objects out of initialization.");
    }

    @Override
    public synchronized V put(K key, V value) {
        MapContainer.Node<K, V> node;
        int hash = Map.hash(key);
        if (this.nodes.length() != 0 && (node = this.getNode(hash, key)) != null) {
            node.setValue(value);
            this.wMod = true;
            return node.value;
        }
        this.nodes.add(new MapContainer.Node<K, V>(hash, key, value, null));
        this.wMod = true;
        return null;
    }

    @Override
    public synchronized boolean containsGenKey(K key) {
        return this.containsKey(key);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.containsKey(Map.hash(key), key);
    }

    public synchronized boolean containsKey(int hash, Object key) {
        return this.get(key) != null;
    }

    @Override
    public synchronized V get(Object key) {
        MapContainer.Node<K, V> fNode;
        int hash;
        block5: {
            block6: {
                hash = Map.hash(key);
                fNode = this.nodes.getFirst();
                if (fNode == null) break block5;
                if (fNode.hash == hash && fNode.key.equals(key)) break block6;
                fNode = this.nodes.getLast();
                if (!fNode.key.equals(key) || fNode.hash != hash) break block5;
            }
            return fNode.value;
        }
        if (fNode == null) {
            return null;
        }
        for (MapContainer.Node node : this.nodes) {
            if (node.hash != hash || !node.getKey().equals(key)) continue;
            return node.getValue();
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.nodes.length();
    }

    public synchronized Arrays<SimpleNodeOff<K, V>> getNodesOff() {
        if (this.wMod) {
            for (MapContainer.Node node : this.nodes) {
                this.nodeOff.add(new SimpleNodeOff(node.getKey(), node.getValue()));
            }
            this.wMod = false;
        }
        return this.nodeOff;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Use getNodesOff instead");
    }

    @Override
    protected synchronized MapContainer.Node<K, V> getNode(int hash, K key) {
        MapContainer.Node<K, V> fNode = this.nodes.getFirst();
        if (fNode != null && (fNode.equals(key) || (fNode = this.nodes.getLast()).equals(key))) {
            return fNode;
        }
        if (fNode == null) {
            return null;
        }
        for (MapContainer.Node node : this.nodes) {
            if (node.hash != hash || !node.getKey().equals(key)) continue;
            return node;
        }
        return null;
    }

    @Override
    protected synchronized V removef(K key) {
        V val = this.getNode(Map.hash(key), key).getValue();
        this.removeNode(Map.hash(key), key, null);
        return val;
    }

    @Override
    public synchronized V remove(Object key) {
        return this.removef(key);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        for (SimpleNodeOff simpleNodeOff : this.getNodesOff()) {
            action.accept(simpleNodeOff.getKey(), simpleNodeOff.getValue());
        }
    }

    @Override
    protected synchronized boolean removeNode(int hash, K key, V value) {
        Iterator iterator = this.nodes.iterator();
        if (iterator.hasNext()) {
            MapContainer.Node node = (MapContainer.Node)iterator.next();
            if (node.hash == hash && node.getKey().equals(key) && (value == null || node.getValue().equals(value))) {
                this.nodes.remove(node);
                this.update();
            }
            return true;
        }
        return false;
    }

    private void update() {
        this.wMod = true;
    }

    @Override
    public String toString() {
        Iterator i = this.getNodesOff().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            SimpleNodeOff e = (SimpleNodeOff)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

