/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.list;

import com.github.jonathanxd.iutils.extra.Container;
import com.github.jonathanxd.iutils.list.StaticList;
import java.util.Objects;

public class PreventStaticList<T>
extends StaticList<T> {
    PreventStaticList(Class<? extends T> clazz, int size) {
        super(clazz, size);
    }

    @Override
    public boolean add(int index, T element) {
        if (!this.contains(element)) {
            return super.add(index, element);
        }
        return false;
    }

    @Override
    public boolean add(T element) {
        if (!this.contains(element)) {
            return super.add(element);
        }
        return false;
    }

    @Override
    public Container<T> addAndHold(int index, T element) {
        if (!this.contains(element)) {
            return super.addAndHold(index, element);
        }
        return Container.of(element);
    }

    @Override
    public Container<T> addAndHold(T element) {
        if (!this.contains(element)) {
            return super.addAndHold(element);
        }
        return Container.of(element);
    }

    public static <T> PreventStaticList<T> createStaticListOf(Class<? extends T> listType, int listSize) {
        if (listSize <= 0) {
            throw new RuntimeException("Cannot create a static list with 0 or negative size!");
        }
        return new PreventStaticList<T>(Objects.requireNonNull(listType), listSize);
    }
}

