/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.file;

import com.github.jonathanxd.iutils.file.ExistingFile;
import com.github.jonathanxd.iutils.file.PathNamePosition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class FileUtils {
    public static File setName(File file, String name) {
        String ext = file.getName().substring(file.getName().lastIndexOf(46));
        File abPath = file.getAbsoluteFile();
        String nName = abPath.getParentFile() == null ? name + ext : abPath.getParentFile().getAbsolutePath() + File.separator + name + ext;
        return new File(nName);
    }

    public static void moveTo(File file, File newGo) throws IOException {
        if (newGo.exists() && newGo.getParentFile() != null && !newGo.getParentFile().exists()) {
            newGo.getParentFile().mkdirs();
        }
        Files.move(file.toPath(), newGo.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static File addDir(File file, String dir, PathNamePosition position) throws IOException {
        File addDir = null;
        if (position == PathNamePosition.AHEAD) {
            addDir = FileUtils.addDirA(file, dir);
        } else if (position == PathNamePosition.BEHIND) {
            addDir = FileUtils.addDirB(file, dir);
        }
        if (addDir.getParentFile() != null && !addDir.getParentFile().exists()) {
            addDir.getParentFile().mkdirs();
        }
        return addDir;
    }

    public static File addDirA(File file, String dir) throws IOException {
        String name = file.getName();
        if (file.getParentFile() == null) {
            return new File(dir, name);
        }
        File parent = new File(file.getParentFile().getAbsolutePath() + File.separator + dir);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new File(parent, name);
    }

    public static File addDirB(File file, String bdir) throws IOException {
        File current = new File(".").getCanonicalFile();
        String relative = current.toPath().relativize(file.getCanonicalFile().toPath()).toString();
        return new File(bdir + File.separator + relative);
    }

    @Deprecated
    public static ExistingFile getExistingFile(File file) {
        return new ExistingFile(file.toURI());
    }

    @Deprecated
    public static ExistingFile getExistingFile(String file) {
        return new ExistingFile(file);
    }
}

