/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.file;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.iterator.BackableIterator;
import com.github.jonathanxd.iutils.iterator.Navigator;
import com.github.jonathanxd.iutils.iterator.SafeBackableIterator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileReading
implements Iterable<String> {
    private final File file;
    private final String[] lines;

    public FileReading(File file) throws IOException {
        this.file = file;
        Arrays<String> arrays = new Arrays<String>(new String[0]);
        Stream<String> stream = Files.lines(file.toPath());
        stream.forEachOrdered(arrays::add);
        stream.close();
        this.lines = arrays.toGenericArray();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iter();
    }

    public BackableIterator<String> backableIterator() {
        return new Iter();
    }

    public SafeBackableIterator<String> safeBackableIterator() {
        return new Iter();
    }

    private class Iter
    implements SafeBackableIterator<String> {
        int index = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < FileReading.this.lines.length;
        }

        @Override
        public String next() {
            return FileReading.this.lines[++this.index];
        }

        @Override
        public boolean hasBack() {
            return this.index - 1 > -1;
        }

        @Override
        public String back() {
            return FileReading.this.lines[--this.index];
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Navigator<String> safeNavigate() {
            return new Navigator<String>(){

                @Override
                public String navigateTo(int index) {
                    return FileReading.this.lines[index];
                }

                @Override
                public boolean has(int index) {
                    return index > -1 && index < FileReading.this.lines.length;
                }

                @Override
                public String currentValue() {
                    return FileReading.this.lines[Iter.this.index];
                }

                @Override
                public int currentIndex() {
                    return Iter.this.index;
                }

                @Override
                public List<String> collect(int to) {
                    int currentIndex = Iter.this.index;
                    ArrayList<String> list = new ArrayList<String>();
                    to += currentIndex;
                    do {
                        list.add(this.navigateTo(currentIndex));
                    } while (this.has(++currentIndex) && currentIndex < to);
                    return list;
                }

                @Override
                public void goNextWhen(Predicate<String> predicate) {
                    int internalIndex = Iter.this.index;
                    while (this.has(internalIndex) && predicate.test(this.navigateTo(internalIndex))) {
                        ++internalIndex;
                    }
                }
            };
        }
    }
}

