/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.data;

import com.github.jonathanxd.iutils.object.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ReferenceData
implements Cloneable {
    private final Set<Reference<?>> dataSet = new HashSet();

    public static Object construct(ReferenceData extraData, Class<?> dataClass) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<Object> parameterList = new ArrayList<Object>();
        Constructor<?> validConstructor = null;
        for (Constructor<?> constructor : dataClass.getDeclaredConstructors()) {
            boolean fail = false;
            for (Class<?> parameterType : constructor.getParameterTypes()) {
                Optional<Object> objOpt = extraData.getData(parameterType);
                if (!objOpt.isPresent()) {
                    objOpt = extraData.getDataAssignable(parameterType);
                }
                if (!objOpt.isPresent()) {
                    errorMessages.add(String.format("Cannot determine instance of %s !", parameterType));
                    fail = true;
                    continue;
                }
                Object object = objOpt.get();
                if (parameterList.contains(object)) {
                    errorMessages.add(String.format("Argument %s already required!", parameterType));
                    fail = true;
                    continue;
                }
                parameterList.add(object);
            }
            if (!fail) {
                validConstructor = constructor;
                break;
            }
            parameterList.clear();
        }
        if (validConstructor == null) {
            errorMessages.forEach(ReferenceData::constructError);
        } else {
            Object[] args = parameterList.toArray(new Object[parameterList.size()]);
            try {
                return validConstructor.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void constructError(String error) {
        throw new RuntimeException("Cannot construct data! Error: '" + error + "'");
    }

    public void removeData(Reference<?> reference) {
        this.dataSet.remove(reference);
    }

    public Optional<Object> getDataAssignable(Class<?> dataClass) {
        for (Reference<?> data : this.dataSet) {
            Object r = data.get();
            if (!r.getClass().isAssignableFrom(dataClass)) continue;
            return Optional.of(r);
        }
        return Optional.empty();
    }

    private Optional<Object> getData(Class<?> dataClass) {
        for (Reference<?> data : this.dataSet) {
            Object r = data.get();
            if (r.getClass() != dataClass) continue;
            return Optional.of(r);
        }
        return Optional.empty();
    }

    public Object construct(Class<?> dataClass) {
        return ReferenceData.construct(this, dataClass);
    }

    public <T> void registerData(Reference<T> reference) {
        if (!this.findData(reference)) {
            this.dataSet.add(reference);
        }
    }

    public <T> boolean findData(Reference<T> reference) {
        return this.getData(reference).isPresent();
    }

    public <T> Optional<T> getData(Reference<?> reference) {
        for (Reference<?> data : this.dataSet) {
            if (!data.equals(reference)) continue;
            return Optional.of(data.get());
        }
        return Optional.empty();
    }

    public void migrateFrom(ReferenceData data) {
        this.dataSet.addAll(data.dataSet);
    }

    public void migrateTo(ReferenceData data) {
        data.dataSet.addAll(this.dataSet);
    }

    public ReferenceData clone() throws CloneNotSupportedException {
        super.clone();
        ReferenceData data = new ReferenceData();
        data.dataSet.addAll(this.dataSet);
        return data;
    }
}

