/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.data;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ExtraData
implements Cloneable {
    private final Set<Object> dataSet = new HashSet<Object>();

    public static <E extends Executable> Object match(ExtraData extraData, Class<?> dataClass, Supplier<E[]> supplyElements, BiFunction<E, Object[], Object> function, Predicate<E> accept) {
        Executable[] array;
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList parameterList = new ArrayList();
        Executable valid = null;
        for (Executable element : array = (Executable[])supplyElements.get()) {
            if (!accept.test(element)) continue;
            boolean fail = false;
            for (Class<?> parameterType : element.getParameterTypes()) {
                Optional<?> objOpt = extraData.getData(parameterType);
                if (!objOpt.isPresent()) {
                    objOpt = extraData.getDataAssignable(parameterType);
                }
                if (!objOpt.isPresent()) {
                    errorMessages.add(String.format("Cannot determine instance of %s !", parameterType));
                    fail = true;
                    continue;
                }
                Object object = objOpt.get();
                if (parameterList.contains(object)) {
                    errorMessages.add(String.format("Argument %s already required!", parameterType));
                    fail = true;
                    continue;
                }
                parameterList.add(object);
            }
            if (fail) {
                parameterList.clear();
                continue;
            }
            valid = element;
            break;
        }
        if (valid != null) {
            Object[] args = parameterList.toArray(new Object[parameterList.size()]);
            return function.apply(valid, args);
        }
        errorMessages.forEach(ExtraData::constructError);
        return null;
    }

    public static Object construct(ExtraData extraData, Class<?> dataClass, Predicate<Constructor<?>> test) {
        return ExtraData.match(extraData, dataClass, dataClass::getDeclaredConstructors, (e, args) -> {
            try {
                return e.newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e1) {
                e1.printStackTrace();
                return null;
            }
        }, test);
    }

    public static Object invoke(ExtraData extraData, Object object, Predicate<Method> methodPredicate) {
        return ExtraData.match(extraData, object.getClass(), object.getClass()::getDeclaredMethods, (e, args) -> {
            try {
                return e.invoke(object, args);
            }
            catch (IllegalAccessException | InvocationTargetException e1) {
                e1.printStackTrace();
                return null;
            }
        }, methodPredicate);
    }

    private static void constructError(String error) {
        throw new RuntimeException("Cannot construct data! Error: '" + error + "'");
    }

    public Object construct(Class<?> dataClass) {
        return ExtraData.construct(this, dataClass, e -> true);
    }

    public Object invoke(Object object) {
        return ExtraData.invoke(this, object, e -> true);
    }

    public Object construct(Class<?> dataClass, Predicate<Constructor<?>> constructorPredicate) {
        return ExtraData.construct(this, dataClass, constructorPredicate);
    }

    public Object invoke(Object object, Predicate<Method> methodPredicate) {
        return ExtraData.invoke(this, object, methodPredicate);
    }

    public void registerData(Object data) {
        if (!this.findData(data.getClass())) {
            this.dataSet.add(data);
        }
    }

    public boolean findData(Class<?> dataClass) {
        return this.getData(dataClass).isPresent();
    }

    public <T> Optional<T> getData(Class<? extends T> dataClass) {
        return this.getData(dataClass, (o1, o2) -> o1 == o2 ? 0 : -1);
    }

    public <T> Optional<T> getDataAssignable(Class<? extends T> dataClass) {
        return this.getData(dataClass, (o1, o2) -> o2.isAssignableFrom((Class<?>)o1) ? 0 : -1);
    }

    public <T> Optional<T> getData(Class<? extends T> dataClass, Comparator<Class<?>> comparator) {
        for (Object data : this.dataSet) {
            if (!dataClass.isAssignableFrom(data.getClass()) || comparator.compare(data.getClass(), dataClass) != 0) continue;
            return Optional.of(data);
        }
        return Optional.empty();
    }

    public ExtraData clone() throws CloneNotSupportedException {
        super.clone();
        ExtraData data = new ExtraData();
        data.dataSet.addAll(this.dataSet);
        return data;
    }
}

