/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.collection;

import com.github.jonathanxd.iutils.iterator.Navigator;
import com.github.jonathanxd.iutils.iterator.SafeBackableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ListSafeBackableIterator<E>
implements SafeBackableIterator<E> {
    private final List<E> list;
    private int index = -1;

    public ListSafeBackableIterator(List<E> list) {
        this.list = list;
    }

    @Override
    public boolean hasBack() {
        return this.index - 1 >= 0;
    }

    @Override
    public E back() {
        return this.list.get(--this.index);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Navigator<E> safeNavigate() {
        return new ListSafeNavigator(this.list);
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.list.size();
    }

    @Override
    public E next() {
        return this.list.get(++this.index);
    }

    private static class ListSafeNavigator<E>
    implements Navigator<E> {
        private final List<E> list;
        private int currentIndex;
        private E currentValue;

        private ListSafeNavigator(List<E> list) {
            this.list = list;
        }

        @Override
        public boolean has(int index) {
            return index >= 0 && index < this.list.size();
        }

        @Override
        public E navigateTo(int index) {
            this.currentIndex = index < 0 ? 0 : index;
            this.currentValue = this.list.get(this.currentIndex);
            return this.currentValue;
        }

        @Override
        public E currentValue() {
            return this.currentValue;
        }

        @Override
        public void goNextWhen(Predicate<E> predicate) {
            do {
                ++this.currentIndex;
            } while (this.has(this.currentIndex) && predicate.test(this.navigateTo(this.currentIndex)));
        }

        @Override
        public int currentIndex() {
            return this.currentIndex;
        }

        @Override
        public List<E> collect(int to) {
            ArrayList<E> list = new ArrayList<E>();
            to += this.currentIndex;
            do {
                list.add(this.navigateTo(this.currentIndex));
                ++this.currentIndex;
            } while (this.has(this.currentIndex) && this.currentIndex < to);
            return list;
        }
    }
}

