/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.builders.abstracts;

import com.github.jonathanxd.iutils.interfaces.CapacityImplement;
import com.github.jonathanxd.iutils.sequence.IntegerSequence;
import java.util.Arrays;

public abstract class AbstractIntegerBuilder
implements IntegerSequence,
CapacityImplement {
    Integer[] value;
    int count;

    public AbstractIntegerBuilder() {
    }

    public AbstractIntegerBuilder(int capacity) {
        this.value = new Integer[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("Integer index out of range: " + newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            Arrays.fill((Object[])this.value, this.count, newLength, Character.valueOf('\u0000'));
        }
        this.count = newLength;
    }

    @Override
    public Integer intAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Integer index out of range: " + index);
        }
        return this.value[index];
    }

    public void getInts(int srcBegin, int srcEnd, Integer[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new IndexOutOfBoundsException("Integer index out of range: " + srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new IndexOutOfBoundsException("Integer index out of range: " + srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setIntAt(int index, Integer integer) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Integer index out of range: " + index);
        }
        this.value[index] = integer;
    }

    public AbstractIntegerBuilder append(Object obj) {
        return this.append(Integer.valueOf(String.valueOf(obj).replaceAll("\\D+", "")));
    }

    public AbstractIntegerBuilder append(Integer[] integer) {
        int len = integer.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(integer, 0, this.value, this.count, len - 0);
        this.count += len;
        return this;
    }

    public AbstractIntegerBuilder append(Integer integer) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count] = integer;
        ++this.count;
        return this;
    }

    AbstractIntegerBuilder append(AbstractIntegerBuilder asb) {
        if (asb == null) {
            return this;
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        asb.getInts(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public Integer[] subinteger(int start) {
        return this.subinteger(start, this.count);
    }

    public Integer[] subinteger(int start, int end) {
        Integer[] i = new Integer[end];
        this.getInts(start, end, i, 0);
        return i;
    }

    @Override
    public IntegerSequence subSequence(int start, int end) {
        return new AbstractIntegerBuilder(end){}.append(this.subinteger(start, end));
    }
}

