/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.builders.abstracts;

import com.github.jonathanxd.iutils.interfaces.CapacityImplement;
import com.github.jonathanxd.iutils.sequence.BooleanSequence;
import java.util.Arrays;

public abstract class AbstractBooleanBuilder
implements BooleanSequence,
CapacityImplement {
    Boolean[] value;
    int count;

    public AbstractBooleanBuilder() {
    }

    public AbstractBooleanBuilder(int capacity) {
        this.value = new Boolean[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("Boolean index out of range: " + newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            Arrays.fill((Object[])this.value, this.count, newLength, Character.valueOf('\u0000'));
        }
        this.count = newLength;
    }

    @Override
    public Boolean boolAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Boolean index out of range: " + index);
        }
        return this.value[index];
    }

    public void getBools(int srcBegin, int srcEnd, Boolean[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new IndexOutOfBoundsException("Boolean index out of range: " + srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new IndexOutOfBoundsException("Boolean index out of range: " + srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setBoolAt(int index, Boolean bool) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Boolean index out of range: " + index);
        }
        this.value[index] = bool;
    }

    public AbstractBooleanBuilder append(Object obj) {
        return this.append(Boolean.valueOf(String.valueOf(obj)));
    }

    public AbstractBooleanBuilder append(Boolean[] bool) {
        int len = bool.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(bool, 0, this.value, this.count, len - 0);
        this.count += len;
        return this;
    }

    public AbstractBooleanBuilder append(Boolean bool) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count] = bool;
        ++this.count;
        return this;
    }

    AbstractBooleanBuilder append(AbstractBooleanBuilder asb) {
        if (asb == null) {
            return this;
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        asb.getBools(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public Boolean[] subboolean(int start) {
        return this.subboolean(start, this.count);
    }

    public Boolean[] subboolean(int start, int end) {
        Boolean[] b = new Boolean[end];
        this.getBools(start, end, b, 0);
        return b;
    }

    @Override
    public BooleanSequence subSequence(int start, int end) {
        return new AbstractBooleanBuilder(end){}.append(this.subboolean(start, end));
    }
}

