/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.arrays;

import com.github.jonathanxd.iutils.arrays.ArraysAbstractList;
import com.github.jonathanxd.iutils.iterator.BackableIterator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Arrays<E>
implements Iterable<E>,
Comparable<E[]>,
Cloneable {
    E[] values;
    Iter ix = null;

    @SafeVarargs
    public Arrays(E ... values) {
        this.values = values;
    }

    public Arrays<E> add(E value) {
        Objects.requireNonNull(value);
        int len = this.values.length;
        this.values = java.util.Arrays.copyOf(this.values, len + 1);
        this.values[len] = value;
        return this;
    }

    public Arrays<E> addAll(E[] value) {
        for (E e : value) {
            this.add(e);
        }
        return this;
    }

    public Arrays<E> remove(E value) {
        Objects.requireNonNull(value);
        this.values = Arrays.removeElement(this.values, value);
        return this;
    }

    public Arrays<E> set(E value, int index) {
        Objects.requireNonNull(value);
        if (index >= this.values.length) {
            throw new IndexOutOfBoundsException("Set '" + value.getClass().getName() + "'. Index '" + index + "'. Length '" + this.values.length + "'");
        }
        this.values[index] = value;
        return this;
    }

    public Collection<E> toCollection() {
        return new ArrayList<E>(this.values);
    }

    public java.util.ArrayList<E> toArrayList() {
        return new java.util.ArrayList<E>(this.toCollection());
    }

    public List<E> toList() {
        return new ArrayList<E>(this.values);
    }

    public ArraysAbstractList<E> toArraysList() {
        return new ArrayList<E>(this.values);
    }

    public E[] toGenericArray() {
        return this.values;
    }

    public <T> T[] toGenericArrayOf(T[] t) {
        if (t.length < this.values.length) {
            return java.util.Arrays.copyOf(this.values, this.values.length, t.getClass());
        }
        System.arraycopy(this.values, 0, t, 0, this.values.length);
        if (t.length > this.values.length) {
            t[this.values.length] = null;
        }
        return t;
    }

    public E getFirst() {
        return this.values.length > 0 ? (E)this.values[0] : null;
    }

    public E getLast() {
        return this.values.length > 0 ? (E)this.values[this.values.length - 1] : null;
    }

    public int getFirstEqualsIndex(E elem) {
        for (int x = 0; x < this.values.length; ++x) {
            if (!this.values[x].equals(elem)) continue;
            return x;
        }
        return -1;
    }

    public Arrays<E> copy(Arrays<E> array) {
        for (Object e : array) {
            this.add(e);
        }
        return this;
    }

    public int length() {
        return this.values.length;
    }

    public boolean isEmpty() {
        return this.length() <= 0;
    }

    public String toString() {
        return new ArrayList<E>(this.values).toString();
    }

    public static <E> E[] removeFirstElement(E[] array, E element) {
        return Arrays.removeElement(array, element, false);
    }

    public static <E> E[] removeElement(E[] array, E element) {
        return Arrays.removeElement(array, element, true);
    }

    public static <E> boolean equalsArray(E element, E[] array) {
        for (E elem : array) {
            if (!element.equals(elem)) continue;
            return true;
        }
        return false;
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public static <E> E[] removeElement(E[] array, E element, boolean recursive) {
        int len = recursive ? array.length - Arrays.find(array, element) : array.length - 1;
        Object[] arrayCp = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        int l = 0;
        boolean found = false;
        for (int x = 0; x < array.length; ++x) {
            E e = array[x];
            if (!e.equals(element) || !recursive && found) {
                arrayCp[l] = e;
                ++l;
                continue;
            }
            found = true;
        }
        return arrayCp;
    }

    public static <E> int find(E[] array, E element) {
        Objects.requireNonNull(array);
        Objects.requireNonNull(element);
        int found = 0;
        for (E e : array) {
            if (!e.equals(element)) continue;
            ++found;
        }
        return found;
    }

    public boolean contains(E o) {
        if (this.length() < 1) {
            return false;
        }
        return this.compare(o) == 1;
    }

    @Override
    public BackableIterator<E> iterator() {
        if (this.ix != null) {
            this.ix.reset();
            return this.ix;
        }
        this.ix = new Iter();
        return this.ix;
    }

    public static <E> Arrays<E> ofG(E[] values) {
        Objects.requireNonNull(values);
        return new Arrays<E>(values);
    }

    @SafeVarargs
    public static <E> Arrays<E> of(E ... values) {
        return new Arrays<E>(values);
    }

    @SafeVarargs
    public static <E> E[] genericOf(E ... values) {
        return new Arrays<E>(values).toGenericArray();
    }

    public int compare(E o) {
        int v = this.values.length - 1;
        if (v > -1 && this.values[v].equals(o)) {
            return 1;
        }
        int k = v / 2;
        if (k > -1 && k != v && this.values[k].equals(o)) {
            return 1;
        }
        for (int x = 0; x < v; ++x) {
            if (!this.values[x].equals(o)) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(E[] o) {
        if (o.length != this.values.length) {
            return -1;
        }
        int v = this.values.length - 1;
        if (v > -1 && this.values[v].equals(o[v])) {
            return 1;
        }
        int k = v / 2;
        if (k > -1 && k != v && this.values[k].equals(o[k])) {
            return 1;
        }
        for (int x = 0; x < v; ++x) {
            if (!this.values[x].equals(o[x])) continue;
            return 1;
        }
        return 0;
    }

    public static <E> E[] addToArray(E[] array, E element) {
        return Arrays.of(array).add(element).toGenericArray();
    }

    public Object clone() {
        Arrays<Object> arrays = new Arrays<Object>(new Object[0]);
        arrays.addAll(this.values);
        return arrays;
    }

    public static class PrimitiveArray {
        public static Byte[] fromPrimitive(byte[] primitive) {
            Arrays<Byte> bytes = new Arrays<Byte>(new Byte[0]);
            for (byte current : primitive) {
                bytes.add(current);
            }
            return bytes.toGenericArray();
        }

        public static Short[] fromPrimitive(short[] primitive) {
            Arrays<Short> shorts = new Arrays<Short>(new Short[0]);
            for (short current : primitive) {
                shorts.add(current);
            }
            return shorts.toGenericArray();
        }

        public static Integer[] fromPrimitive(int[] primitive) {
            Arrays<Integer> ints = new Arrays<Integer>(new Integer[0]);
            for (int current : primitive) {
                ints.add(current);
            }
            return ints.toGenericArray();
        }

        public static Long[] fromPrimitive(long[] primitive) {
            Arrays<Long> primitives = new Arrays<Long>(new Long[0]);
            for (long current : primitive) {
                primitives.add(current);
            }
            return primitives.toGenericArray();
        }

        public static Float[] fromPrimitive(float[] primitive) {
            Arrays<Float> primitives = new Arrays<Float>(new Float[0]);
            for (float current : primitive) {
                primitives.add(Float.valueOf(current));
            }
            return primitives.toGenericArray();
        }

        public static Double[] fromPrimitive(double[] primitive) {
            Arrays<Double> primitives = new Arrays<Double>(new Double[0]);
            for (double current : primitive) {
                primitives.add(current);
            }
            return primitives.toGenericArray();
        }

        public static Boolean[] fromPrimitive(boolean[] primitive) {
            Arrays<Boolean> bools = new Arrays<Boolean>(new Boolean[0]);
            for (boolean current : primitive) {
                bools.add(current);
            }
            return bools.toGenericArray();
        }

        public static Character[] fromPrimitive(char[] primitive) {
            Arrays<Character> chars = new Arrays<Character>(new Character[0]);
            for (char current : primitive) {
                chars.add(Character.valueOf(current));
            }
            return chars.toGenericArray();
        }

        public static byte[] toPrimitive(Byte[] noPrimitive) {
            byte[] a2 = new byte[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static short[] toPrimitive(Short[] noPrimitive) {
            short[] a2 = new short[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static int[] toPrimitive(Integer[] noPrimitive) {
            int[] a2 = new int[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static long[] toPrimitive(Long[] noPrimitive) {
            long[] a2 = new long[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static float[] toPrimitive(Float[] noPrimitive) {
            float[] a2 = new float[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x].floatValue();
            }
            return a2;
        }

        public static double[] toPrimitive(Double[] noPrimitive) {
            double[] a2 = new double[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static boolean[] toPrimitive(Boolean[] noPrimitive) {
            boolean[] a2 = new boolean[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x];
            }
            return a2;
        }

        public static char[] toPrimitive(Character[] noPrimitive) {
            char[] a2 = new char[noPrimitive.length];
            for (int x = 0; x < noPrimitive.length; ++x) {
                a2[x] = noPrimitive[x].charValue();
            }
            return a2;
        }
    }

    private class Iter
    implements BackableIterator<E> {
        int current = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.current + 1 < Arrays.this.values.length;
        }

        @Override
        public E next() {
            ++this.current;
            return Arrays.this.values[this.current];
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        protected final void reset() {
            this.current = -1;
        }

        @Override
        public boolean hasBack() {
            return this.current - 1 > -1;
        }

        @Override
        public E back() {
            --this.current;
            return Arrays.this.values[this.current];
        }

        @Override
        public int getIndex() {
            return this.current;
        }
    }

    private static class ArrayList<E>
    extends ArraysAbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        @SafeVarargs
        ArrayList(E ... array) {
            this.a = Objects.requireNonNull(array);
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return java.util.Arrays.copyOf(this.a, size, a.getClass());
            }
            System.arraycopy(this.a, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public E get(int index) {
            return this.a[index];
        }

        @Override
        public E set(int index, E element) {
            E oldValue = this.a[index];
            this.a[index] = element;
            return oldValue;
        }

        @Override
        public int indexOf(Object o) {
            E[] a = this.a;
            if (o == null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (!o.equals(a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this.a, 16);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            for (E e : this.a) {
                action.accept(e);
            }
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Objects.requireNonNull(operator);
            E[] a = this.a;
            for (int i = 0; i < a.length; ++i) {
                a[i] = operator.apply(a[i]);
            }
        }

        @Override
        public void sort(Comparator<? super E> c) {
            java.util.Arrays.sort(this.a, c);
        }

        @Override
        public Arrays<E> toArrays() {
            return new Arrays<E>(this.a);
        }
    }
}

