/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.arrays;

import com.github.jonathanxd.iutils.arrays.Arrays;

public class Array2DToTable {
    public static void printTable(String[][] content) {
        int x;
        int maxLength = Array2DToTable.getMaxLength(content) + 3;
        StringBuilder indexes = new StringBuilder("|Index|");
        int max = Array2DToTable.maxElement(content) + 1;
        for (x = 0; x < max; ++x) {
            indexes.append(String.format("%" + maxLength + "d|", x));
        }
        System.out.println(indexes.toString());
        for (x = 0; x < content.length; ++x) {
            String[] dimension1 = content[x];
            StringBuffer sb = new StringBuffer(String.format("|%5d|", x));
            for (int y = 0; y < dimension1.length; ++y) {
                String value = dimension1[y];
                sb.append(String.format("%" + maxLength + "s|", value));
            }
            System.out.println(sb.toString());
        }
    }

    public static String[] getAsTable(String[][] content) {
        int x;
        Arrays<String> arr = new Arrays<String>(new String[0]);
        int maxLength = Array2DToTable.getMaxLength(content) + 3;
        StringBuilder indexes = new StringBuilder("|Index|");
        int max = Array2DToTable.maxElement(content) + 1;
        for (x = 0; x < max; ++x) {
            indexes.append(String.format("%" + maxLength + "d|", x));
        }
        arr.add(indexes.toString());
        for (x = 0; x < content.length; ++x) {
            String[] dimension1 = content[x];
            StringBuffer sb = new StringBuffer(String.format("|%5d|", x));
            for (int y = 0; y < dimension1.length; ++y) {
                String value = dimension1[y];
                arr.add(String.format("%" + maxLength + "s|", value));
            }
            System.out.println(sb.toString());
        }
        return arr.toGenericArray();
    }

    public static int maxElement(String[][] content) {
        int maxElement = 0;
        for (int x = 0; x < content.length; ++x) {
            String[] dimension1 = content[x];
            for (int y = 0; y < dimension1.length; ++y) {
                if (y <= maxElement) continue;
                maxElement = y;
            }
        }
        return maxElement;
    }

    public static int getMaxLength(String[][] content) {
        int maxLength = 0;
        for (int x = 0; x < content.length; ++x) {
            String[] dimension1 = content[x];
            for (int y = 0; y < dimension1.length; ++y) {
                String value = dimension1[y];
                if (value.length() <= maxLength) continue;
                maxLength = value.length();
            }
        }
        return maxLength;
    }
}

