/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.arguments;

import com.github.jonathanxd.iutils.object.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class ArrayArgument<E> {
    private final E[] eArray;
    private final Map<Reference<?>, Function<E, ?>> transformerMap = new HashMap();

    public ArrayArgument(E[] eArray) {
        this.eArray = eArray;
    }

    public <R> void add(Reference<R> reference, Function<E, Optional<R>> transformer) {
        this.transformerMap.put(reference, transformer);
    }

    public <T> Optional<T> get(Reference<T> reference, int pos) {
        E value = this.eArray[pos];
        for (Map.Entry<Reference<?>, Function<E, ?>> entry : this.transformerMap.entrySet()) {
            Object ret;
            if (entry.getKey().compareTo(reference) != 0 || (ret = entry.getValue().apply(value)) == null) continue;
            if (ret instanceof Optional) {
                Optional retOpt = (Optional)ret;
                if (!retOpt.isPresent()) continue;
                ret = retOpt.get();
            }
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public <T> Collection<T> allOf(Reference<T> reference) {
        Optional<T> current;
        ArrayList<T> collection = new ArrayList<T>();
        int offset = 0;
        while ((current = this.offSetFirst(reference, offset)).isPresent()) {
            collection.add(current.get());
        }
        return collection;
    }

    public <T> boolean find(Reference<T> reference) {
        return this.transformerMap.entrySet().stream().filter(e -> ((Reference)e.getKey()).compareTo(reference) == 0).findFirst().isPresent();
    }

    public <T> Optional<T> first(Reference<T> reference) {
        for (int x = 0; x < this.eArray.length; ++x) {
            E value = this.eArray[x];
            Optional<T> retOpt = this.get(reference, x);
            if (!retOpt.isPresent()) continue;
            return retOpt;
        }
        return Optional.empty();
    }

    public <T> Optional<T> offSetFirst(Reference<T> reference, int offset) {
        int off = 0;
        for (int x = 0; x < this.eArray.length; ++x) {
            E value = this.eArray[x];
            Optional<T> retOpt = this.get(reference, x);
            if (!retOpt.isPresent()) continue;
            if (off < offset) {
                ++off;
                continue;
            }
            return retOpt;
        }
        return Optional.empty();
    }

    public E[] getArray() {
        return this.eArray;
    }
}

