/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.extend.list;

import com.github.jonathanxd.extend.list.AListInteraction;
import com.github.jonathanxd.extend.list.IAListInteraction;
import com.github.jonathanxd.iutils.arrays.Arrays;
import java.util.function.Predicate;

public class AList<E>
extends Arrays<E> {
    private final IAListInteraction<E> interactor;

    @SafeVarargs
    public AList(IAListInteraction<E> interactor, E ... values) {
        super(values);
        this.interactor = interactor;
    }

    public AListInteraction<E> getAllIf(Predicate<E> predicate) {
        Object pass = null;
        int pos = -1;
        for (int x = 0; x < this.toGenericArray().length; ++x) {
            Object value = this.toGenericArray()[x];
            if (!predicate.test(value)) continue;
            pass = value;
            pos = x;
            break;
        }
        if (pass == null) {
            return null;
        }
        AListInteraction<Object> ali = new AListInteraction<Object>(this, (IAListInteraction<Object>)this.interactor, pass);
        if (++pos < this.toGenericArray().length) {
            ali.andAllIf(pos, predicate);
        }
        return ali;
    }

    public AListInteraction<E> getAll() {
        return this.getAllIf(v -> true);
    }

    public AListInteraction<E> get(int index) {
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " out of index in array " + this.toString() + " [length=" + this.length() + "]");
        }
        return new AListInteraction<E>(this, this.interactor, this.toGenericArray()[index]);
    }
}

