/*
 * Decompiled with CFR 0.152.
 */
package com.droidnet;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.droidnet.CheckInternetTask;
import com.droidnet.DroidListener;
import com.droidnet.NetworkChangeReceiver;
import com.droidnet.TaskFinished;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DroidNet
implements NetworkChangeReceiver.NetworkChangeListener {
    private static final Object LOCK = new Object();
    private static volatile DroidNet sInstance;
    private WeakReference<Context> mContextWeakReference;
    private List<WeakReference<DroidListener>> mInternetConnectivityListenersWeakReferences;
    private NetworkChangeReceiver mNetworkChangeReceiver;
    private boolean mIsNetworkChangeRegistered = false;
    private boolean mIsInternetConnected = false;
    private TaskFinished<Boolean> mCheckConnectivityCallback;
    private static final String CONNECTIVITY_CHANGE_INTENT_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";

    private DroidNet(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContextWeakReference = new WeakReference<Context>(appContext);
        this.mInternetConnectivityListenersWeakReferences = new ArrayList<WeakReference<DroidListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DroidNet init(Context context) {
        if (context == null) {
            throw new NullPointerException("context can not be null");
        }
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new DroidNet(context);
                }
            }
        }
        return sInstance;
    }

    public static DroidNet getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("call init(Context) in your application class before calling getInstance()");
        }
        return sInstance;
    }

    public void addInternetConnectivityListener(DroidListener droidListener) {
        if (droidListener == null) {
            return;
        }
        this.mInternetConnectivityListenersWeakReferences.add(new WeakReference<DroidListener>(droidListener));
        if (this.mInternetConnectivityListenersWeakReferences.size() == 1) {
            this.registerNetworkChangeReceiver();
            return;
        }
        this.publishInternetAvailabilityStatus(this.mIsInternetConnected);
    }

    public void removeInternetConnectivityChangeListener(DroidListener droidListener) {
        if (droidListener == null) {
            return;
        }
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<DroidListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<DroidListener> reference = iterator.next();
            if (reference == null) {
                iterator.remove();
                continue;
            }
            DroidListener listener = (DroidListener)reference.get();
            if (listener == null) {
                reference.clear();
                iterator.remove();
                continue;
            }
            if (listener != droidListener) continue;
            reference.clear();
            iterator.remove();
            break;
        }
        if (this.mInternetConnectivityListenersWeakReferences.size() == 0) {
            this.unregisterNetworkChangeReceiver();
        }
    }

    public void removeAllInternetConnectivityChangeListeners() {
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<DroidListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<DroidListener> reference = iterator.next();
            if (reference != null) {
                reference.clear();
            }
            iterator.remove();
        }
        this.unregisterNetworkChangeReceiver();
    }

    private void registerNetworkChangeReceiver() {
        Context context = (Context)this.mContextWeakReference.get();
        if (context != null && !this.mIsNetworkChangeRegistered) {
            this.mNetworkChangeReceiver = new NetworkChangeReceiver();
            this.mNetworkChangeReceiver.setNetworkChangeListener(this);
            context.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, new IntentFilter(CONNECTIVITY_CHANGE_INTENT_ACTION));
            this.mIsNetworkChangeRegistered = true;
        }
    }

    private void unregisterNetworkChangeReceiver() {
        Context context = (Context)this.mContextWeakReference.get();
        if (context != null && this.mNetworkChangeReceiver != null && this.mIsNetworkChangeRegistered) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mNetworkChangeReceiver.removeNetworkChangeListener();
        }
        this.mNetworkChangeReceiver = null;
        this.mIsNetworkChangeRegistered = false;
        this.mCheckConnectivityCallback = null;
    }

    @Override
    public void onNetworkChange(boolean isNetworkAvailable) {
        if (isNetworkAvailable) {
            this.mCheckConnectivityCallback = new TaskFinished<Boolean>(){

                @Override
                public void onTaskFinished(Boolean isInternetAvailable) {
                    DroidNet.this.mCheckConnectivityCallback = null;
                    DroidNet.this.publishInternetAvailabilityStatus(isInternetAvailable);
                }
            };
            new CheckInternetTask(this.mCheckConnectivityCallback).execute(new Void[0]);
        } else {
            this.publishInternetAvailabilityStatus(false);
        }
    }

    private void publishInternetAvailabilityStatus(boolean isInternetAvailable) {
        this.mIsInternetConnected = isInternetAvailable;
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<DroidListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<DroidListener> reference = iterator.next();
            if (reference == null) {
                iterator.remove();
                continue;
            }
            DroidListener listener = (DroidListener)reference.get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.onInternetConnectivityChanged(isInternetAvailable);
        }
        if (this.mInternetConnectivityListenersWeakReferences.size() == 0) {
            this.unregisterNetworkChangeReceiver();
        }
    }
}

