/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.widget;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;
import java.util.ArrayList;

public abstract class DragSelectRecyclerAdapter<T>
extends BaseRecyclerAdapter<T> {
    private ArrayList<Integer> mSelectedIndices = new ArrayList();
    private SelectionListener mSelectionListener;
    private int mLastCount = -1;
    private int mMaxSelectionCount = -1;

    private void fireSelectionListener() {
        if (this.mLastCount == this.mSelectedIndices.size()) {
            return;
        }
        this.mLastCount = this.mSelectedIndices.size();
        if (this.mSelectionListener != null) {
            this.mSelectionListener.onDragSelectionChanged(this.mLastCount);
        }
    }

    protected DragSelectRecyclerAdapter() {
    }

    @Override
    public void onBindViewHolderClick(@NonNull ViewHolder holder, View view) {
        super.onBindViewHolderClick(holder, view);
        holder.itemView.setTag((Object)holder);
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        this.mMaxSelectionCount = maxSelectionCount;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListener = selectionListener;
    }

    public void saveInstanceState(Bundle out) {
        this.saveInstanceState("selected_indices", out);
    }

    public void saveInstanceState(String key, Bundle out) {
        out.putSerializable(key, this.mSelectedIndices);
    }

    public void restoreInstanceState(Bundle in) {
        this.restoreInstanceState("selected_indices", in);
    }

    public void restoreInstanceState(String key, Bundle in) {
        if (in != null && in.containsKey(key)) {
            this.mSelectedIndices = (ArrayList)in.getSerializable(key);
            if (this.mSelectedIndices == null) {
                this.mSelectedIndices = new ArrayList();
            } else {
                this.fireSelectionListener();
            }
        }
    }

    public final void setSelected(int index, boolean selected) {
        if (!this.isIndexSelectable(index)) {
            selected = false;
        }
        if (selected) {
            if (!(this.mSelectedIndices.contains(index) || this.mMaxSelectionCount != -1 && this.mSelectedIndices.size() >= this.mMaxSelectionCount)) {
                this.mSelectedIndices.add(index);
                this.notifyDataSetChanged();
            }
        } else if (this.mSelectedIndices.contains(index)) {
            this.mSelectedIndices.remove((Object)index);
            this.notifyDataSetChanged();
        }
        this.fireSelectionListener();
    }

    public final boolean toggleSelected(int index) {
        boolean selectedNow = false;
        if (this.isIndexSelectable(index)) {
            if (this.mSelectedIndices.contains(index)) {
                this.mSelectedIndices.remove((Object)index);
            } else if (this.mMaxSelectionCount == -1 || this.mSelectedIndices.size() < this.mMaxSelectionCount) {
                this.mSelectedIndices.add(index);
                selectedNow = true;
            }
            this.notifyDataSetChanged();
        }
        this.fireSelectionListener();
        return selectedNow;
    }

    protected boolean isIndexSelectable(int index) {
        return true;
    }

    public final void selectRange(int from, int to, int min, int max) {
        if (from == to) {
            for (int i = min; i <= max; ++i) {
                if (i == from) continue;
                this.setSelected(i, false);
            }
            this.fireSelectionListener();
            return;
        }
        if (to < from) {
            int i;
            for (i = to; i <= from; ++i) {
                this.setSelected(i, true);
            }
            if (min > -1 && min < to) {
                for (i = min; i < to; ++i) {
                    if (i == from) continue;
                    this.setSelected(i, false);
                }
            }
            if (max > -1) {
                for (i = from + 1; i <= max; ++i) {
                    this.setSelected(i, false);
                }
            }
        } else {
            int i;
            for (i = from; i <= to; ++i) {
                this.setSelected(i, true);
            }
            if (max > -1 && max > to) {
                for (i = to + 1; i <= max; ++i) {
                    if (i == from) continue;
                    this.setSelected(i, false);
                }
            }
            if (min > -1) {
                for (i = min; i < from; ++i) {
                    this.setSelected(i, false);
                }
            }
        }
        this.fireSelectionListener();
    }

    public final void clearSelected() {
        this.mSelectedIndices.clear();
        this.notifyDataSetChanged();
        this.fireSelectionListener();
    }

    public final int getSelectedCount() {
        return this.mSelectedIndices.size();
    }

    public final ArrayList<Integer> getSelectedIndices() {
        if (this.mSelectedIndices == null) {
            this.mSelectedIndices = new ArrayList();
        }
        return this.mSelectedIndices;
    }

    public final boolean isIndexSelected(int index) {
        return this.mSelectedIndices.contains(index);
    }

    public static interface SelectionListener {
        public void onDragSelectionChanged(int var1);
    }
}

