/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.manager;

import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemManager<T> {
    private BaseRecyclerAdapter<T> mAdapter;
    private boolean isOpenAnim;
    private ArrayList<CheckItemInterface> checkItemInterfaces;

    public ItemManager(BaseRecyclerAdapter<T> adapter) {
        this.mAdapter = adapter;
    }

    public BaseRecyclerAdapter<T> getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(BaseRecyclerAdapter<T> adapter) {
        this.mAdapter = adapter;
    }

    public boolean isOpenAnim() {
        return this.isOpenAnim;
    }

    public void setOpenAnim(boolean openAnim) {
        this.isOpenAnim = openAnim;
    }

    public abstract void addItem(T var1);

    public abstract void addItem(int var1, T var2);

    public abstract void addItems(List<T> var1);

    public abstract void addItems(int var1, List<T> var2);

    public abstract void removeItem(T var1);

    public abstract void removeItem(int var1);

    public abstract void removeItems(List<T> var1);

    public abstract void replaceItem(int var1, T var2);

    public abstract void replaceAllItem(List<T> var1);

    public abstract T getItem(int var1);

    public abstract int getItemPosition(T var1);

    public abstract void clean();

    public void notifyDataChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void removeCheckItemInterfaces(CheckItemInterface itemInterface) {
        if (this.checkItemInterfaces == null) {
            return;
        }
        this.checkItemInterfaces.remove(itemInterface);
    }

    public void addCheckItemInterfaces(CheckItemInterface itemInterface) {
        if (this.checkItemInterfaces == null) {
            this.checkItemInterfaces = new ArrayList();
        }
        this.checkItemInterfaces.add(itemInterface);
    }

    public int itemToDataPosition(int position) {
        if (this.checkItemInterfaces != null) {
            for (CheckItemInterface itemInterface : this.checkItemInterfaces) {
                position = itemInterface.itemToDataPosition(position);
            }
        }
        return position;
    }

    public int dataToItemPosition(int index) {
        if (this.checkItemInterfaces != null) {
            for (CheckItemInterface itemInterface : this.checkItemInterfaces) {
                index = itemInterface.dataToItemPosition(index);
            }
        }
        return index;
    }

    public static interface CheckItemInterface {
        public int itemToDataPosition(int var1);

        public int dataToItemPosition(int var1);
    }
}

