/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.base;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.manager.ItemManageImpl;
import com.baozi.treerecyclerview.manager.ItemManager;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRecyclerAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected ItemManager<T> mItemManager;
    protected OnItemClickListener mOnItemClickListener;
    protected OnItemLongClickListener mOnItemLongClickListener;
    private List<T> mDatas;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ViewHolder holder = ViewHolder.createViewHolder(parent, viewType);
        this.onBindViewHolderClick(holder, holder.itemView);
        return holder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        this.onBindViewHolder(holder, this.getData(position), position);
    }

    public void onBindViewHolderClick(final @NonNull ViewHolder viewHolder, View view) {
        if (!view.hasOnClickListeners()) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int layoutPosition = viewHolder.getLayoutPosition();
                    int itemPosition = BaseRecyclerAdapter.this.getItemManager().itemToDataPosition(layoutPosition);
                    if (BaseRecyclerAdapter.this.mOnItemClickListener != null) {
                        BaseRecyclerAdapter.this.mOnItemClickListener.onItemClick(viewHolder, itemPosition);
                    }
                }
            });
        }
        if (!view.isLongClickable()) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    int layoutPosition = viewHolder.getLayoutPosition();
                    int itemPosition = BaseRecyclerAdapter.this.getItemManager().itemToDataPosition(layoutPosition);
                    if (BaseRecyclerAdapter.this.mOnItemLongClickListener != null) {
                        return BaseRecyclerAdapter.this.mOnItemLongClickListener.onItemLongClick(viewHolder, itemPosition);
                    }
                    return false;
                }
            });
        }
    }

    public int getItemViewType(int position) {
        return this.getLayoutId(position);
    }

    public int getItemCount() {
        return this.getDatas().size();
    }

    @Deprecated
    public int getItemSpanSize(int position) {
        return 0;
    }

    public int getItemSpanSize(int position, int maxSpan) {
        return maxSpan;
    }

    public List<T> getDatas() {
        if (this.mDatas == null) {
            this.mDatas = new ArrayList<T>();
        }
        return this.mDatas;
    }

    public void setDatas(List<T> datas) {
        if (datas != null && !datas.isEmpty()) {
            this.getDatas().clear();
            this.getDatas().addAll(datas);
        }
    }

    @Nullable
    public T getData(int position) {
        if (position >= 0) {
            return this.getDatas().get(position);
        }
        return null;
    }

    public ItemManager<T> getItemManager() {
        if (this.mItemManager == null) {
            this.mItemManager = new ItemManageImpl(this);
        }
        return this.mItemManager;
    }

    public void setItemManager(ItemManager<T> itemManager) {
        this.mItemManager = itemManager;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public int checkPosition(int position) {
        return this.getItemManager().itemToDataPosition(position);
    }

    public abstract int getLayoutId(int var1);

    public void onBindViewHolder(@NonNull ViewHolder holder, T t, int position) {
    }

    public void clear() {
        this.getDatas().clear();
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(@NonNull ViewHolder var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(@NonNull ViewHolder var1, int var2);
    }
}

