/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.adpater.wrapper;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.baozi.treerecyclerview.adpater.wrapper.BaseWrapper;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;

public class LoadingWrapper<T>
extends BaseWrapper<T> {
    private static final int ITEM_TYPE_EMPTY = -3000;
    private static final int ITEM_TYPE_LOADING = -4000;
    private static final int ITEM_LOAD_MORE = -5000;
    private View mEmptyView;
    private int mEmptyLayoutId;
    private View mLoadingView;
    private int mLoadingLayoutId;
    private LoadMoreItem mLoadMoreItem;
    private LoadMoreListener loadMoreListener;
    private boolean initLoadMore;
    private Type mType;

    public LoadingWrapper(BaseRecyclerAdapter<T> adapter) {
        super(adapter);
    }

    private boolean isEmpty() {
        return this.getDatas().size() == 0;
    }

    private boolean isLoading() {
        return this.mType == Type.LOADING;
    }

    private boolean isLoadMoreViewPos(int position) {
        return position >= this.mAdapter.getItemCount();
    }

    public void setType(Type type) {
        switch (type) {
            case EMPTY: {
                break;
            }
            case SUCCESS: 
            case REFRESH_OVER: {
                break;
            }
            case LOADING: {
                if (this.mLoadingView == null && this.mLoadingLayoutId == 0) {
                    return;
                }
                this.notifyDataSetChanged();
                break;
            }
            case LOAD_MORE: 
            case LOAD_ERROR: 
            case LOAD_OVER: {
                if (this.mLoadMoreItem == null) break;
                this.mLoadMoreItem.setType(type);
            }
        }
        this.mType = type;
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        if (this.mEmptyView == null && this.mEmptyLayoutId == 0) {
            this.mEmptyView = new View(recyclerView.getContext());
        }
        if (this.mLoadingView == null && this.mLoadingLayoutId == 0) {
            this.mLoadingView = new View(recyclerView.getContext());
        }
        this.setType(Type.LOADING);
        if (this.mLoadMoreItem != null) {
            recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    int lastVisibleIndex;
                    if (LoadingWrapper.this.loadMoreListener == null) {
                        return;
                    }
                    LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                    int itemCount = LoadingWrapper.this.getDatas().size();
                    int lastPosition = LoadingWrapper.this.checkPosition(layoutManager.findLastVisibleItemPosition());
                    int n = lastVisibleIndex = LoadingWrapper.this.mLoadMoreItem.getLastVisibleIndex() == 0 ? 1 : LoadingWrapper.this.mLoadMoreItem.getLastVisibleIndex();
                    if (lastPosition >= itemCount - lastVisibleIndex && itemCount >= LoadingWrapper.this.mLoadMoreItem.getMinPageSize() - lastVisibleIndex) {
                        LoadingWrapper.this.loadMoreListener.loadMore(LoadingWrapper.this.mType);
                    }
                }
            });
        }
    }

    @Override
    @Deprecated
    public int getItemSpanSize(int position) {
        if ((this.isEmpty() || this.isLoading()) && position == 0) {
            return 0;
        }
        if (this.isLoadMoreViewPos(position)) {
            return 0;
        }
        return super.getItemSpanSize(position);
    }

    @Override
    public int getItemSpanSize(int position, int maxSpan) {
        if ((this.isEmpty() || this.isLoading()) && position == 0) {
            return maxSpan;
        }
        if (this.isLoadMoreViewPos(position)) {
            return maxSpan;
        }
        return super.getItemSpanSize(position, maxSpan);
    }

    public LoadMoreListener getLoadMoreListener() {
        return this.loadMoreListener;
    }

    public void setLoadMoreListener(LoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    @Override
    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == -4000) {
            if (this.mLoadingLayoutId > 0) {
                return ViewHolder.createViewHolder(parent, this.mLoadingLayoutId);
            }
            return ViewHolder.createViewHolder(this.mLoadingView);
        }
        if (viewType == -3000) {
            if (this.mEmptyLayoutId > 0) {
                return ViewHolder.createViewHolder(parent, this.mEmptyLayoutId);
            }
            return ViewHolder.createViewHolder(this.mEmptyView);
        }
        if (viewType == -5000) {
            return ViewHolder.createViewHolder(this.mLoadMoreItem.getLoadMoreView());
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    @Override
    public int getItemViewType(int position) {
        if (this.isLoading()) {
            return -4000;
        }
        if (this.isEmpty()) {
            return -3000;
        }
        if (this.isLoadMoreViewPos(position)) {
            return -5000;
        }
        return this.mAdapter.getItemViewType(position);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        if (this.isEmpty() || this.isLoading() || this.isLoadMoreViewPos(position)) {
            return;
        }
        this.mAdapter.onBindViewHolder(holder, position);
    }

    @Override
    public int getItemCount() {
        if (this.isEmpty() || this.isLoading()) {
            return 1;
        }
        if (!this.initLoadMore) {
            return this.mAdapter.getItemCount();
        }
        if (this.mType == Type.LOAD_ERROR || this.mType == Type.LOAD_OVER) {
            return this.mAdapter.getItemCount() + 1;
        }
        if (this.mAdapter.getItemCount() >= this.mLoadMoreItem.getMinPageSize()) {
            return this.mAdapter.getItemCount() + 1;
        }
        return this.mAdapter.getItemCount();
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.mEmptyLayoutId = 0;
    }

    public void setEmptyView(int layoutId) {
        this.mEmptyLayoutId = layoutId;
    }

    public void setLoadingView(View loadingView) {
        this.mLoadingView = loadingView;
    }

    public void setLoadingView(int layoutId) {
        this.mLoadingLayoutId = layoutId;
    }

    public void setLoadMore(LoadMoreItem loadMoreItem) {
        this.mLoadMoreItem = loadMoreItem;
        this.initLoadMore = this.mLoadMoreItem != null;
    }

    public static abstract class LoadMoreItem {
        private FrameLayout mLayout;
        private View loadMoreView;
        private View loadOverView;
        private View loadErrorView;

        public LoadMoreItem(Context context) {
            this.mLayout = new FrameLayout(context);
            this.mLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            this.loadErrorView = this.getLoadErrorView();
            if (this.loadErrorView != null) {
                this.mLayout.addView(this.loadErrorView);
            } else {
                this.loadErrorView = new View(context);
            }
            this.loadOverView = this.getLoadOverView();
            int loadOverLayout = this.getLoadOverLayout();
            if (this.loadOverView != null) {
                this.mLayout.addView(this.loadOverView);
            } else if (this.getLoadOverLayout() > 0) {
                this.loadOverView = LayoutInflater.from((Context)context).inflate(loadOverLayout, (ViewGroup)this.mLayout, false);
                this.mLayout.addView(this.loadOverView);
            } else {
                this.loadOverView = new View(context);
            }
            int loadMoreLayout = this.getLoadMoreLayout();
            if (loadMoreLayout > 0) {
                this.loadMoreView = LayoutInflater.from((Context)context).inflate(loadMoreLayout, (ViewGroup)this.mLayout, false);
                this.mLayout.addView(this.loadMoreView);
            } else {
                this.loadMoreView = new View(context);
            }
        }

        public View getLoadMoreView() {
            return this.mLayout;
        }

        public int getLastVisibleIndex() {
            return 0;
        }

        public View getLoadOverView() {
            return null;
        }

        public View getLoadErrorView() {
            return null;
        }

        void setType(Type type) {
            this.loadErrorView.setVisibility(8);
            this.loadMoreView.setVisibility(8);
            this.loadOverView.setVisibility(8);
            switch (type) {
                case LOAD_MORE: {
                    this.loadMoreView.setVisibility(0);
                    break;
                }
                case LOAD_OVER: {
                    this.loadOverView.setVisibility(0);
                    break;
                }
                case LOAD_ERROR: {
                    this.loadErrorView.setVisibility(0);
                }
            }
        }

        public abstract int getLoadMoreLayout();

        public abstract int getLoadOverLayout();

        public abstract int getMinPageSize();
    }

    public static interface LoadMoreListener {
        public void loadMore(Type var1);
    }

    public static enum Type {
        EMPTY,
        REFRESH_OVER,
        SUCCESS,
        LOADING,
        LOAD_MORE,
        LOAD_ERROR,
        LOAD_OVER;

    }
}

