/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.world.impl;

import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.world.RegionInfo;
import com.github.jikoo.regionerator.world.WorldInfo;
import com.github.jikoo.regionerator.world.impl.AnvilRegion;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilWorld
extends WorldInfo {
    public static final Pattern ANVIL_REGION = Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mca");

    public AnvilWorld(Regionerator plugin, World world) {
        super(plugin, world);
    }

    @Override
    @NotNull
    public RegionInfo getRegion(int regionX, int regionZ) {
        File regionFolder = this.findRegionFolder(this.getWorld());
        File regionFile = new File(regionFolder, "r." + regionX + "." + regionZ + ".mca");
        return new AnvilRegion(this, regionFile, Coords.regionToChunk(regionX), Coords.regionToChunk(regionZ));
    }

    @Override
    @Nullable
    public Stream<RegionInfo> getRegions() {
        AtomicInteger index = new AtomicInteger();
        File regionFolder = this.findRegionFolder(this.getWorld());
        File[] regionFiles = regionFolder.listFiles((dir, name) -> ANVIL_REGION.matcher(name).matches());
        if (regionFiles == null) {
            return null;
        }
        return Stream.generate(() -> this.parseRegion(regionFiles[index.getAndIncrement()])).limit(regionFiles.length).filter(Objects::nonNull);
    }

    private File findRegionFolder(@NotNull World world) {
        switch (world.getEnvironment()) {
            case NETHER: {
                return new File(world.getWorldFolder(), "DIM-1" + File.separatorChar + "region");
            }
            case THE_END: {
                return new File(world.getWorldFolder(), "DIM1" + File.separatorChar + "region");
            }
        }
        return new File(world.getWorldFolder(), "region");
    }

    @Nullable
    private RegionInfo parseRegion(@NotNull File regionFile) {
        Matcher matcher = ANVIL_REGION.matcher(regionFile.getName());
        if (!matcher.matches()) {
            return null;
        }
        return new AnvilRegion(this, regionFile, Coords.regionToChunk(Integer.parseInt(matcher.group(1))), Coords.regionToChunk(Integer.parseInt(matcher.group(2))));
    }
}

