/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.world;

import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.VisitStatus;
import com.github.jikoo.regionerator.util.SupplierCache;
import com.github.jikoo.regionerator.util.VisitStatusCache;
import com.github.jikoo.regionerator.world.RegionInfo;
import com.google.common.base.Preconditions;
import org.bukkit.World;

public abstract class ChunkInfo {
    private final RegionInfo regionInfo;
    private final int localChunkX;
    private final int localChunkZ;
    private final SupplierCache<VisitStatus> visitStatusSupplier;

    public ChunkInfo(RegionInfo regionInfo, int localChunkX, int localChunkZ) {
        Preconditions.checkArgument((localChunkX >= 0 && localChunkX < 32 ? 1 : 0) != 0, (Object)"localChunkX must be between 0 and 31");
        Preconditions.checkArgument((localChunkZ >= 0 && localChunkZ < 32 ? 1 : 0) != 0, (Object)"localChunkZ must be between 0 and 31");
        this.regionInfo = regionInfo;
        this.localChunkX = localChunkX;
        this.localChunkZ = localChunkZ;
        this.visitStatusSupplier = new VisitStatusCache(this.getPlugin(), this);
    }

    public World getWorld() {
        return this.regionInfo.getWorld();
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public int getChunkX() {
        return this.regionInfo.getLowestChunkX() + this.localChunkX;
    }

    public int getChunkZ() {
        return this.regionInfo.getLowestChunkZ() + this.localChunkZ;
    }

    public int getLocalChunkX() {
        return this.localChunkX;
    }

    public int getLocalChunkZ() {
        return this.localChunkZ;
    }

    public abstract boolean isOrphaned();

    public abstract void setOrphaned();

    public abstract long getLastModified();

    public long getLastVisit() {
        return this.getPlugin().getFlagger().getChunkFlag(this.getWorld(), this.getChunkX(), this.getChunkZ()).join().getLastVisit();
    }

    public VisitStatus getVisitStatus() {
        return this.visitStatusSupplier.get();
    }

    private Regionerator getPlugin() {
        return this.getRegionInfo().getWorldInfo().getPlugin();
    }
}

