/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.util.yaml;

import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.util.yaml.ConfigYamlData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class Config
extends ConfigYamlData {
    public static final long FLAG_DEFAULT = -1L;
    public static final long FLAG_ETERNAL = 0x7FFFFFFFFFFFFFFEL;
    public static final long FLAG_OH_NO = 0x7FFFFFFFFFFFFFFDL;
    private final Object lock = new Object();
    private DebugLevel debugLevel;
    private List<String> worlds;
    private final AtomicLong flagDuration = new AtomicLong();
    private final AtomicLong ticksPerFlag = new AtomicLong();
    private final AtomicLong millisBetweenCycles = new AtomicLong();
    private final AtomicLong deletionRecovery = new AtomicLong();
    private final AtomicInteger flaggingRadius = new AtomicInteger();
    private final AtomicInteger deletionChunkCount = new AtomicInteger();
    private final AtomicBoolean rememberCycleDelay = new AtomicBoolean();
    private final AtomicBoolean deleteFreshChunks = new AtomicBoolean();

    public Config(Plugin plugin) {
        super(plugin);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        super.reload();
        List<String> worldConfigList = this.getStringList("worlds");
        ArrayList<String> worldCorrectCaseList = new ArrayList<String>();
        block5: for (World world : Bukkit.getWorlds()) {
            if (worldConfigList.contains(world.getName())) {
                worldCorrectCaseList.add(world.getName());
                continue;
            }
            for (String name : worldConfigList) {
                if (!world.getName().equalsIgnoreCase(name)) continue;
                worldCorrectCaseList.add(world.getName());
                continue block5;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.worlds = ImmutableList.copyOf(worldCorrectCaseList);
            try {
                String debugConfigVal = this.getString("debug-level");
                if (debugConfigVal == null) {
                    debugConfigVal = "OFF";
                }
                this.debugLevel = DebugLevel.valueOf(debugConfigVal.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.debugLevel = DebugLevel.OFF;
            }
        }
        long newMilliValue = TimeUnit.DAYS.toMillis(this.getInt("days-till-flag-expires"));
        this.flagDuration.set(Math.max(0L, newMilliValue));
        this.deleteFreshChunks.set(newMilliValue <= 0L || this.getBoolean("delete-new-unvisited-chunks"));
        this.flaggingRadius.set(Math.max(0, this.getInt("chunk-flag-radius")));
        int secondsPerFlag = this.getInt("seconds-per-flag");
        if (secondsPerFlag < 1) {
            this.ticksPerFlag.set(10L);
        } else {
            this.ticksPerFlag.set(20 * secondsPerFlag);
        }
        long ticksPerDeletion = this.getLong("ticks-per-deletion");
        if (ticksPerDeletion < 1L) {
            this.deletionRecovery.set(0L);
        } else {
            this.deletionRecovery.set(ticksPerDeletion * 50L);
        }
        int chunksPerDelete = this.getInt("chunks-per-deletion");
        if (chunksPerDelete < 1) {
            this.deletionChunkCount.set(32);
        } else {
            this.deletionChunkCount.set(chunksPerDelete);
        }
        this.millisBetweenCycles.set(TimeUnit.HOURS.toMillis(Math.max(0, this.getInt("hours-between-cycles"))));
        this.rememberCycleDelay.set(this.getBoolean("remember-next-cycle-time"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugLevel getDebugLevel() {
        Object object = this.lock;
        synchronized (object) {
            return this.debugLevel;
        }
    }

    public int getDeletionChunkCount() {
        return this.deletionChunkCount.get();
    }

    public long getDeletionRecoveryMillis() {
        return this.deletionRecovery.get();
    }

    public long getMillisBetweenCycles() {
        return this.millisBetweenCycles.get();
    }

    public boolean isRememberCycleDelay() {
        return this.rememberCycleDelay.get();
    }

    public boolean isDeleteFreshChunks() {
        return this.deleteFreshChunks.get();
    }

    public long getFlagDuration() {
        return this.flagDuration.get();
    }

    public long getFlagGenerated() {
        return this.isDeleteFreshChunks() ? this.getFlagVisit() : Long.MAX_VALUE;
    }

    public long getFlagVisit() {
        return System.currentTimeMillis() + this.getFlagDuration();
    }

    @Deprecated
    public static long getFlagEternal() {
        return 0x7FFFFFFFFFFFFFFEL;
    }

    @Deprecated
    public static long getFlagDefault() {
        return -1L;
    }

    public long getFlaggingInterval() {
        return this.ticksPerFlag.get();
    }

    public int getFlaggingRadius() {
        return this.flaggingRadius.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWorlds() {
        Object object = this.lock;
        synchronized (object) {
            return this.worlds;
        }
    }
}

