/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SupplierCache<T> {
    private final Supplier<T> supplier;
    private final long cacheDuration;
    private T value;
    private long lastUpdate;

    public SupplierCache(Supplier<T> supplier, long duration, TimeUnit timeUnit) {
        this.supplier = supplier;
        this.cacheDuration = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
    }

    public T get() {
        if (this.value == null || this.lastUpdate <= System.currentTimeMillis() - this.cacheDuration) {
            this.value = this.supplier.get();
            this.lastUpdate = System.currentTimeMillis();
        }
        return this.value;
    }
}

