/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ExpirationMap<V> {
    private final ConcurrentSkipListMap<Long, Collection<V>> multiMap = new ConcurrentSkipListMap();
    private final ConcurrentHashMap<V, Long> inverse = new ConcurrentHashMap();
    private final long durationMillis;

    public ExpirationMap(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public Set<V> doExpiration() {
        HashSet values = new HashSet();
        NavigableMap headMap = this.multiMap.headMap((Object)System.currentTimeMillis(), true);
        for (Collection collection : headMap.values()) {
            values.addAll(collection);
        }
        headMap.clear();
        for (Object key : values) {
            this.inverse.remove(key);
        }
        return values;
    }

    public void add(V value) {
        Long timestamp = System.currentTimeMillis() + this.durationMillis;
        Long replacedTimestamp = this.inverse.replace((Long)value, timestamp);
        if (replacedTimestamp != null) {
            this.multiMap.computeIfPresent(replacedTimestamp, (oldTimestamp, collection) -> {
                collection.remove(value);
                return collection.isEmpty() ? null : collection;
            });
        }
        this.multiMap.compute(timestamp, (newTimestamp, collection) -> {
            if (collection == null) {
                collection = new HashSet<Object>();
            }
            collection.add(value);
            return collection;
        });
    }

    public void remove(V value) {
        Long removedTimestamp = this.inverse.remove(value);
        if (removedTimestamp != null) {
            this.multiMap.computeIfPresent(removedTimestamp, (oldTimestamp, collection) -> {
                collection.remove(value);
                return collection.isEmpty() ? null : collection;
            });
        }
    }

    public boolean contains(V value) {
        return this.inverse.containsKey(value);
    }

    public void clear() {
        this.multiMap.clear();
        this.inverse.clear();
    }
}

