/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.listeners;

import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.hooks.Hook;
import com.github.jikoo.regionerator.hooks.PluginHook;
import java.util.logging.Level;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class HookListener
implements Listener {
    private final Regionerator plugin;

    public HookListener(Regionerator plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        String pluginName = event.getPlugin().getName();
        if (!this.plugin.getConfig().getBoolean("hooks." + pluginName)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.github.jikoo.regionerator.hooks." + pluginName + "Hook");
            if (!PluginHook.class.isAssignableFrom(clazz)) {
                return;
            }
            PluginHook pluginHook = (PluginHook)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!pluginHook.isHookUsable()) {
                this.plugin.getLogger().severe("Hook for " + pluginName + " failed usability check and could not be enabled!");
                return;
            }
            this.plugin.addHook(pluginHook);
            this.plugin.debug(DebugLevel.LOW, () -> "Enabled protection hook for " + pluginName);
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().severe("Tried to add hook for " + pluginName + ", but it was already enabled!");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().severe("No hook found for " + pluginName + "! Please request compatibility!");
        }
        catch (ReflectiveOperationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to enable hook for " + pluginName + "!", e);
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        String pluginName = event.getPlugin().getName();
        for (Hook hook : this.plugin.getProtectionHooks()) {
            if (!(hook instanceof PluginHook) || !pluginName.equals(((PluginHook)hook).getPluginName())) continue;
            this.plugin.removeHook(hook);
            this.plugin.debug(DebugLevel.LOW, () -> "Disabled protection hook for " + pluginName);
            return;
        }
    }
}

