/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.hooks;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.github.jikoo.regionerator.Coords;
import com.github.jikoo.regionerator.hooks.PluginHook;
import org.bukkit.World;

public class ResidenceHook
extends PluginHook {
    public ResidenceHook() {
        super("Residence");
    }

    @Override
    public boolean isChunkProtected(World chunkWorld, int chunkX, int chunkZ) {
        int minX = Coords.chunkToBlock(chunkX);
        int maxX = minX + 15;
        int minZ = Coords.chunkToBlock(chunkZ);
        int maxZ = minZ + 15;
        for (ClaimedResidence residence : Residence.getInstance().getResidenceManager().getResidences().values()) {
            if (residence.isSubzone() || !chunkWorld.getName().equals(residence.getWorld())) continue;
            for (CuboidArea area : residence.getAreaMap().values()) {
                if (!((double)minX <= area.getHighLoc().getX()) || !((double)maxX >= area.getLowLoc().getX()) || !((double)minZ <= area.getHighLoc().getZ()) || !((double)maxZ >= area.getLowLoc().getZ())) continue;
                return true;
            }
        }
        return false;
    }
}

