/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator.database;

import com.github.jikoo.regionerator.ChunkFlagger;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.database.SQLeadenAdapter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SQLiteAdapter
extends SQLeadenAdapter {
    SQLiteAdapter(@NotNull Regionerator plugin, @NotNull Connection database) throws SQLException {
        super(plugin, database);
        try (Statement st = database.createStatement();){
            st.executeUpdate("CREATE TRIGGER IF NOT EXISTS chunkdataold\nAFTER DELETE ON chunkdata\nWHEN OLD.time NOT NULL AND OLD.chunk_id NOT LIKE '%_old'\nBEGIN\nINSERT INTO chunkdata(chunk_id,time) VALUES (OLD.chunk_id || '_old',OLD.time) ON CONFLICT(chunk_id) DO UPDATE SET `time`=OLD.time;\nEND");
            database.commit();
        }
        catch (SQLException e) {
            plugin.getLogger().severe("An exception setting up database trigger!");
            try {
                DatabaseMetaData metaData = database.getMetaData();
                plugin.getLogger().warning(String.format("SQLite driver: %s %s", metaData.getDriverName(), metaData.getDriverVersion()));
                plugin.getLogger().warning(String.format("SQLite database: %s %s", metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion()));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull Collection<ChunkFlagger.FlagData> flags) throws SQLException {
        Connection connection = this.database;
        synchronized (connection) {
            try (PreparedStatement upsert = this.database.prepareStatement("INSERT INTO chunkdata(chunk_id,time) VALUES (?,?) ON CONFLICT(chunk_id) DO UPDATE SET time=excluded.time WHERE excluded.time>chunkdata.time");
                 PreparedStatement delete = this.database.prepareStatement("DELETE FROM chunkdata WHERE chunk_id=?");){
                for (ChunkFlagger.FlagData data : flags) {
                    if (data.getLastVisit() == -1L) {
                        delete.setString(1, data.getChunkId());
                        delete.addBatch();
                        continue;
                    }
                    upsert.setString(1, data.getChunkId());
                    upsert.setLong(2, data.getLastVisit());
                    upsert.addBatch();
                }
                delete.executeBatch();
                upsert.executeBatch();
                this.database.commit();
            }
        }
    }
}

