/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.regionerator;

import com.github.jikoo.regionerator.DebugLevel;
import com.github.jikoo.regionerator.Regionerator;
import com.github.jikoo.regionerator.VisitStatus;
import com.github.jikoo.regionerator.world.ChunkInfo;
import com.github.jikoo.regionerator.world.RegionInfo;
import com.github.jikoo.regionerator.world.WorldInfo;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DeletionRunnable
extends BukkitRunnable {
    private static final String STATS_FORMAT = "%s: checked %s, deleted %s regions & %s chunks";
    private final Regionerator plugin;
    private final Phaser phaser;
    private final WorldInfo world;
    private final AtomicLong nextRun = new AtomicLong(Long.MAX_VALUE);
    private final AtomicInteger regionCount = new AtomicInteger();
    private final AtomicInteger chunkCount = new AtomicInteger();
    private final AtomicInteger regionsDeleted = new AtomicInteger();
    private final AtomicInteger chunksDeleted = new AtomicInteger();

    DeletionRunnable(Regionerator plugin, World world) {
        this.plugin = plugin;
        this.phaser = new Phaser(1);
        this.world = plugin.getWorldManager().getWorld(world);
    }

    public void run() {
        this.world.getRegions().forEach(this::handleRegion);
        this.plugin.getLogger().info("Regeneration cycle complete for " + this.getRunStats());
        this.nextRun.set(System.currentTimeMillis() + this.plugin.config().getMillisBetweenCycles());
        if (this.plugin.config().isRememberCycleDelay()) {
            try {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.finishCycle(this));
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
        }
        this.phaser.arriveAndDeregister();
    }

    private void handleRegion(RegionInfo region) {
        if (this.isCancelled()) {
            return;
        }
        this.phaser.arriveAndAwaitAdvance();
        this.regionCount.incrementAndGet();
        this.plugin.debug(DebugLevel.HIGH, () -> String.format("Checking %s:%s (%s)", this.world.getWorld().getName(), region.getIdentifier(), this.regionCount.get()));
        try {
            region.read();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to read region!", e);
            return;
        }
        List<ChunkInfo> chunks = region.getChunks().filter(this::isDeleteEligible).collect(Collectors.toList());
        if (chunks.size() != 1024) {
            chunks.removeIf(chunk -> {
                if (this.isCancelled()) {
                    return true;
                }
                VisitStatus visitStatus = chunk.getVisitStatus();
                return visitStatus == VisitStatus.ORPHANED || !this.plugin.config().isDeleteFreshChunks() && visitStatus == VisitStatus.GENERATED;
            });
            chunks.forEach(ChunkInfo::setOrphaned);
        }
        try {
            region.write();
            chunks.forEach(chunk -> this.plugin.getFlagger().unflagChunk(chunk.getWorld().getName(), chunk.getChunkX(), chunk.getChunkZ()));
            if (chunks.size() == 1024) {
                this.regionsDeleted.incrementAndGet();
            } else {
                this.chunksDeleted.addAndGet(chunks.size());
            }
        }
        catch (IOException e) {
            this.plugin.debug(() -> String.format("Caught an IOException attempting to populate chunk data: %s", e.getMessage()), e);
        }
        if (this.regionCount.get() % 20 == 0) {
            this.plugin.debug(DebugLevel.LOW, this::getRunStats);
        }
        try {
            Thread.sleep(this.plugin.config().getDeletionRecoveryMillis());
            this.chunkCount.set(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isDeleteEligible(ChunkInfo chunkInfo) {
        VisitStatus visitStatus;
        boolean isFresh;
        if (this.isCancelled()) {
            this.plugin.debug(DebugLevel.HIGH, () -> "Deletion task is cancelled, chunks are ineligible for delete.");
            return false;
        }
        if (chunkInfo.isOrphaned()) {
            this.plugin.debug(DebugLevel.HIGH, () -> String.format("%s: %s, %s is already orphaned.", chunkInfo.getRegionInfo().getIdentifier(), chunkInfo.getChunkX(), chunkInfo.getChunkX()));
            return true;
        }
        long now = System.currentTimeMillis();
        long lastVisit = chunkInfo.getLastVisit();
        boolean bl = isFresh = !this.plugin.config().isDeleteFreshChunks() && lastVisit == this.plugin.config().getFlagGenerated();
        if (!isFresh && now <= lastVisit) {
            this.plugin.debug(DebugLevel.HIGH, () -> String.format("%s: %s, %s is visited until %s", chunkInfo.getRegionInfo().getIdentifier(), chunkInfo.getChunkX(), chunkInfo.getChunkZ(), lastVisit));
            return false;
        }
        if (!isFresh && now - this.plugin.config().getFlagDuration() <= chunkInfo.getLastModified()) {
            this.plugin.debug(DebugLevel.HIGH, () -> String.format("%s: %s, %s is modified until %s", chunkInfo.getRegionInfo().getIdentifier(), chunkInfo.getChunkX(), chunkInfo.getChunkZ(), chunkInfo.getLastModified()));
            return false;
        }
        if (this.chunkCount.incrementAndGet() % this.plugin.config().getDeletionChunkCount() == 0) {
            try {
                Thread.sleep(this.plugin.config().getDeletionRecoveryMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.plugin.debug(DebugLevel.HIGH)) {
            this.plugin.getDebugListener().monitorChunk(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
        }
        try {
            visitStatus = chunkInfo.getVisitStatus();
        }
        catch (RuntimeException e) {
            if (!this.isCancelled() && this.plugin.isEnabled()) {
                this.plugin.debug(() -> String.format("Caught an exception getting VisitStatus: %s", e.getMessage()), e);
            }
            visitStatus = VisitStatus.UNKNOWN;
        }
        if (this.plugin.debug(DebugLevel.HIGH)) {
            this.plugin.getDebugListener().ignoreChunk(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
        }
        return visitStatus.ordinal() < VisitStatus.VISITED.ordinal();
    }

    public String getRunStats() {
        return String.format(STATS_FORMAT, this.world.getWorld().getName(), this.regionCount.get(), this.regionsDeleted, this.chunksDeleted);
    }

    public String getWorld() {
        return this.world.getWorld().getName();
    }

    public long getNextRun() {
        return this.nextRun.get();
    }

    Phaser getPhaser() {
        return this.phaser;
    }
}

