/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.freehaven.tor.control.Bytes;
import net.freehaven.tor.control.ConfigEntry;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlCommands;
import net.freehaven.tor.control.TorControlError;
import net.freehaven.tor.control.TorControlSyntaxError;
import net.freehaven.tor.control.TorControlTimeoutError;

public class TorControlConnection
implements TorControlCommands {
    private final LinkedList<Waiter> waiters;
    private final BufferedReader input;
    private final Writer output;
    private ControlParseThread thread;
    private volatile EventHandler handler;
    private volatile PrintWriter debugOutput;
    private volatile IOException parseThreadException;
    private static final String[] algorithms = new String[]{"RSA1024", "ED25519-V3"};

    public TorControlConnection(Socket connection) throws IOException {
        this(connection.getInputStream(), connection.getOutputStream());
    }

    public TorControlConnection(InputStream i, OutputStream o) {
        this(new InputStreamReader(i), new OutputStreamWriter(o));
    }

    public TorControlConnection(Reader i, Writer o) {
        this.output = o;
        this.input = i instanceof BufferedReader ? (BufferedReader)i : new BufferedReader(i);
        this.waiters = new LinkedList();
    }

    protected final void writeEscaped(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith(".")) {
                line = "." + line;
            }
            line = line.endsWith("\r") ? line + "\n" : line + "\r\n";
            if (this.debugOutput != null) {
                this.debugOutput.print(">> " + line);
            }
            this.output.write(line);
        }
        this.output.write(".\r\n");
        if (this.debugOutput != null) {
            this.debugOutput.print(">> .\n");
        }
    }

    protected static final String quote(String s) {
        StringBuffer sb = new StringBuffer("\"");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    protected final ArrayList<ReplyLine> readReply() throws IOException {
        char c;
        ArrayList<ReplyLine> reply = new ArrayList<ReplyLine>();
        do {
            String line;
            if ((line = this.input.readLine()) == null) {
                if (reply.isEmpty()) {
                    return reply;
                }
                throw new TorControlSyntaxError("Connection to Tor  broke down while receiving reply!");
            }
            if (this.debugOutput != null) {
                this.debugOutput.println("<< " + line);
            }
            if (line.length() < 4) {
                throw new TorControlSyntaxError("Line (\"" + line + "\") too short");
            }
            String status = line.substring(0, 3);
            c = line.charAt(3);
            String msg = line.substring(4);
            String rest = null;
            if (c == '+') {
                StringBuffer data = new StringBuffer();
                while (true) {
                    line = this.input.readLine();
                    if (this.debugOutput != null) {
                        this.debugOutput.print("<< " + line);
                    }
                    if (line.equals(".")) break;
                    if (line.startsWith(".")) {
                        line = line.substring(1);
                    }
                    data.append(line).append('\n');
                }
                rest = data.toString();
            }
            reply.add(new ReplyLine(status, msg, rest));
        } while (c != ' ');
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<ReplyLine> sendAndWaitForResponse(String s, String rest) throws IOException {
        List<ReplyLine> lst;
        if (this.parseThreadException != null) {
            throw this.parseThreadException;
        }
        this.checkThread();
        Waiter w = new Waiter();
        if (this.debugOutput != null) {
            this.debugOutput.print(">> " + s);
        }
        LinkedList<Waiter> linkedList = this.waiters;
        synchronized (linkedList) {
            this.waiters.addLast(w);
            this.output.write(s);
            if (rest != null) {
                this.writeEscaped(rest);
            }
            this.output.flush();
        }
        try {
            lst = w.getResponse();
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted");
        }
        catch (TimeoutException e) {
            if (null != this.handler) {
                this.handler.timeout();
            }
            throw new TorControlTimeoutError("We did not receive a response within one minute of waiting.");
        }
        for (ReplyLine c : lst) {
            if (c.status.startsWith("2")) continue;
            throw new TorControlError(Integer.valueOf(c.status), "Error reply: " + c.msg);
        }
        return lst;
    }

    protected void handleEvent(ArrayList<ReplyLine> events) {
        if (this.handler == null) {
            return;
        }
        for (ReplyLine line : events) {
            List<String> lst;
            if (line.msg.startsWith("OK")) continue;
            int idx = line.msg.indexOf(32);
            String tp = line.msg.substring(0, idx).toUpperCase();
            String rest = line.msg.substring(idx + 1);
            if (tp.equals("CIRC")) {
                this.handler.circuitStatus(lst.get(1), lst.get(0), (lst = Bytes.splitStr(null, rest)).get(1).equals("LAUNCHED") || lst.size() < 3 ? "" : lst.get(2));
                continue;
            }
            if (tp.equals("STREAM")) {
                lst = Bytes.splitStr(null, rest);
                this.handler.streamStatus(lst.get(1), lst.get(0), lst.get(3));
                continue;
            }
            if (tp.equals("ORCONN")) {
                lst = Bytes.splitStr(null, rest);
                this.handler.orConnStatus(lst.get(1), lst.get(0));
                continue;
            }
            if (tp.equals("BW")) {
                lst = Bytes.splitStr(null, rest);
                this.handler.bandwidthUsed(Integer.parseInt(lst.get(0)), Integer.parseInt(lst.get(1)));
                continue;
            }
            if (tp.equals("NEWDESC")) {
                lst = Bytes.splitStr(null, rest);
                this.handler.newDescriptors(lst);
                continue;
            }
            if (tp.equals("DEBUG") || tp.equals("INFO") || tp.equals("NOTICE") || tp.equals("WARN") || tp.equals("ERR")) {
                this.handler.message(tp, rest);
                continue;
            }
            if (tp.equals("HS_DESC")) {
                lst = Bytes.splitStr(null, rest);
                if ("FAILED".equals(lst.get(0))) {
                    Matcher matcher = Pattern.compile("REASON=([^\\s]*)").matcher(rest);
                    this.handler.hiddenServiceFailedEvent(matcher.find() ? matcher.group(1) : "NO_REASON", rest);
                    continue;
                }
                this.handler.hiddenServiceEvent(lst.get(0), rest);
                continue;
            }
            if (tp.equals("HS_DESC_CONTENT")) {
                this.handler.hiddenServiceDescriptor(lst.get(1), (lst = Bytes.splitStr(null, rest)).size() > 3 ? lst.get(3) : "NO_DESCRIPTOR", rest);
                continue;
            }
            this.handler.unrecognized(tp, rest);
        }
    }

    public void setDebugging(PrintWriter w) {
        this.debugOutput = w;
    }

    public void setDebugging(PrintStream s) {
        this.debugOutput = new PrintWriter(s, true);
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public synchronized Thread launchThread(boolean daemon) {
        ControlParseThread th = new ControlParseThread();
        if (daemon) {
            th.setDaemon(true);
        }
        th.start();
        this.thread = th;
        return th;
    }

    protected synchronized void checkThread() {
        if (this.thread == null) {
            this.launchThread(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void react() throws IOException {
        ArrayList<ReplyLine> lst;
        while (!(lst = this.readReply()).isEmpty()) {
            if (lst.get((int)0).status.startsWith("6")) {
                this.handleEvent(lst);
                continue;
            }
            LinkedList<Waiter> linkedList = this.waiters;
            synchronized (linkedList) {
                if (!this.waiters.isEmpty()) {
                    Waiter w = this.waiters.removeFirst();
                    w.setResponse(lst);
                }
            }
        }
        return;
    }

    public void resetConf(String keyword) throws IOException {
        StringBuffer b = new StringBuffer("RESETCONF");
        b.append(" ").append(keyword);
        b.append("\r\n");
        this.sendAndWaitForResponse(b.toString(), null);
    }

    public void setConf(String key, String value) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(key + " " + value);
        this.setConf(lst);
    }

    public void setConf(Map<String, String> kvMap) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        for (Map.Entry<String, String> ent : kvMap.entrySet()) {
            lst.add(ent.getKey() + " " + ent.getValue() + "\n");
        }
        this.setConf(lst);
    }

    public void setConf(Collection<String> kvList) throws IOException {
        if (kvList.size() == 0) {
            return;
        }
        StringBuffer b = new StringBuffer("SETCONF");
        for (String kv : kvList) {
            int i = kv.indexOf(32);
            if (i == -1) {
                b.append(" ").append(kv);
            }
            b.append(" ").append(kv.substring(0, i)).append("=").append(TorControlConnection.quote(kv.substring(i + 1)));
        }
        b.append("\r\n");
        this.sendAndWaitForResponse(b.toString(), null);
    }

    public void resetConf(Collection<String> keys) throws IOException {
        if (keys.size() == 0) {
            return;
        }
        StringBuffer b = new StringBuffer("RESETCONF");
        for (String key : keys) {
            b.append(" ").append(key);
        }
        b.append("\r\n");
        this.sendAndWaitForResponse(b.toString(), null);
    }

    public List<ConfigEntry> getConf(String key) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(key);
        return this.getConf(lst);
    }

    public List<ConfigEntry> getConf(Collection<String> keys) throws IOException {
        StringBuffer sb = new StringBuffer("GETCONF");
        for (String key : keys) {
            sb.append(" ").append(key);
        }
        sb.append("\r\n");
        List<ReplyLine> lst = this.sendAndWaitForResponse(sb.toString(), null);
        ArrayList<ConfigEntry> result = new ArrayList<ConfigEntry>();
        Iterator<ReplyLine> it = lst.iterator();
        while (it.hasNext()) {
            String kv = it.next().msg;
            int idx = kv.indexOf(61);
            if (idx >= 0) {
                result.add(new ConfigEntry(kv.substring(0, idx), kv.substring(idx + 1)));
                continue;
            }
            result.add(new ConfigEntry(kv));
        }
        return result;
    }

    public void setEvents(List<String> events) throws IOException {
        StringBuffer sb = new StringBuffer("SETEVENTS");
        Iterator<String> it = events.iterator();
        while (it.hasNext()) {
            sb.append(" ").append(it.next());
        }
        sb.append("\r\n");
        this.sendAndWaitForResponse(sb.toString(), null);
    }

    public void authenticate(byte[] auth) throws IOException {
        String cmd = "AUTHENTICATE " + Bytes.hex(auth) + "\r\n";
        this.sendAndWaitForResponse(cmd, null);
    }

    public void saveConf() throws IOException {
        this.sendAndWaitForResponse("SAVECONF\r\n", null);
    }

    public boolean isHSAvailable(String onionurl) throws IOException {
        List<ReplyLine> response = this.sendAndWaitForResponse("HSFETCH " + onionurl + "\r\n", null);
        return response.get((int)0).status.trim().equals("250");
    }

    public void signal(String signal) throws IOException {
        String cmd = "SIGNAL " + signal + "\r\n";
        this.sendAndWaitForResponse(cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTor(String signal) throws IOException {
        String s = "SIGNAL " + signal + "\r\n";
        if (this.debugOutput != null) {
            this.debugOutput.print(">> " + s);
        }
        LinkedList<Waiter> linkedList = this.waiters;
        synchronized (linkedList) {
            this.output.write(s);
            this.output.flush();
        }
    }

    public Map<String, String> mapAddresses(Collection<String> kvLines) throws IOException {
        StringBuffer sb = new StringBuffer("MAPADDRESS");
        for (String kv : kvLines) {
            int i = kv.indexOf(32);
            sb.append(" ").append(kv.substring(0, i)).append("=").append(TorControlConnection.quote(kv.substring(i + 1)));
        }
        sb.append("\r\n");
        List<ReplyLine> lst = this.sendAndWaitForResponse(sb.toString(), null);
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<ReplyLine> it = lst.iterator();
        while (it.hasNext()) {
            String kv = it.next().msg;
            int idx = kv.indexOf(61);
            result.put(kv.substring(0, idx), kv.substring(idx + 1));
        }
        return result;
    }

    public Map<String, String> mapAddresses(Map<String, String> addresses) throws IOException {
        ArrayList<String> kvList = new ArrayList<String>();
        for (Map.Entry<String, String> e : addresses.entrySet()) {
            kvList.add(e.getKey() + " " + e.getValue());
        }
        return this.mapAddresses(kvList);
    }

    public String mapAddress(String fromAddr, String toAddr) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(fromAddr + " " + toAddr + "\n");
        Map<String, String> m = this.mapAddresses(lst);
        return m.get(fromAddr);
    }

    public Map<String, String> getInfo(Collection<String> keys) throws IOException {
        StringBuffer sb = new StringBuffer("GETINFO");
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            sb.append(" ").append(it.next());
        }
        sb.append("\r\n");
        List<ReplyLine> lst = this.sendAndWaitForResponse(sb.toString(), null);
        HashMap<String, String> m = new HashMap<String, String>();
        for (ReplyLine line : lst) {
            int idx = line.msg.indexOf(61);
            if (idx < 0) break;
            String k = line.msg.substring(0, idx);
            String v = line.rest != null ? line.rest : line.msg.substring(idx + 1);
            m.put(k, v);
        }
        return m;
    }

    public String getInfo(String key) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(key);
        Map<String, String> m = this.getInfo(lst);
        return m.get(key);
    }

    public String extendCircuit(String circID, String path) throws IOException {
        List<ReplyLine> lst = this.sendAndWaitForResponse("EXTENDCIRCUIT " + circID + " " + path + "\r\n", null);
        return lst.get((int)0).msg;
    }

    public void attachStream(String streamID, String circID) throws IOException {
        this.sendAndWaitForResponse("ATTACHSTREAM " + streamID + " " + circID + "\r\n", null);
    }

    public String postDescriptor(String desc) throws IOException {
        List<ReplyLine> lst = this.sendAndWaitForResponse("+POSTDESCRIPTOR\r\n", desc);
        return lst.get((int)0).msg;
    }

    public void redirectStream(String streamID, String address) throws IOException {
        this.sendAndWaitForResponse("REDIRECTSTREAM " + streamID + " " + address + "\r\n", null);
    }

    public void closeStream(String streamID, byte reason) throws IOException {
        this.sendAndWaitForResponse("CLOSESTREAM " + streamID + " " + reason + "\r\n", null);
    }

    public void closeCircuit(String circID, boolean ifUnused) throws IOException {
        this.sendAndWaitForResponse("CLOSECIRCUIT " + circID + (ifUnused ? " IFUNUSED" : "") + "\r\n", null);
    }

    public void takeOwnership() throws IOException {
        this.sendAndWaitForResponse("TAKEOWNERSHIP\r\n", null);
    }

    public void forgetHiddenService(String hostname) throws IOException {
        this.sendAndWaitForResponse("FORGETHS " + hostname + "\r\n", null);
    }

    public CreateHiddenServiceResult createHiddenService(Integer port) throws IOException {
        return this.createHiddenService(port, -1, "NEW:BEST");
    }

    public CreateHiddenServiceResult createHiddenService(Integer virtPort, Integer targetPort) throws IOException {
        return this.createHiddenService(virtPort, targetPort, "NEW:BEST");
    }

    public CreateHiddenServiceResult createHiddenService(Integer port, String private_key) throws IOException {
        return this.createHiddenService(port, -1, private_key);
    }

    public CreateHiddenServiceResult createHiddenService(Integer virtPort, Integer targetPort, String private_key) throws IOException {
        List<ReplyLine> result;
        String port = virtPort.toString();
        if (targetPort > 0) {
            port = port + "," + targetPort;
        }
        if (null == (result = this.sendAndWaitForResponse("ADD_ONION " + this.getEncodePrivateKey(private_key) + " Port=" + port + "\r\n", null))) {
            throw new IOException("We should not be here. Contact the developers!");
        }
        CreateHiddenServiceResult creationResult = new CreateHiddenServiceResult(result.get((int)0).msg.replace("ServiceID=", ""), private_key.contains("NEW") ? result.get((int)1).msg.replace("PrivateKey=", "") : private_key);
        this.isHSAvailable(creationResult.serviceID);
        return creationResult;
    }

    private String getEncodePrivateKey(String keyBytes) {
        if (keyBytes.startsWith("NEW")) {
            return keyBytes;
        }
        String algorithm = keyBytes.contains("-BEGIN RSA PRIVATE KEY-") ? algorithms[0] : algorithms[1];
        String temp = new String(keyBytes);
        String privKeyPEM = temp.replaceAll("-----(BEGIN|END) ?[A-Z]* PRIVATE KEY-----", "");
        privKeyPEM = privKeyPEM.replaceAll("\n", "");
        return algorithm + ":" + privKeyPEM;
    }

    public void destroyHiddenService(String name) throws IOException {
        this.sendAndWaitForResponse("DEL_ONION " + name + "\r\n", null);
    }

    public AuthChallengeResult authChallenge(byte[] clientNonce) throws IOException {
        List<ReplyLine> result = this.sendAndWaitForResponse("AUTHCHALLENGE SAFECOOKIE " + TorControlConnection.byteArrayToHexString(clientNonce) + "\r\n", null);
        if (!"250".equals(result.get((int)0).status)) {
            String error = "";
            for (ReplyLine line : result) {
                error = error + line.status + " " + line.msg + ",";
            }
            throw new IOException("Connection failed: " + error);
        }
        String tmp = result.get((int)0).msg;
        String SERVERHASH = "SERVERHASH";
        String serverhash = tmp.substring(tmp.indexOf("=") + 1, tmp.indexOf(" ", tmp.indexOf("SERVERHASH") + "SERVERHASH".length()));
        return new AuthChallengeResult(TorControlConnection.hexStringToByteArray(serverhash), TorControlConnection.hexStringToByteArray(tmp.substring(tmp.lastIndexOf("=") + 1)));
    }

    private static String byteArrayToHexString(byte[] b) {
        Character[] base16 = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F')};
        String result = "";
        for (byte current : b) {
            result = result + base16[(current & 0xFF) >> 4] + "" + base16[current & 0xF];
        }
        return result;
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public class AuthChallengeResult {
        public final byte[] serverHash;
        public final byte[] serverNonce;

        public AuthChallengeResult(byte[] serverHash, byte[] serverNonce) {
            this.serverHash = serverHash;
            this.serverNonce = serverNonce;
        }
    }

    public class CreateHiddenServiceResult {
        public final String serviceID;
        public final String privateKey;

        public CreateHiddenServiceResult(String serviceID, String privateKey) throws IOException {
            this.serviceID = serviceID;
            if (privateKey.startsWith("-----BEGIN")) {
                this.privateKey = privateKey;
            } else {
                String type;
                if (privateKey.startsWith(algorithms[0])) {
                    type = "RSA";
                } else if (privateKey.startsWith(algorithms[1])) {
                    type = "OPENSSH";
                } else {
                    throw new IOException("Unsupported private_key algorithm. Did Tor get a new key type for hidden services?");
                }
                this.privateKey = "-----BEGIN " + type + " PRIVATE KEY-----\n" + privateKey.substring(privateKey.indexOf(":") + 1) + "\n-----END " + type + " PRIVATE KEY-----";
            }
        }
    }

    protected class ControlParseThread
    extends Thread {
        public ControlParseThread() {
            this.setName("TorControlParser");
        }

        @Override
        public void run() {
            try {
                TorControlConnection.this.react();
            }
            catch (IOException ex) {
                TorControlConnection.this.parseThreadException = ex;
            }
        }
    }

    static class ReplyLine {
        final String status;
        final String msg;
        final String rest;

        ReplyLine(String status, String msg, String rest) {
            this.status = status;
            this.msg = msg;
            this.rest = rest;
        }
    }

    static class Waiter {
        Lock lock = new ReentrantLock();
        Condition dataReady = this.lock.newCondition();
        List<ReplyLine> response;

        Waiter() {
        }

        List<ReplyLine> getResponse() throws InterruptedException, TimeoutException {
            this.lock.lock();
            try {
                if (null != this.response) {
                    List<ReplyLine> list = this.response;
                    return list;
                }
                if (!this.dataReady.await(1L, TimeUnit.MINUTES)) {
                    throw new TimeoutException();
                }
                List<ReplyLine> list = this.response;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        void setResponse(List<ReplyLine> response) {
            this.lock.lock();
            try {
                this.response = response;
                this.dataReady.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

