/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.DisplayMetricsInfo;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.internal.CustomAdapt;
import me.jessyan.autosize.utils.Preconditions;

public final class AutoSizeCompat {
    private static SparseArray<DisplayMetricsInfo> mCache = new SparseArray();
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    private static final int MODE_ON_WIDTH = 0x40000000;
    private static final int MODE_DEVICE_SIZE = Integer.MIN_VALUE;

    private AutoSizeCompat() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static void autoConvertDensityOfGlobal(Resources resources) {
        if (AutoSizeConfig.getInstance().isBaseOnWidth()) {
            AutoSizeCompat.autoConvertDensityBaseOnWidth(resources, AutoSizeConfig.getInstance().getDesignWidthInDp());
        } else {
            AutoSizeCompat.autoConvertDensityBaseOnHeight(resources, AutoSizeConfig.getInstance().getDesignHeightInDp());
        }
    }

    public static void autoConvertDensityOfCustomAdapt(Resources resources, CustomAdapt customAdapt) {
        Preconditions.checkNotNull(customAdapt, "customAdapt == null");
        float sizeInDp = customAdapt.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = customAdapt.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSizeCompat.autoConvertDensity(resources, sizeInDp, customAdapt.isBaseOnWidth());
    }

    public static void autoConvertDensityOfExternalAdaptInfo(Resources resources, ExternalAdaptInfo externalAdaptInfo) {
        Preconditions.checkNotNull(externalAdaptInfo, "externalAdaptInfo == null");
        float sizeInDp = externalAdaptInfo.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = externalAdaptInfo.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSizeCompat.autoConvertDensity(resources, sizeInDp, externalAdaptInfo.isBaseOnWidth());
    }

    public static void autoConvertDensityBaseOnWidth(Resources resources, float designWidthInDp) {
        AutoSizeCompat.autoConvertDensity(resources, designWidthInDp, true);
    }

    public static void autoConvertDensityBaseOnHeight(Resources resources, float designHeightInDp) {
        AutoSizeCompat.autoConvertDensity(resources, designHeightInDp, false);
    }

    public static void autoConvertDensity(Resources resources, float sizeInDp, boolean isBaseOnWidth) {
        int targetScreenHeightDp;
        int targetScreenWidthDp;
        Preconditions.checkNotNull(resources, "resources == null");
        Preconditions.checkMainThread();
        float subunitsDesignSize = isBaseOnWidth ? AutoSizeConfig.getInstance().getUnitsManager().getDesignWidth() : AutoSizeConfig.getInstance().getUnitsManager().getDesignHeight();
        subunitsDesignSize = subunitsDesignSize > 0.0f ? subunitsDesignSize : sizeInDp;
        int screenSize = isBaseOnWidth ? AutoSizeConfig.getInstance().getScreenWidth() : AutoSizeConfig.getInstance().getScreenHeight();
        int key = Math.round((sizeInDp + subunitsDesignSize + (float)screenSize) * AutoSizeConfig.getInstance().getInitScaledDensity()) & 0x3FFFFFFF;
        key = isBaseOnWidth ? key | 0x40000000 : key & 0xBFFFFFFF;
        key = AutoSizeConfig.getInstance().isUseDeviceSize() ? key | Integer.MIN_VALUE : key & Integer.MAX_VALUE;
        DisplayMetricsInfo displayMetricsInfo = (DisplayMetricsInfo)mCache.get(key);
        float targetDensity = 0.0f;
        int targetDensityDpi = 0;
        float targetScaledDensity = 0.0f;
        float targetXdpi = 0.0f;
        if (displayMetricsInfo == null) {
            targetDensity = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / sizeInDp : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / sizeInDp;
            if (AutoSizeConfig.getInstance().getPrivateFontScale() > 0.0f) {
                targetScaledDensity = targetDensity * AutoSizeConfig.getInstance().getPrivateFontScale();
            } else {
                float systemFontScale = AutoSizeConfig.getInstance().isExcludeFontScale() ? 1.0f : AutoSizeConfig.getInstance().getInitScaledDensity() * 1.0f / AutoSizeConfig.getInstance().getInitDensity();
                targetScaledDensity = targetDensity * systemFontScale;
            }
            targetDensityDpi = (int)(targetDensity * 160.0f);
            targetScreenWidthDp = (int)((float)AutoSizeConfig.getInstance().getScreenWidth() / targetDensity);
            targetScreenHeightDp = (int)((float)AutoSizeConfig.getInstance().getScreenHeight() / targetDensity);
            targetXdpi = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / subunitsDesignSize : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / subunitsDesignSize;
            mCache.put(key, (Object)new DisplayMetricsInfo(targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi, targetScreenWidthDp, targetScreenHeightDp));
        } else {
            targetDensity = displayMetricsInfo.getDensity();
            targetDensityDpi = displayMetricsInfo.getDensityDpi();
            targetScaledDensity = displayMetricsInfo.getScaledDensity();
            targetXdpi = displayMetricsInfo.getXdpi();
            targetScreenWidthDp = displayMetricsInfo.getScreenWidthDp();
            targetScreenHeightDp = displayMetricsInfo.getScreenHeightDp();
        }
        AutoSizeCompat.setDensity(resources, targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi);
        AutoSizeCompat.setScreenSizeDp(resources, targetScreenWidthDp, targetScreenHeightDp);
    }

    public static void cancelAdapt(Resources resources) {
        Preconditions.checkMainThread();
        float initXdpi = AutoSizeConfig.getInstance().getInitXdpi();
        switch (AutoSizeConfig.getInstance().getUnitsManager().getSupportSubunits()) {
            case PT: {
                initXdpi /= 72.0f;
                break;
            }
            case MM: {
                initXdpi /= 25.4f;
                break;
            }
        }
        AutoSizeCompat.setDensity(resources, AutoSizeConfig.getInstance().getInitDensity(), AutoSizeConfig.getInstance().getInitDensityDpi(), AutoSizeConfig.getInstance().getInitScaledDensity(), initXdpi);
        AutoSizeCompat.setScreenSizeDp(resources, AutoSizeConfig.getInstance().getInitScreenWidthDp(), AutoSizeConfig.getInstance().getInitScreenHeightDp());
    }

    private static void setDensity(Resources resources, float density, int densityDpi, float scaledDensity, float xdpi) {
        DisplayMetrics activityDisplayMetrics = resources.getDisplayMetrics();
        AutoSizeCompat.setDensity(activityDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        DisplayMetrics appDisplayMetrics = AutoSizeConfig.getInstance().getApplication().getResources().getDisplayMetrics();
        AutoSizeCompat.setDensity(appDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        DisplayMetrics activityDisplayMetricsOnMIUI = AutoSizeCompat.getMetricsOnMiui(resources);
        DisplayMetrics appDisplayMetricsOnMIUI = AutoSizeCompat.getMetricsOnMiui(AutoSizeConfig.getInstance().getApplication().getResources());
        if (activityDisplayMetricsOnMIUI != null) {
            AutoSizeCompat.setDensity(activityDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
        if (appDisplayMetricsOnMIUI != null) {
            AutoSizeCompat.setDensity(appDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
    }

    private static void setDensity(DisplayMetrics displayMetrics, float density, int densityDpi, float scaledDensity, float xdpi) {
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportDP()) {
            displayMetrics.density = density;
            displayMetrics.densityDpi = densityDpi;
        }
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportSP()) {
            displayMetrics.scaledDensity = scaledDensity;
        }
        switch (AutoSizeConfig.getInstance().getUnitsManager().getSupportSubunits()) {
            case NONE: {
                break;
            }
            case PT: {
                displayMetrics.xdpi = xdpi * 72.0f;
                break;
            }
            case IN: {
                displayMetrics.xdpi = xdpi;
                break;
            }
            case MM: {
                displayMetrics.xdpi = xdpi * 25.4f;
                break;
            }
        }
    }

    private static void setScreenSizeDp(Resources resources, int screenWidthDp, int screenHeightDp) {
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportDP() && AutoSizeConfig.getInstance().getUnitsManager().isSupportScreenSizeDP()) {
            Configuration activityConfiguration = resources.getConfiguration();
            AutoSizeCompat.setScreenSizeDp(activityConfiguration, screenWidthDp, screenHeightDp);
            Configuration appConfiguration = AutoSizeConfig.getInstance().getApplication().getResources().getConfiguration();
            AutoSizeCompat.setScreenSizeDp(appConfiguration, screenWidthDp, screenHeightDp);
        }
    }

    private static void setScreenSizeDp(Configuration configuration, int screenWidthDp, int screenHeightDp) {
        configuration.screenWidthDp = screenWidthDp;
        configuration.screenHeightDp = screenHeightDp;
    }

    private static DisplayMetrics getMetricsOnMiui(Resources resources) {
        if (AutoSizeConfig.getInstance().isMiui() && AutoSizeConfig.getInstance().getTmpMetricsField() != null) {
            try {
                return (DisplayMetrics)AutoSizeConfig.getInstance().getTmpMetricsField().get(resources);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

