/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.app.Activity;
import java.util.Locale;
import me.jessyan.autosize.AutoAdaptStrategy;
import me.jessyan.autosize.AutoSize;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.internal.CancelAdapt;
import me.jessyan.autosize.internal.CustomAdapt;
import me.jessyan.autosize.utils.LogUtils;

public class DefaultAutoAdaptStrategy
implements AutoAdaptStrategy {
    @Override
    public void applyAdapt(Activity activity) {
        if (AutoSizeConfig.getInstance().getExternalAdaptManager().isRun()) {
            if (AutoSizeConfig.getInstance().getExternalAdaptManager().isCancelAdapt(activity.getClass())) {
                LogUtils.w(String.format(Locale.ENGLISH, "%s canceled the adaptation!", activity.getClass().getName()));
                AutoSize.cancelAdapt(activity);
                return;
            }
            ExternalAdaptInfo info = AutoSizeConfig.getInstance().getExternalAdaptManager().getExternalAdaptInfoOfActivity(activity.getClass());
            if (info != null) {
                LogUtils.d(String.format(Locale.ENGLISH, "%s used %s for adaptation!", activity.getClass().getName(), ExternalAdaptInfo.class.getName()));
                AutoSize.autoConvertDensityOfExternalAdaptInfo(activity, info);
                return;
            }
        }
        if (activity instanceof CancelAdapt) {
            LogUtils.w(String.format(Locale.ENGLISH, "%s canceled the adaptation!", activity.getClass().getName()));
            AutoSize.cancelAdapt(activity);
            return;
        }
        if (activity instanceof CustomAdapt) {
            LogUtils.d(String.format(Locale.ENGLISH, "%s implemented by %s!", activity.getClass().getName(), CustomAdapt.class.getName()));
            AutoSize.autoConvertDensityOfCustomAdapt(activity, (CustomAdapt)activity);
        } else {
            LogUtils.d(String.format(Locale.ENGLISH, "%s used the global configuration.", activity.getClass().getName()));
            AutoSize.autoConvertDensityOfGlobal(activity);
        }
    }
}

