/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import me.jessyan.autosize.ActivityLifecycleCallbacksImpl;
import me.jessyan.autosize.AutoAdaptStrategy;
import me.jessyan.autosize.AutoSize;
import me.jessyan.autosize.DefaultAutoAdaptStrategy;
import me.jessyan.autosize.external.ExternalAdaptManager;
import me.jessyan.autosize.utils.LogUtils;
import me.jessyan.autosize.utils.Preconditions;
import me.jessyan.autosize.utils.ScreenUtils;

public final class AutoSizeConfig {
    private static volatile AutoSizeConfig sInstance;
    private static final String KEY_DESIGN_WIDTH_IN_DP = "design_width_in_dp";
    private static final String KEY_DESIGN_HEIGHT_IN_DP = "design_height_in_dp";
    private Application mApplication;
    private ExternalAdaptManager mExternalAdaptManager = new ExternalAdaptManager();
    private float mInitDensity = -1.0f;
    private int mInitDensityDpi;
    private float mInitScaledDensity;
    private int mDesignWidthInDp;
    private int mDesignHeightInDp;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean isBaseOnWidth = true;
    private boolean isUseDeviceSize = true;
    private ActivityLifecycleCallbacksImpl mActivityLifecycleCallbacks;
    private boolean isStop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoSizeConfig getInstance() {
        if (sInstance != null) return sInstance;
        Class<AutoSizeConfig> clazz = AutoSizeConfig.class;
        synchronized (AutoSizeConfig.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AutoSizeConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private AutoSizeConfig() {
    }

    public Application getApplication() {
        Preconditions.checkNotNull(this.mApplication, "Please call the AutoSizeConfig#init() first");
        return this.mApplication;
    }

    public AutoSizeConfig init(Application application) {
        return this.init(application, true, null);
    }

    public AutoSizeConfig init(Application application, boolean isBaseOnWidth) {
        return this.init(application, isBaseOnWidth, null);
    }

    public AutoSizeConfig init(Application application, boolean isBaseOnWidth, AutoAdaptStrategy strategy) {
        Preconditions.checkArgument(this.mInitDensity == -1.0f, "AutoSizeConfig#init() can only be called once");
        Preconditions.checkNotNull(application, "application == null");
        this.mApplication = application;
        this.isBaseOnWidth = isBaseOnWidth;
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        this.getMetaData((Context)application);
        int[] screenSize = ScreenUtils.getScreenSize((Context)application);
        this.mScreenWidth = screenSize[0];
        this.mScreenHeight = screenSize[1];
        LogUtils.d("designWidthInDp = " + this.mDesignWidthInDp + ", designHeightInDp = " + this.mDesignHeightInDp + ", screenWidth = " + this.mScreenWidth + ", screenHeight = " + this.mScreenHeight);
        this.mInitDensity = displayMetrics.density;
        this.mInitDensityDpi = displayMetrics.densityDpi;
        this.mInitScaledDensity = displayMetrics.scaledDensity;
        application.registerComponentCallbacks(new ComponentCallbacks(){

            public void onConfigurationChanged(Configuration newConfig) {
                if (newConfig != null && newConfig.fontScale > 0.0f) {
                    AutoSizeConfig.this.mInitScaledDensity = Resources.getSystem().getDisplayMetrics().scaledDensity;
                    LogUtils.d("initScaledDensity = " + AutoSizeConfig.this.mInitScaledDensity + " on ConfigurationChanged");
                }
            }

            public void onLowMemory() {
            }
        });
        LogUtils.d("initDensity = " + this.mInitDensity + ", initScaledDensity = " + this.mInitScaledDensity);
        this.mActivityLifecycleCallbacks = new ActivityLifecycleCallbacksImpl(strategy == null ? new DefaultAutoAdaptStrategy() : strategy);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycleCallbacks);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Preconditions.checkNotNull(this.mActivityLifecycleCallbacks, "Please call the AutoSizeConfig#init() first");
        Class<AutoSizeConfig> clazz = AutoSizeConfig.class;
        synchronized (AutoSizeConfig.class) {
            if (this.isStop) {
                this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycleCallbacks);
                this.isStop = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Activity activity) {
        Preconditions.checkNotNull(this.mActivityLifecycleCallbacks, "Please call the AutoSizeConfig#init() first");
        Class<AutoSizeConfig> clazz = AutoSizeConfig.class;
        synchronized (AutoSizeConfig.class) {
            if (!this.isStop) {
                this.mApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mActivityLifecycleCallbacks);
                AutoSize.cancelAdapt(activity);
                this.isStop = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public AutoSizeConfig setAutoAdaptStrategy(AutoAdaptStrategy autoAdaptStrategy) {
        Preconditions.checkNotNull(autoAdaptStrategy, "autoAdaptStrategy == null");
        Preconditions.checkNotNull(this.mActivityLifecycleCallbacks, "Please call the AutoSizeConfig#init() first");
        this.mActivityLifecycleCallbacks.setAutoAdaptStrategy(autoAdaptStrategy);
        return this;
    }

    public AutoSizeConfig setBaseOnWidth(boolean baseOnWidth) {
        this.isBaseOnWidth = baseOnWidth;
        return this;
    }

    public AutoSizeConfig setUseDeviceSize(boolean useDeviceSize) {
        this.isUseDeviceSize = useDeviceSize;
        return this;
    }

    public AutoSizeConfig setLog(boolean log) {
        LogUtils.setDebug(log);
        return this;
    }

    public ExternalAdaptManager getExternalAdaptManager() {
        return this.mExternalAdaptManager;
    }

    public boolean isBaseOnWidth() {
        return this.isBaseOnWidth;
    }

    public boolean isUseDeviceSize() {
        return this.isUseDeviceSize;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.isUseDeviceSize() ? this.mScreenHeight : this.mScreenHeight - ScreenUtils.getStatusBarHeight() - ScreenUtils.getHeightOfNavigationBar((Context)this.getApplication());
    }

    public int getDesignWidthInDp() {
        Preconditions.checkArgument(this.mDesignWidthInDp > 0, "you must set design_width_in_dp  in your AndroidManifest file");
        return this.mDesignWidthInDp;
    }

    public int getDesignHeightInDp() {
        Preconditions.checkArgument(this.mDesignHeightInDp > 0, "you must set design_height_in_dp  in your AndroidManifest file");
        return this.mDesignHeightInDp;
    }

    public float getInitDensity() {
        return this.mInitDensity;
    }

    public int getInitDensityDpi() {
        return this.mInitDensityDpi;
    }

    public float getInitScaledDensity() {
        return this.mInitScaledDensity;
    }

    private void getMetaData(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null) {
                if (applicationInfo.metaData.containsKey(KEY_DESIGN_WIDTH_IN_DP)) {
                    this.mDesignWidthInDp = (Integer)applicationInfo.metaData.get(KEY_DESIGN_WIDTH_IN_DP);
                }
                if (applicationInfo.metaData.containsKey(KEY_DESIGN_HEIGHT_IN_DP)) {
                    this.mDesignHeightInDp = (Integer)applicationInfo.metaData.get(KEY_DESIGN_HEIGHT_IN_DP);
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }
}

