/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import java.util.Locale;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.DisplayMetricsInfo;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.internal.CustomAdapt;
import me.jessyan.autosize.utils.AutoSizeLog;
import me.jessyan.autosize.utils.Preconditions;

public final class AutoSize {
    private static SparseArray<DisplayMetricsInfo> mCache = new SparseArray();
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    private static final int MODE_ON_WIDTH = 0x40000000;
    private static final int MODE_DEVICE_SIZE = Integer.MIN_VALUE;

    private AutoSize() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static boolean checkInit() {
        return AutoSizeConfig.getInstance().getInitDensity() != -1.0f;
    }

    public static void checkAndInit(Application application) {
        if (!AutoSize.checkInit()) {
            AutoSizeConfig.getInstance().setLog(true).init(application).setUseDeviceSize(false);
        }
    }

    public static void autoConvertDensityOfGlobal(Activity activity) {
        if (AutoSizeConfig.getInstance().isBaseOnWidth()) {
            AutoSize.autoConvertDensityBaseOnWidth(activity, AutoSizeConfig.getInstance().getDesignWidthInDp());
        } else {
            AutoSize.autoConvertDensityBaseOnHeight(activity, AutoSizeConfig.getInstance().getDesignHeightInDp());
        }
    }

    public static void autoConvertDensityOfCustomAdapt(Activity activity, CustomAdapt customAdapt) {
        Preconditions.checkNotNull(customAdapt, "customAdapt == null");
        float sizeInDp = customAdapt.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = customAdapt.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, customAdapt.isBaseOnWidth());
    }

    public static void autoConvertDensityOfExternalAdaptInfo(Activity activity, ExternalAdaptInfo externalAdaptInfo) {
        Preconditions.checkNotNull(externalAdaptInfo, "externalAdaptInfo == null");
        float sizeInDp = externalAdaptInfo.getSizeInDp();
        if (sizeInDp <= 0.0f) {
            sizeInDp = externalAdaptInfo.isBaseOnWidth() ? (float)AutoSizeConfig.getInstance().getDesignWidthInDp() : (float)AutoSizeConfig.getInstance().getDesignHeightInDp();
        }
        AutoSize.autoConvertDensity(activity, sizeInDp, externalAdaptInfo.isBaseOnWidth());
    }

    public static void autoConvertDensityBaseOnWidth(Activity activity, float designWidthInDp) {
        AutoSize.autoConvertDensity(activity, designWidthInDp, true);
    }

    public static void autoConvertDensityBaseOnHeight(Activity activity, float designHeightInDp) {
        AutoSize.autoConvertDensity(activity, designHeightInDp, false);
    }

    public static void autoConvertDensity(Activity activity, float sizeInDp, boolean isBaseOnWidth) {
        int targetScreenHeightDp;
        int targetScreenWidthDp;
        Preconditions.checkNotNull(activity, "activity == null");
        Preconditions.checkMainThread();
        float subunitsDesignSize = isBaseOnWidth ? AutoSizeConfig.getInstance().getUnitsManager().getDesignWidth() : AutoSizeConfig.getInstance().getUnitsManager().getDesignHeight();
        subunitsDesignSize = subunitsDesignSize > 0.0f ? subunitsDesignSize : sizeInDp;
        int screenSize = isBaseOnWidth ? AutoSizeConfig.getInstance().getScreenWidth() : AutoSizeConfig.getInstance().getScreenHeight();
        int key = Math.round((sizeInDp + subunitsDesignSize + (float)screenSize) * AutoSizeConfig.getInstance().getInitScaledDensity()) & 0x3FFFFFFF;
        key = isBaseOnWidth ? key | 0x40000000 : key & 0xBFFFFFFF;
        key = AutoSizeConfig.getInstance().isUseDeviceSize() ? key | Integer.MIN_VALUE : key & Integer.MAX_VALUE;
        DisplayMetricsInfo displayMetricsInfo = (DisplayMetricsInfo)mCache.get(key);
        float targetDensity = 0.0f;
        int targetDensityDpi = 0;
        float targetScaledDensity = 0.0f;
        float targetXdpi = 0.0f;
        if (displayMetricsInfo == null) {
            targetDensity = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / sizeInDp : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / sizeInDp;
            if (AutoSizeConfig.getInstance().getPrivateFontScale() > 0.0f) {
                targetScaledDensity = targetDensity * AutoSizeConfig.getInstance().getPrivateFontScale();
            } else {
                float systemFontScale = AutoSizeConfig.getInstance().isExcludeFontScale() ? 1.0f : AutoSizeConfig.getInstance().getInitScaledDensity() * 1.0f / AutoSizeConfig.getInstance().getInitDensity();
                targetScaledDensity = targetDensity * systemFontScale;
            }
            targetDensityDpi = (int)(targetDensity * 160.0f);
            targetScreenWidthDp = (int)((float)AutoSizeConfig.getInstance().getScreenWidth() / targetDensity);
            targetScreenHeightDp = (int)((float)AutoSizeConfig.getInstance().getScreenHeight() / targetDensity);
            targetXdpi = isBaseOnWidth ? (float)AutoSizeConfig.getInstance().getScreenWidth() * 1.0f / subunitsDesignSize : (float)AutoSizeConfig.getInstance().getScreenHeight() * 1.0f / subunitsDesignSize;
            mCache.put(key, (Object)new DisplayMetricsInfo(targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi, targetScreenWidthDp, targetScreenHeightDp));
        } else {
            targetDensity = displayMetricsInfo.getDensity();
            targetDensityDpi = displayMetricsInfo.getDensityDpi();
            targetScaledDensity = displayMetricsInfo.getScaledDensity();
            targetXdpi = displayMetricsInfo.getXdpi();
            targetScreenWidthDp = displayMetricsInfo.getScreenWidthDp();
            targetScreenHeightDp = displayMetricsInfo.getScreenHeightDp();
        }
        AutoSize.setDensity(activity, targetDensity, targetDensityDpi, targetScaledDensity, targetXdpi);
        AutoSize.setScreenSizeDp(activity, targetScreenWidthDp, targetScreenHeightDp);
        AutoSizeLog.d(String.format(Locale.ENGLISH, "The %s has been adapted! \n%s Info: isBaseOnWidth = %s, %s = %f, %s = %f, targetDensity = %f, targetScaledDensity = %f, targetDensityDpi = %d, targetXdpi = %f, targetScreenWidthDp = %d, targetScreenHeightDp = %d", activity.getClass().getName(), activity.getClass().getSimpleName(), isBaseOnWidth, isBaseOnWidth ? "designWidthInDp" : "designHeightInDp", Float.valueOf(sizeInDp), isBaseOnWidth ? "designWidthInSubunits" : "designHeightInSubunits", Float.valueOf(subunitsDesignSize), Float.valueOf(targetDensity), Float.valueOf(targetScaledDensity), targetDensityDpi, Float.valueOf(targetXdpi), targetScreenWidthDp, targetScreenHeightDp));
    }

    public static void cancelAdapt(Activity activity) {
        Preconditions.checkMainThread();
        float initXdpi = AutoSizeConfig.getInstance().getInitXdpi();
        switch (AutoSizeConfig.getInstance().getUnitsManager().getSupportSubunits()) {
            case PT: {
                initXdpi /= 72.0f;
                break;
            }
            case MM: {
                initXdpi /= 25.4f;
                break;
            }
        }
        AutoSize.setDensity(activity, AutoSizeConfig.getInstance().getInitDensity(), AutoSizeConfig.getInstance().getInitDensityDpi(), AutoSizeConfig.getInstance().getInitScaledDensity(), initXdpi);
        AutoSize.setScreenSizeDp(activity, AutoSizeConfig.getInstance().getInitScreenWidthDp(), AutoSizeConfig.getInstance().getInitScreenHeightDp());
    }

    public static void initCompatMultiProcess(Context context) {
        context.getContentResolver().query(Uri.parse((String)("content://" + context.getPackageName() + ".autosize-init-provider")), null, null, null, null);
    }

    private static void setDensity(Activity activity, float density, int densityDpi, float scaledDensity, float xdpi) {
        DisplayMetrics activityDisplayMetrics = activity.getResources().getDisplayMetrics();
        AutoSize.setDensity(activityDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        DisplayMetrics appDisplayMetrics = AutoSizeConfig.getInstance().getApplication().getResources().getDisplayMetrics();
        AutoSize.setDensity(appDisplayMetrics, density, densityDpi, scaledDensity, xdpi);
        DisplayMetrics activityDisplayMetricsOnMIUI = AutoSize.getMetricsOnMiui(activity.getResources());
        DisplayMetrics appDisplayMetricsOnMIUI = AutoSize.getMetricsOnMiui(AutoSizeConfig.getInstance().getApplication().getResources());
        if (activityDisplayMetricsOnMIUI != null) {
            AutoSize.setDensity(activityDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
        if (appDisplayMetricsOnMIUI != null) {
            AutoSize.setDensity(appDisplayMetricsOnMIUI, density, densityDpi, scaledDensity, xdpi);
        }
    }

    private static void setDensity(DisplayMetrics displayMetrics, float density, int densityDpi, float scaledDensity, float xdpi) {
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportDP()) {
            displayMetrics.density = density;
            displayMetrics.densityDpi = densityDpi;
        }
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportSP()) {
            displayMetrics.scaledDensity = scaledDensity;
        }
        switch (AutoSizeConfig.getInstance().getUnitsManager().getSupportSubunits()) {
            case NONE: {
                break;
            }
            case PT: {
                displayMetrics.xdpi = xdpi * 72.0f;
                break;
            }
            case IN: {
                displayMetrics.xdpi = xdpi;
                break;
            }
            case MM: {
                displayMetrics.xdpi = xdpi * 25.4f;
                break;
            }
        }
    }

    private static void setScreenSizeDp(Activity activity, int screenWidthDp, int screenHeightDp) {
        if (AutoSizeConfig.getInstance().getUnitsManager().isSupportDP() && AutoSizeConfig.getInstance().getUnitsManager().isSupportScreenSizeDP()) {
            Configuration activityConfiguration = activity.getResources().getConfiguration();
            AutoSize.setScreenSizeDp(activityConfiguration, screenWidthDp, screenHeightDp);
            Configuration appConfiguration = AutoSizeConfig.getInstance().getApplication().getResources().getConfiguration();
            AutoSize.setScreenSizeDp(appConfiguration, screenWidthDp, screenHeightDp);
        }
    }

    private static void setScreenSizeDp(Configuration configuration, int screenWidthDp, int screenHeightDp) {
        configuration.screenWidthDp = screenWidthDp;
        configuration.screenHeightDp = screenHeightDp;
    }

    private static DisplayMetrics getMetricsOnMiui(Resources resources) {
        if (AutoSizeConfig.getInstance().isMiui() && AutoSizeConfig.getInstance().getTmpMetricsField() != null) {
            try {
                return (DisplayMetrics)AutoSizeConfig.getInstance().getTmpMetricsField().get(resources);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

