/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenspiegsa.wiremockextension;

import com.github.jenspiegsa.wiremockextension.ConfigureWireMock;
import com.github.jenspiegsa.wiremockextension.InjectServer;
import com.github.jenspiegsa.wiremockextension.Managed;
import com.github.jenspiegsa.wiremockextension.ManagedWireMockServer;
import com.github.jenspiegsa.wiremockextension.WireMockSettings;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class WireMockExtension
implements BeforeEachCallback,
AfterEachCallback,
TestInstancePostProcessor {
    private boolean generalFailOnUnmatchedRequests;
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{WireMockExtension.class});

    private WireMockExtension() {
        this(true);
    }

    public WireMockExtension(boolean failOnUnmatchedRequests) {
        this.generalFailOnUnmatchedRequests = failOnUnmatchedRequests;
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        List managedServers = WireMockExtension.retrieveAnnotatedFields(context, Managed.class, WireMockServer.class).stream().map(field -> ReflectionUtils.readFieldValue((Field)field, (Object)testInstance)).map(Optional::get).map(WireMockServer.class::cast).map(Objects::requireNonNull).collect(Collectors.toList());
        if (managedServers.isEmpty()) {
            List<Field> injectedServerFields;
            WireMockConfiguration options = null;
            for (Field field2 : WireMockExtension.retrieveAnnotatedFields(context, ConfigureWireMock.class, Options.class)) {
                if (options == null) {
                    options = (Options)((Field)ReflectionUtils.makeAccessible((AccessibleObject)field2)).get(testInstance);
                    continue;
                }
                throw new ExtensionConfigurationException("@ConfigureWireMock only valid once per class.");
            }
            if (options == null) {
                options = WireMockConfiguration.wireMockConfig();
            }
            if (!(injectedServerFields = WireMockExtension.retrieveAnnotatedFields(context, InjectServer.class, WireMockServer.class)).isEmpty()) {
                WireMockServer server = new WireMockServer((Options)options);
                for (Field field3 : injectedServerFields) {
                    ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field3)).set(testInstance, server);
                }
                context.getStore(NAMESPACE).put(testInstance.getClass(), Collections.singletonList(server));
            }
        } else {
            context.getStore(NAMESPACE).put(testInstance.getClass(), managedServers);
        }
    }

    public void beforeEach(ExtensionContext context) {
        Optional<WireMockSettings> wireMockSettings = WireMockExtension.retrieveAnnotation(context, WireMockSettings.class);
        this.generalFailOnUnmatchedRequests = wireMockSettings.map(WireMockSettings::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
        List<WireMockServer> wireMockServers = WireMockExtension.collectServers(context);
        if (wireMockServers.isEmpty()) {
            WireMockServer server = new WireMockServer();
            context.getStore(NAMESPACE).put((Object)context.getRequiredTestClass(), Collections.singletonList(server));
            WireMockExtension.startServer(server);
        } else {
            wireMockServers.forEach(WireMockExtension::startServer);
        }
    }

    public void afterEach(ExtensionContext context) {
        List<WireMockServer> wireMockServers = WireMockExtension.collectServers(context);
        wireMockServers.forEach(WireMockExtension::stopServer);
        wireMockServers.forEach(this::checkForUnmatchedRequests);
    }

    private void checkForUnmatchedRequests(WireMockServer server) {
        List unmatchedRequests;
        boolean mustCheck = Optional.of(server).filter(ManagedWireMockServer.class::isInstance).map(ManagedWireMockServer.class::cast).map(ManagedWireMockServer::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
        if (mustCheck && !(unmatchedRequests = server.findAllUnmatchedRequests()).isEmpty()) {
            List nearMisses = server.findNearMissesForAllUnmatchedRequests();
            throw nearMisses.isEmpty() ? VerificationException.forUnmatchedRequests((List)unmatchedRequests) : VerificationException.forUnmatchedNearMisses((List)nearMisses);
        }
    }

    private static <A extends Annotation> Optional<A> retrieveAnnotation(ExtensionContext context, Class<A> annotationType) {
        Optional currentContext = Optional.of(context);
        Optional annotation = Optional.empty();
        while (currentContext.isPresent() && !annotation.isPresent()) {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.get().getElement(), annotationType);
            currentContext = currentContext.get().getParent();
        }
        return annotation;
    }

    private static List<Field> retrieveAnnotatedFields(ExtensionContext context, Class<? extends Annotation> annotationType, Class<?> fieldType) {
        return context.getElement().filter(Class.class::isInstance).map(Class.class::cast).map(testInstanceClass -> AnnotationUtils.findAnnotatedFields((Class)testInstanceClass, (Class)annotationType, field -> fieldType.isAssignableFrom(field.getType()))).orElseGet(Collections::emptyList);
    }

    private static void startServer(WireMockServer server) {
        if (!server.isRunning()) {
            server.start();
            WireMock.configureFor((String)"localhost", (int)server.port());
        }
    }

    private static void stopServer(WireMockServer server) {
        server.stop();
    }

    private static List<WireMockServer> collectServers(ExtensionContext context) {
        return WireMockExtension.collectTestClasses(context).map(testClass -> context.getStore(NAMESPACE).get(testClass)).filter(Objects::nonNull).map(List.class::cast).flatMap(Collection::stream).map(WireMockServer.class::cast).collect(Collectors.toList());
    }

    private static Stream<Class<?>> collectTestClasses(ExtensionContext context) {
        return Stream.concat(Stream.of(context.getRequiredTestClass()), context.getParent().filter(parentContext -> parentContext != context.getRoot()).map(WireMockExtension::collectTestClasses).orElseGet(Stream::empty)).distinct();
    }
}

