/*
 * Decompiled with CFR 0.152.
 */
package com.github.jenspiegsa.mockitoextension;

import com.github.jenspiegsa.mockitoextension.ConfigureWireMock;
import com.github.jenspiegsa.mockitoextension.InjectServer;
import com.github.jenspiegsa.mockitoextension.Managed;
import com.github.jenspiegsa.mockitoextension.ManagedWireMockServer;
import com.github.jenspiegsa.mockitoextension.WireMockSettings;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;

public class WireMockExtension
implements BeforeEachCallback,
AfterEachCallback {
    private boolean generalFailOnUnmatchedRequests;
    private final Map<String, List<WireMockServer>> serversByTestId = new LinkedHashMap<String, List<WireMockServer>>();

    private WireMockExtension() {
        this(true);
    }

    public WireMockExtension(boolean failOnUnmatchedRequests) {
        this.generalFailOnUnmatchedRequests = failOnUnmatchedRequests;
    }

    public void beforeEach(ExtensionContext context) throws IllegalAccessException {
        Optional<WireMockSettings> wireMockSettings = WireMockExtension.retrieveAnnotation(context, WireMockSettings.class);
        this.generalFailOnUnmatchedRequests = wireMockSettings.map(WireMockSettings::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
        Object testInstance = context.getRequiredTestInstance();
        ArrayList<WireMockServer> servers = new ArrayList<WireMockServer>();
        for (Field field : WireMockExtension.retrieveAnnotatedFields(context, Managed.class, WireMockServer.class)) {
            servers.add((WireMockServer)Objects.requireNonNull(WireMockExtension.makeAccessible(field).get(testInstance)));
        }
        if (servers.isEmpty()) {
            WireMockConfiguration options = null;
            for (Field field : WireMockExtension.retrieveAnnotatedFields(context, ConfigureWireMock.class, Options.class)) {
                if (options == null) {
                    options = (Options)WireMockExtension.makeAccessible(field).get(testInstance);
                    continue;
                }
                throw new ExtensionConfigurationException("@ConfigureWireMock only valid once per class.");
            }
            if (options == null) {
                options = WireMockConfiguration.wireMockConfig();
            }
            WireMockServer wireMockServer = new WireMockServer((Options)options);
            servers.add(wireMockServer);
            for (Field field : WireMockExtension.retrieveAnnotatedFields(context, InjectServer.class, WireMockServer.class)) {
                WireMockExtension.makeAccessible(field).set(testInstance, wireMockServer);
            }
        }
        for (WireMockServer wireMockServer : servers) {
            wireMockServer.start();
            WireMock.configureFor((String)"localhost", (int)wireMockServer.port());
            this.serversByTestId.computeIfAbsent(context.getUniqueId(), k -> new ArrayList()).addAll(servers);
        }
    }

    public void afterEach(ExtensionContext context) {
        List<WireMockServer> servers = this.serversByTestId.get(context.getUniqueId());
        if (servers != null) {
            servers.forEach(WireMockServer::stop);
        }
        this.checkForUnmatchedRequests(context);
    }

    private void checkForUnmatchedRequests(ExtensionContext context) {
        List<WireMockServer> servers = this.serversByTestId.get(context.getUniqueId());
        if (servers != null) {
            for (WireMockServer server : servers) {
                List unmatchedRequests;
                Boolean mustCheck = Optional.of(server).filter(ManagedWireMockServer.class::isInstance).map(ManagedWireMockServer.class::cast).map(ManagedWireMockServer::failOnUnmatchedRequests).orElse(this.generalFailOnUnmatchedRequests);
                if (!mustCheck.booleanValue() || (unmatchedRequests = server.findAllUnmatchedRequests()).isEmpty()) continue;
                List nearMisses = server.findNearMissesForAllUnmatchedRequests();
                throw nearMisses.isEmpty() ? VerificationException.forUnmatchedRequests((List)unmatchedRequests) : VerificationException.forUnmatchedNearMisses((List)nearMisses);
            }
        }
    }

    private static <A extends Annotation> Optional<A> retrieveAnnotation(ExtensionContext context, Class<A> annotationType) {
        Optional currentContext = Optional.of(context);
        Optional annotation = Optional.empty();
        while (currentContext.isPresent() && !annotation.isPresent()) {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.get().getElement(), annotationType);
            currentContext = currentContext.get().getParent();
        }
        return annotation;
    }

    private static List<Field> retrieveAnnotatedFields(ExtensionContext context, Class<? extends Annotation> annotationType, Class<?> fieldType) {
        Optional currentContext = Optional.of(context);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        while (currentContext.isPresent() && currentContext.get().getElement().isPresent()) {
            AnnotatedElement annotatedElement = (AnnotatedElement)currentContext.get().getElement().get();
            if (annotatedElement instanceof Class) {
                annotatedFields.addAll(WireMockExtension.findAnnotatedFields((Class)annotatedElement, fieldType, annotationType));
            }
            currentContext = currentContext.get().getParent();
        }
        return annotatedFields;
    }

    private static List<Field> findAnnotatedFields(Class<?> aClass, Class<?> fieldType, Class<? extends Annotation> annotationType) {
        return (List)Arrays.stream(aClass.getDeclaredFields()).filter(field -> fieldType.isAssignableFrom(field.getType())).filter(field -> AnnotationUtils.isAnnotated((AnnotatedElement)field, (Class)annotationType)).collect(CollectionUtils.toUnmodifiableList());
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }
}

