/*
 * Decompiled with CFR 0.152.
 */
package jaygoo.widget.wlv;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class RenderView
extends SurfaceView
implements SurfaceHolder.Callback {
    private boolean isStartAnim = false;
    private static final Object surfaceLock = new Object();
    private RenderThread renderThread;
    private List<IRenderer> renderer;

    protected abstract void doDrawBackground(Canvas var1);

    protected abstract void onRender(Canvas var1, long var2);

    public RenderView(Context context) {
        this(context, null);
    }

    public RenderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.renderer = this.onCreateRenderer();
        if (this.renderer != null && this.renderer.isEmpty()) {
            throw new IllegalStateException();
        }
        this.renderThread = new RenderThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        Object object = surfaceLock;
        synchronized (object) {
            if (this.renderThread != null) {
                this.renderThread.isPause = false;
                surfaceLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause() {
        Object object = surfaceLock;
        synchronized (object) {
            if (this.renderThread != null) {
                this.renderThread.isPause = true;
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Object object = surfaceLock;
        synchronized (object) {
            this.renderThread.setRun(false);
            this.renderThread.destoryed = true;
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        if (hasFocus && this.isStartAnim) {
            this.startAnim();
        } else {
            this.startThread();
        }
    }

    protected List<IRenderer> onCreateRenderer() {
        return null;
    }

    private void render(Canvas canvas, long millisPassed) {
        if (this.renderer != null) {
            int size = this.renderer.size();
            for (int i = 0; i < size; ++i) {
                this.renderer.get(i).onRender(canvas, millisPassed);
            }
        } else {
            this.onRender(canvas, millisPassed);
        }
    }

    public void startAnim() {
        this.isStartAnim = true;
        this.startThread();
    }

    private void startThread() {
        if (this.renderThread != null && !this.renderThread.running) {
            this.renderThread.setRun(true);
            try {
                if (this.renderThread.getState() == Thread.State.NEW) {
                    this.renderThread.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopAnim() {
        this.isStartAnim = false;
        if (this.renderThread != null && this.renderThread.running) {
            this.renderThread.setRun(false);
            this.renderThread.interrupt();
        }
    }

    public boolean isRunning() {
        if (this.renderThread != null) {
            return this.renderThread.running;
        }
        return false;
    }

    public void release() {
        if (this.getHolder() != null && this.getHolder().getSurface() != null) {
            this.getHolder().getSurface().release();
            this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        }
    }

    public static interface IRenderer {
        public void onRender(Canvas var1, long var2);
    }

    private static class RenderThread
    extends Thread {
        private static final long SLEEP_TIME = 16L;
        private WeakReference<RenderView> renderView;
        private boolean running = false;
        private boolean destoryed = false;
        private boolean isPause = false;

        public RenderThread(RenderView renderView) {
            super("RenderThread");
            this.renderView = new WeakReference<RenderView>(renderView);
        }

        private SurfaceHolder getSurfaceHolder() {
            if (this.getRenderView() != null) {
                return this.getRenderView().getHolder();
            }
            return null;
        }

        private RenderView getRenderView() {
            return (RenderView)((Object)this.renderView.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startAt = System.currentTimeMillis();
            while (!this.destoryed) {
                Object object = surfaceLock;
                synchronized (object) {
                    while (this.isPause) {
                        try {
                            surfaceLock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.running) {
                        if (this.getSurfaceHolder() != null && this.getRenderView() != null) {
                            Canvas canvas = this.getSurfaceHolder().lockCanvas();
                            if (canvas != null) {
                                this.getRenderView().doDrawBackground(canvas);
                                if (this.getRenderView().isStartAnim) {
                                    this.getRenderView().render(canvas, System.currentTimeMillis() - startAt);
                                }
                                this.getSurfaceHolder().unlockCanvasAndPost(canvas);
                            }
                        } else {
                            this.running = false;
                        }
                    }
                }
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void setRun(boolean isRun) {
            this.running = isRun;
        }
    }
}

