/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.util.Log;

public class Utils {
    private static final String TAG = "RangeSeekBar";

    public static void print(String log) {
        Log.d((String)TAG, (String)log);
    }

    public static void print(Object ... logs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object log : logs) {
            stringBuilder.append(log);
        }
        Log.d((String)TAG, (String)stringBuilder.toString());
    }

    public static Bitmap drawableToBitmap(Context context, int width, int height, int drawableId) {
        if (context == null || width <= 0 || height <= 0 || drawableId == 0) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return Utils.drawableToBitmap(width, height, context.getResources().getDrawable(drawableId, null));
        }
        return Utils.drawableToBitmap(width, height, context.getResources().getDrawable(drawableId));
    }

    public static Bitmap drawableToBitmap(int width, int height, Drawable drawable2) {
        Bitmap bitmap = null;
        try {
            BitmapDrawable bitmapDrawable;
            if (drawable2 instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap()) != null && bitmap.getHeight() > 0) {
                Matrix matrix = new Matrix();
                float scaleWidth = (float)width * 1.0f / (float)bitmap.getWidth();
                float scaleHeight = (float)height * 1.0f / (float)bitmap.getHeight();
                matrix.postScale(scaleWidth, scaleHeight);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                return bitmap;
            }
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static void drawNinePath(Canvas canvas, Bitmap bmp, Rect rect) {
        NinePatch.isNinePatchChunk((byte[])bmp.getNinePatchChunk());
        NinePatch patch = new NinePatch(bmp, bmp.getNinePatchChunk(), null);
        patch.draw(canvas, rect);
    }

    public static void drawBitmap(Canvas canvas, Paint paint, Bitmap bmp, Rect rect) {
        try {
            if (NinePatch.isNinePatchChunk((byte[])bmp.getNinePatchChunk())) {
                Utils.drawNinePath(canvas, bmp, rect);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        canvas.drawBitmap(bmp, (float)rect.left, (float)rect.top, paint);
    }

    public static int dp2px(Context context, float dpValue) {
        if (context == null || Utils.compareFloat(0.0f, dpValue) == 0) {
            return 0;
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int compareFloat(float a, float b) {
        int tb;
        int ta = Math.round(a * 1000000.0f);
        if (ta > (tb = Math.round(b * 1000000.0f))) {
            return 1;
        }
        if (ta < tb) {
            return -1;
        }
        return 0;
    }

    public static int compareFloat(float a, float b, int degree) {
        if ((double)Math.abs(a - b) < Math.pow(0.1, degree)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static Rect measureText(String text, float textSize) {
        Paint paint = new Paint();
        Rect textRect = new Rect();
        paint.setTextSize(textSize);
        paint.getTextBounds(text, 0, text.length(), textRect);
        paint.reset();
        return textRect;
    }

    public static boolean verifyBitmap(Bitmap bitmap) {
        return bitmap != null && !bitmap.isRecycled() && bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
    }

    public static int getColor(Context context, @ColorRes int colorId) {
        if (context != null) {
            return ContextCompat.getColor((Context)context.getApplicationContext(), (int)colorId);
        }
        return -1;
    }
}

