/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import com.jaygoo.widget.R;
import com.jaygoo.widget.RangeSeekBar;
import com.jaygoo.widget.SeekBarState;
import com.jaygoo.widget.Utils;
import java.text.DecimalFormat;

public class SeekBar {
    public static final int INDICATOR_MODE_SHOW_WHEN_TOUCH = 0;
    public static final int INDICATOR_MODE_ALWAYS_HIDE = 1;
    public static final int INDICATOR_MODE_ALWAYS_SHOW_AFTER_TOUCH = 2;
    public static final int INDICATOR_MODE_ALWAYS_SHOW = 3;
    private int indicatorShowMode;
    private int indicatorHeight;
    private int indicatorWidth;
    private int indicatorMargin;
    private int indicatorDrawableId;
    private int indicatorArrowSize;
    private int indicatorTextSize;
    private int indicatorTextColor;
    private int indicatorBackgroundColor;
    private int indicatorPaddingLeft;
    private int indicatorPaddingRight;
    private int indicatorPaddingTop;
    private int indicatorPaddingBottom;
    private int thumbDrawableId;
    private int thumbInactivatedDrawableId;
    private int thumbSize;
    private int lineWidth;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected float currPercent;
    protected float material = 0.0f;
    private boolean isShowIndicator;
    private boolean isLeft;
    private Bitmap thumbBitmap;
    private Bitmap thumbInactivatedBitmap;
    private Bitmap indicatorBitmap;
    private ValueAnimator anim;
    private String userText2Draw;
    private boolean isActivate = false;
    private RangeSeekBar rangeSeekBar;
    private String indicatorTextStringFormat;
    private Path indicatorArrowPath = new Path();
    private Rect indicatorTextRect = new Rect();
    private Rect indicatorRect = new Rect();
    private Paint paint = new Paint(1);
    private DecimalFormat indicatorTextDecimalFormat;

    public SeekBar(RangeSeekBar rangeSeekBar, AttributeSet attrs, boolean isLeft) {
        this.rangeSeekBar = rangeSeekBar;
        this.isLeft = isLeft;
        this.initAttrs(attrs);
        this.initVariables();
        this.initBitmap();
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        if (t == null) {
            return;
        }
        this.indicatorMargin = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_margin, 0.0f);
        this.indicatorDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_indicator_drawable, 0);
        this.indicatorShowMode = t.getInt(R.styleable.RangeSeekBar_rsb_indicator_show_mode, 1);
        this.indicatorHeight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_height, 0.0f);
        this.indicatorWidth = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_width, 0.0f);
        this.indicatorTextSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_text_size, (float)Utils.dp2px(this.getContext(), 14.0f));
        this.indicatorTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_indicator_text_color, -1);
        this.indicatorBackgroundColor = t.getColor(R.styleable.RangeSeekBar_rsb_indicator_background_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorAccent));
        this.indicatorPaddingLeft = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_left, 0.0f);
        this.indicatorPaddingRight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_right, 0.0f);
        this.indicatorPaddingTop = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_top, 0.0f);
        this.indicatorPaddingBottom = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_padding_bottom, 0.0f);
        this.indicatorArrowSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_indicator_arrow_size, 0.0f);
        this.thumbDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_thumb_drawable, R.drawable.rsb_default_thumb);
        this.thumbInactivatedDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_thumb_inactivated_drawable, 0);
        this.thumbSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_thumb_size, (float)Utils.dp2px(this.getContext(), 26.0f));
        t.recycle();
    }

    private void initVariables() {
        if (this.indicatorHeight <= 0 && this.indicatorShowMode != 1) {
            throw new IllegalArgumentException("if you want to show indicator, the indicatorHeight must > 0");
        }
        if (this.indicatorArrowSize <= 0) {
            this.indicatorArrowSize = this.thumbSize / 4;
        }
    }

    private Context getContext() {
        return this.rangeSeekBar.getContext();
    }

    private Resources getResources() {
        if (this.getContext() != null) {
            return this.getContext().getResources();
        }
        return null;
    }

    private void initBitmap() {
        this.setIndicatorDrawableId(this.indicatorDrawableId);
        this.setThumbDrawableId(this.thumbDrawableId);
        this.setThumbInactivatedDrawableId(this.thumbInactivatedDrawableId);
    }

    protected void onSizeChanged(int x, int y, int parentLineWidth) {
        this.left = x - this.thumbSize / 2;
        this.right = x + this.thumbSize / 2;
        this.top = y - this.thumbSize / 2;
        this.bottom = y + this.thumbSize / 2;
        this.lineWidth = parentLineWidth;
    }

    private void drawIndicator(Canvas canvas, String text2Draw) {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.indicatorBackgroundColor);
        int contentWidth = this.indicatorTextRect.width() + this.indicatorPaddingLeft + this.indicatorPaddingRight;
        int realIndicatorWidth = this.indicatorWidth <= 0 ? contentWidth : (this.indicatorWidth < contentWidth ? contentWidth : this.indicatorWidth);
        this.indicatorRect.left = this.thumbSize / 2 - realIndicatorWidth / 2;
        this.indicatorRect.top = this.bottom - this.indicatorHeight - this.thumbSize - this.indicatorMargin;
        this.indicatorRect.right = this.indicatorRect.left + realIndicatorWidth;
        this.indicatorRect.bottom = this.indicatorRect.top + this.indicatorHeight;
        if (this.indicatorBitmap == null) {
            int ax = this.thumbSize / 2;
            int ay = this.bottom - this.thumbSize - this.indicatorMargin;
            int bx = ax - this.indicatorArrowSize;
            int by = ay - this.indicatorArrowSize;
            int cx = ax + this.indicatorArrowSize;
            this.indicatorArrowPath.reset();
            this.indicatorArrowPath.moveTo((float)ax, (float)ay);
            this.indicatorArrowPath.lineTo((float)bx, (float)by);
            this.indicatorArrowPath.lineTo((float)cx, (float)by);
            this.indicatorArrowPath.close();
            canvas.drawPath(this.indicatorArrowPath, this.paint);
            this.indicatorRect.bottom -= this.indicatorArrowSize;
            this.indicatorRect.top -= this.indicatorArrowSize;
        }
        int defaultPaddingOffset = Utils.dp2px(this.getContext(), 1.0f);
        int leftOffset = this.indicatorRect.width() / 2 - (int)((float)this.lineWidth * this.currPercent) - this.rangeSeekBar.getLineLeft() + defaultPaddingOffset;
        int rightOffset = this.indicatorRect.width() / 2 - (int)((float)this.lineWidth * (1.0f - this.currPercent)) - this.rangeSeekBar.getLinePaddingRight() + defaultPaddingOffset;
        if (leftOffset > 0) {
            this.indicatorRect.left += leftOffset;
            this.indicatorRect.right += leftOffset;
        } else if (rightOffset > 0) {
            this.indicatorRect.left -= rightOffset;
            this.indicatorRect.right -= rightOffset;
        }
        if (this.indicatorBitmap != null) {
            Utils.drawNinePath(canvas, this.indicatorBitmap, this.indicatorRect);
        } else {
            canvas.drawRect(this.indicatorRect, this.paint);
        }
        int tx = this.indicatorPaddingLeft > 0 ? this.indicatorRect.left + this.indicatorPaddingLeft : (this.indicatorPaddingRight > 0 ? this.indicatorRect.right - this.indicatorPaddingRight - this.indicatorTextRect.width() : this.indicatorRect.left + (realIndicatorWidth - this.indicatorTextRect.width()) / 2);
        int ty = this.indicatorPaddingTop > 0 ? this.indicatorRect.top + this.indicatorTextRect.height() + this.indicatorPaddingTop : (this.indicatorPaddingBottom > 0 ? this.indicatorRect.bottom - this.indicatorTextRect.height() - this.indicatorPaddingBottom : this.indicatorRect.bottom - (this.indicatorHeight - this.indicatorTextRect.height()) / 2 + 1);
        this.paint.setColor(this.indicatorTextColor);
        canvas.drawText(text2Draw, (float)tx, (float)ty, this.paint);
    }

    protected void draw(Canvas canvas) {
        int offset = (int)((float)this.lineWidth * this.currPercent);
        canvas.save();
        canvas.translate((float)offset, 0.0f);
        SeekBarState[] states = this.rangeSeekBar.getRangeSeekBarState();
        String text2Draw = this.userText2Draw;
        if (this.isLeft) {
            if (this.userText2Draw == null) {
                text2Draw = this.indicatorTextDecimalFormat != null ? this.indicatorTextDecimalFormat.format(states[0].value) : states[0].indicatorText;
            }
        } else if (this.userText2Draw == null) {
            text2Draw = this.indicatorTextDecimalFormat != null ? this.indicatorTextDecimalFormat.format(states[1].value) : states[1].indicatorText;
        }
        if (this.indicatorTextStringFormat != null) {
            text2Draw = String.format(this.indicatorTextStringFormat, text2Draw);
        }
        this.paint.setTextSize((float)this.indicatorTextSize);
        this.paint.getTextBounds(text2Draw, 0, text2Draw.length(), this.indicatorTextRect);
        canvas.translate((float)this.left, 0.0f);
        if (this.indicatorShowMode == 3) {
            this.setShowIndicatorEnable(true);
        }
        if (this.isShowIndicator) {
            this.drawIndicator(canvas, text2Draw);
        }
        this.drawThumb(canvas);
        canvas.restore();
    }

    private void drawThumb(Canvas canvas) {
        if (this.thumbInactivatedBitmap != null && !this.isActivate) {
            canvas.drawBitmap(this.thumbInactivatedBitmap, 0.0f, (float)(this.rangeSeekBar.getLineTop() + (this.rangeSeekBar.getProgressHeight() - this.thumbSize) / 2), null);
        } else if (this.thumbBitmap != null) {
            canvas.drawBitmap(this.thumbBitmap, 0.0f, (float)(this.rangeSeekBar.getLineTop() + (this.rangeSeekBar.getProgressHeight() - this.thumbSize) / 2), null);
        }
    }

    protected boolean collide(float x, float y) {
        int offset = (int)((float)this.lineWidth * this.currPercent);
        return x > (float)(this.left + offset) && x < (float)(this.right + offset) && y > (float)this.top && y < (float)this.bottom;
    }

    protected void slide(float percent) {
        if (percent < 0.0f) {
            percent = 0.0f;
        } else if (percent > 1.0f) {
            percent = 1.0f;
        }
        this.currPercent = percent;
    }

    protected void setShowIndicatorEnable(boolean isEnable) {
        switch (this.indicatorShowMode) {
            case 0: {
                this.isShowIndicator = isEnable;
                break;
            }
            case 2: 
            case 3: {
                this.isShowIndicator = true;
                break;
            }
            case 1: {
                this.isShowIndicator = false;
            }
        }
    }

    public void materialRestore() {
        if (this.anim != null) {
            this.anim.cancel();
        }
        this.anim = ValueAnimator.ofFloat((float[])new float[]{this.material, 0.0f});
        this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SeekBar.this.material = ((Float)animation.getAnimatedValue()).floatValue();
                if (SeekBar.this.rangeSeekBar != null) {
                    SeekBar.this.rangeSeekBar.invalidate();
                }
            }
        });
        this.anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SeekBar.this.material = 0.0f;
                if (SeekBar.this.rangeSeekBar != null) {
                    SeekBar.this.rangeSeekBar.invalidate();
                }
            }
        });
        this.anim.start();
    }

    public void setIndicatorText(String text) {
        this.userText2Draw = text;
    }

    public void setIndicatorTextDecimalFormat(String formatPattern) {
        this.indicatorTextDecimalFormat = new DecimalFormat(formatPattern);
    }

    public DecimalFormat getIndicatorTextDecimalFormat() {
        return this.indicatorTextDecimalFormat;
    }

    public void setIndicatorTextStringFormat(String formatPattern) {
        this.indicatorTextStringFormat = formatPattern;
    }

    public int getIndicatorDrawableId() {
        return this.indicatorDrawableId;
    }

    public void setIndicatorDrawableId(int indicatorDrawableId) {
        if (indicatorDrawableId != 0) {
            this.indicatorDrawableId = indicatorDrawableId;
            this.indicatorBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)indicatorDrawableId);
        }
    }

    public int getIndicatorArrowSize() {
        return this.indicatorArrowSize;
    }

    public void setIndicatorArrowSize(int indicatorArrowSize) {
        this.indicatorArrowSize = indicatorArrowSize;
    }

    public int getIndicatorPaddingLeft() {
        return this.indicatorPaddingLeft;
    }

    public void setIndicatorPaddingLeft(int indicatorPaddingLeft) {
        this.indicatorPaddingLeft = indicatorPaddingLeft;
    }

    public int getIndicatorPaddingRight() {
        return this.indicatorPaddingRight;
    }

    public void setIndicatorPaddingRight(int indicatorPaddingRight) {
        this.indicatorPaddingRight = indicatorPaddingRight;
    }

    public int getIndicatorPaddingTop() {
        return this.indicatorPaddingTop;
    }

    public void setIndicatorPaddingTop(int indicatorPaddingTop) {
        this.indicatorPaddingTop = indicatorPaddingTop;
    }

    public int getIndicatorPaddingBottom() {
        return this.indicatorPaddingBottom;
    }

    public void setIndicatorPaddingBottom(int indicatorPaddingBottom) {
        this.indicatorPaddingBottom = indicatorPaddingBottom;
    }

    public int getIndicatorMargin() {
        return this.indicatorMargin;
    }

    public void setIndicatorMargin(int indicatorMargin) {
        this.indicatorMargin = indicatorMargin;
    }

    public int getIndicatorShowMode() {
        return this.indicatorShowMode;
    }

    public void setIndicatorShowMode(int indicatorShowMode) {
        this.indicatorShowMode = indicatorShowMode;
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setIndicatorHeight(int indicatorHeight) {
        this.indicatorHeight = indicatorHeight;
    }

    public int getIndicatorWidth() {
        return this.indicatorWidth;
    }

    public void setIndicatorWidth(int indicatorWidth) {
        this.indicatorWidth = indicatorWidth;
    }

    public int getIndicatorTextSize() {
        return this.indicatorTextSize;
    }

    public void setIndicatorTextSize(int indicatorTextSize) {
        this.indicatorTextSize = indicatorTextSize;
    }

    public int getIndicatorTextColor() {
        return this.indicatorTextColor;
    }

    public void setIndicatorTextColor(int indicatorTextColor) {
        this.indicatorTextColor = indicatorTextColor;
    }

    public int getIndicatorBackgroundColor() {
        return this.indicatorBackgroundColor;
    }

    public void setIndicatorBackgroundColor(int indicatorBackgroundColor) {
        this.indicatorBackgroundColor = indicatorBackgroundColor;
    }

    public int getThumbInactivatedDrawableId() {
        return this.thumbInactivatedDrawableId;
    }

    public void setThumbInactivatedDrawableId(int thumbInactivatedDrawableId) {
        if (thumbInactivatedDrawableId != 0 && this.getResources() != null) {
            this.thumbInactivatedDrawableId = thumbInactivatedDrawableId;
            this.thumbInactivatedBitmap = Utils.drawableToBitmap(this.thumbSize, this.getResources().getDrawable(thumbInactivatedDrawableId));
        }
    }

    public int getThumbDrawableId() {
        return this.thumbDrawableId;
    }

    public void setThumbDrawableId(int thumbDrawableId) {
        if (thumbDrawableId != 0 && this.getResources() != null) {
            this.thumbDrawableId = thumbDrawableId;
            this.thumbBitmap = Utils.drawableToBitmap(this.thumbSize, this.getResources().getDrawable(thumbDrawableId));
        }
    }

    public int getThumbSize() {
        return this.thumbSize;
    }

    public void setThumbSize(int thumbSize) {
        this.thumbSize = thumbSize;
    }

    protected boolean getActivate() {
        return this.isActivate;
    }

    protected void setActivate(boolean activate) {
        this.isActivate = activate;
    }
}

