/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.jaygoo.widget.OnRangeChangedListener;
import com.jaygoo.widget.R;
import com.jaygoo.widget.SavedState;
import com.jaygoo.widget.SeekBar;
import com.jaygoo.widget.SeekBarState;
import com.jaygoo.widget.Utils;

public class RangeSeekBar
extends View {
    public static final int SEEKBAR_MODE_SINGLE = 1;
    public static final int SEEKBAR_MODE_RANGE = 2;
    public static final int TRICK_MARK_MODE_NUMBER = 0;
    public static final int TRICK_MARK_MODE_OTHER = 1;
    public static final int TRICK_MARK_GRAVITY_LEFT = 0;
    public static final int TRICK_MARK_GRAVITY_CENTER = 1;
    public static final int TRICK_MARK_GRAVITY_RIGHT = 2;
    private int seekBarMode;
    private int tickMarkMode;
    private int tickMarkNumber = 1;
    private int tickMarkTextMargin;
    private int tickMarkTextSize;
    private int tickMarkGravity;
    private int tickMarkTextColor;
    private int tickMarkInRangeTextColor;
    private CharSequence[] tickMarkTextArray;
    private int reserveCount;
    private float progressRadius;
    private int progressColor;
    private int progressDefaultColor;
    private int progressHeight;
    private float rangeInterval;
    private float minProgress;
    private float maxProgress;
    private int lineWidth;
    protected int lineTop;
    protected int lineBottom;
    protected int lineLeft;
    protected int lineRight;
    private int linePaddingRight;
    private float touchDownX;
    private float cellsPercent;
    private float reservePercent;
    private float offsetValue;
    private float maxPositiveValue;
    private float minPositiveValue;
    private boolean isEnable = true;
    private Paint paint = new Paint();
    private RectF backgroundLineRect = new RectF();
    private RectF foregroundLineRect = new RectF();
    private SeekBar leftSB;
    private SeekBar rightSB;
    private SeekBar currTouchSB;
    private OnRangeChangedListener callback;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initPaint();
        if (this.seekBarMode == 2) {
            this.leftSB = new SeekBar(this, attrs, true);
            this.rightSB = new SeekBar(this, attrs, false);
        } else {
            this.leftSB = new SeekBar(this, attrs, true);
            this.rightSB = null;
        }
        this.setRangeRules(this.minProgress, this.maxProgress, this.rangeInterval, this.tickMarkNumber);
        this.lineTop = this.rightSB == null ? this.leftSB.getIndicatorHeight() + this.leftSB.getIndicatorArrowSize() + this.leftSB.getThumbSize() / 2 - this.progressHeight / 2 : Math.max(this.leftSB.getIndicatorHeight() + this.leftSB.getIndicatorArrowSize() + this.leftSB.getThumbSize() / 2, this.rightSB.getIndicatorHeight() + this.rightSB.getIndicatorArrowSize() + this.rightSB.getThumbSize() / 2) - this.progressHeight / 2;
        this.lineBottom = this.lineTop + this.progressHeight;
        if (this.progressRadius < 0.0f) {
            this.progressRadius = (int)((float)(this.getLineBottom() - this.getLineTop()) * 0.45f);
        }
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        this.seekBarMode = t.getInt(R.styleable.RangeSeekBar_rsb_mode, 2);
        this.minProgress = t.getFloat(R.styleable.RangeSeekBar_rsb_min, 0.0f);
        this.maxProgress = t.getFloat(R.styleable.RangeSeekBar_rsb_max, 100.0f);
        this.rangeInterval = t.getFloat(R.styleable.RangeSeekBar_rsb_range_interval, 0.0f);
        this.progressColor = t.getColor(R.styleable.RangeSeekBar_rsb_progress_color, -11806366);
        this.progressRadius = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_progress_radius, -1.0f);
        this.progressDefaultColor = t.getColor(R.styleable.RangeSeekBar_rsb_progress_default_color, -2631721);
        this.progressHeight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_progress_height, (float)Utils.dp2px(this.getContext(), 2.0f));
        this.tickMarkMode = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_mode, 0);
        this.tickMarkGravity = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_gravity, 1);
        this.tickMarkNumber = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_number, 1);
        this.tickMarkTextArray = t.getTextArray(R.styleable.RangeSeekBar_rsb_tick_mark_text_array);
        this.tickMarkTextMargin = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_tick_mark_text_margin, (float)Utils.dp2px(this.getContext(), 7.0f));
        this.tickMarkTextSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_tick_mark_text_size, (float)Utils.dp2px(this.getContext(), 12.0f));
        this.tickMarkTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_tick_mark_text_color, this.progressDefaultColor);
        this.tickMarkInRangeTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_tick_mark_text_color, this.progressColor);
        t.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightNeeded = 2 * this.getLineTop() + this.progressHeight;
        heightSize = heightMode == 0x40000000 ? View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000) : (heightMode == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)0x40000000));
        super.onMeasure(widthMeasureSpec, heightSize);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.lineLeft = this.leftSB.getThumbSize() / 2 + this.getPaddingLeft();
        this.lineRight = w - this.lineLeft - this.getPaddingRight();
        this.lineWidth = this.lineRight - this.lineLeft;
        this.linePaddingRight = w - this.lineRight;
        this.backgroundLineRect.set((float)this.getLineLeft(), (float)this.getLineTop(), (float)this.getLineRight(), (float)this.getLineBottom());
        this.leftSB.onSizeChanged(this.getLineLeft(), this.getLineBottom(), this.lineWidth);
        if (this.rightSB != null) {
            this.rightSB.onSizeChanged(this.getLineLeft(), this.getLineBottom(), this.lineWidth);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.tickMarkTextArray != null) {
            int trickPartWidth = this.lineWidth / (this.tickMarkTextArray.length - 1);
            for (int i = 0; i < this.tickMarkTextArray.length; ++i) {
                float x;
                String text2Draw = this.tickMarkTextArray[i].toString();
                this.paint.setColor(this.tickMarkTextColor);
                if (this.tickMarkMode == 1) {
                    x = this.tickMarkGravity == 2 ? (float)(this.getLineLeft() + i * trickPartWidth) - this.paint.measureText(text2Draw) : (this.tickMarkGravity == 1 ? (float)(this.getLineLeft() + i * trickPartWidth) - this.paint.measureText(text2Draw) / 2.0f : (float)(this.getLineLeft() + i * trickPartWidth));
                } else {
                    float num = Float.parseFloat(text2Draw);
                    SeekBarState[] states = this.getRangeSeekBarState();
                    if (Utils.compareFloat(num, states[0].value) != -1 && Utils.compareFloat(num, states[1].value) != 1 && this.seekBarMode == 2) {
                        this.paint.setColor(this.tickMarkInRangeTextColor);
                    }
                    x = (float)this.getLineLeft() + (float)this.lineWidth * (num - this.minProgress) / (this.maxProgress - this.minProgress) - this.paint.measureText(text2Draw) / 2.0f;
                }
                float y = this.getLineTop() - this.tickMarkTextMargin;
                canvas.drawText(text2Draw, x, y, this.paint);
            }
        }
        this.paint.setColor(this.progressDefaultColor);
        canvas.drawRoundRect(this.backgroundLineRect, this.progressRadius, this.progressRadius, this.paint);
        this.paint.setColor(this.progressColor);
        if (this.seekBarMode == 2) {
            this.foregroundLineRect.top = this.getLineTop();
            this.foregroundLineRect.left = (float)(this.leftSB.left + this.leftSB.getThumbSize() / 2) + (float)this.lineWidth * this.leftSB.currPercent;
            this.foregroundLineRect.right = (float)(this.rightSB.left + this.rightSB.getThumbSize() / 2) + (float)this.lineWidth * this.rightSB.currPercent;
            this.foregroundLineRect.bottom = this.getLineBottom();
            canvas.drawRoundRect(this.foregroundLineRect, this.progressRadius, this.progressRadius, this.paint);
        } else {
            this.foregroundLineRect.top = this.getLineTop();
            this.foregroundLineRect.left = this.leftSB.left + this.leftSB.getThumbSize() / 2;
            this.foregroundLineRect.right = (float)(this.leftSB.left + this.leftSB.getThumbSize() / 2) + (float)this.lineWidth * this.leftSB.currPercent;
            this.foregroundLineRect.bottom = this.getLineBottom();
            canvas.drawRoundRect(this.foregroundLineRect, this.progressRadius, this.progressRadius, this.paint);
        }
        if (this.leftSB.getIndicatorShowMode() == 3) {
            this.leftSB.setShowIndicatorEnable(true);
        }
        this.leftSB.draw(canvas);
        if (this.rightSB != null) {
            if (this.rightSB.getIndicatorShowMode() == 3) {
                this.rightSB.setShowIndicatorEnable(true);
            }
            this.rightSB.draw(canvas);
        }
    }

    private void initPaint() {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.progressDefaultColor);
        this.paint.setTextSize((float)this.tickMarkTextSize);
    }

    public void setValue(float min, float max) {
        min += this.offsetValue;
        max += this.offsetValue;
        if (min < this.minPositiveValue) {
            throw new IllegalArgumentException("setValue() min < (preset min - offsetValue) . #min:" + min + " #preset min:" + this.minPositiveValue + " #offsetValue:" + this.offsetValue);
        }
        if (max > this.maxPositiveValue) {
            throw new IllegalArgumentException("setValue() max > (preset max - offsetValue) . #max:" + max + " #preset max:" + this.maxPositiveValue + " #offsetValue:" + this.offsetValue);
        }
        if (this.reserveCount > 1) {
            if ((min - this.minPositiveValue) % (float)this.reserveCount != 0.0f) {
                throw new IllegalArgumentException("setValue() (min - preset min) % reserveCount != 0 . #min:" + min + " #preset min:" + this.minPositiveValue + "#reserveCount:" + this.reserveCount + "#rangeInterval:" + this.rangeInterval);
            }
            if ((max - this.minPositiveValue) % (float)this.reserveCount != 0.0f) {
                throw new IllegalArgumentException("setValue() (max - preset min) % reserveCount != 0 . #max:" + max + " #preset min:" + this.minPositiveValue + "#reserveCount:" + this.reserveCount + "#rangeInterval:" + this.rangeInterval);
            }
            this.leftSB.currPercent = (min - this.minPositiveValue) / (float)this.reserveCount * this.cellsPercent;
            if (this.rightSB != null) {
                this.rightSB.currPercent = (max - this.minPositiveValue) / (float)this.reserveCount * this.cellsPercent;
            }
        } else {
            this.leftSB.currPercent = (min - this.minPositiveValue) / (this.maxPositiveValue - this.minPositiveValue);
            if (this.rightSB != null) {
                this.rightSB.currPercent = (max - this.minPositiveValue) / (this.maxPositiveValue - this.minPositiveValue);
            }
        }
        if (this.callback != null) {
            if (this.rightSB != null) {
                this.callback.onRangeChanged(this, this.leftSB.currPercent, this.rightSB.currPercent, false);
            } else {
                this.callback.onRangeChanged(this, this.leftSB.currPercent, this.leftSB.currPercent, false);
            }
        }
        this.invalidate();
    }

    public void setRangeRules(float min, float max, float reserve, int tickMarkNumber) {
        if (max <= min) {
            throw new IllegalArgumentException("setRangeRules() max must be greater than min ! #max:" + max + " #min:" + min);
        }
        if (reserve < 0.0f) {
            throw new IllegalArgumentException("setRangeRules() reserve must be greater than zero ! #reserve:" + reserve);
        }
        if (reserve >= max - min) {
            throw new IllegalArgumentException("setRangeRules() reserve must be less than (max - min) ! #reserve:" + reserve + " #max - min:" + (max - min));
        }
        if (tickMarkNumber < 1) {
            throw new IllegalArgumentException("setRangeRules() tickMarkNumber must be greater than 1 ! #tickMarkNumber:" + tickMarkNumber);
        }
        this.maxProgress = max;
        this.minProgress = min;
        if (min < 0.0f) {
            this.offsetValue = 0.0f - min;
            min += this.offsetValue;
            max += this.offsetValue;
        }
        this.minPositiveValue = min;
        this.maxPositiveValue = max;
        this.tickMarkNumber = tickMarkNumber;
        this.cellsPercent = 1.0f / (float)tickMarkNumber;
        this.rangeInterval = reserve;
        this.reservePercent = reserve / (max - min);
        this.reserveCount = (int)(this.reservePercent / this.cellsPercent + (float)(this.reservePercent % this.cellsPercent != 0.0f ? 1 : 0));
        if (tickMarkNumber > 1) {
            if (this.rightSB != null) {
                if (this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount <= 1.0f && this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount > this.rightSB.currPercent) {
                    this.rightSB.currPercent = this.leftSB.currPercent + this.cellsPercent * (float)this.reserveCount;
                } else if (this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount >= 0.0f && this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount < this.leftSB.currPercent) {
                    this.leftSB.currPercent = this.rightSB.currPercent - this.cellsPercent * (float)this.reserveCount;
                }
            } else if (1.0f - this.cellsPercent * (float)this.reserveCount >= 0.0f && 1.0f - this.cellsPercent * (float)this.reserveCount < this.leftSB.currPercent) {
                this.leftSB.currPercent = 1.0f - this.cellsPercent * (float)this.reserveCount;
            }
        } else if (this.rightSB != null) {
            if (this.leftSB.currPercent + this.reservePercent <= 1.0f && this.leftSB.currPercent + this.reservePercent > this.rightSB.currPercent) {
                this.rightSB.currPercent = this.leftSB.currPercent + this.reservePercent;
            } else if (this.rightSB.currPercent - this.reservePercent >= 0.0f && this.rightSB.currPercent - this.reservePercent < this.leftSB.currPercent) {
                this.leftSB.currPercent = this.rightSB.currPercent - this.reservePercent;
            }
        } else if (1.0f - this.reservePercent >= 0.0f && 1.0f - this.reservePercent < this.leftSB.currPercent) {
            this.leftSB.currPercent = 1.0f - this.reservePercent;
        }
        this.invalidate();
    }

    public SeekBarState[] getRangeSeekBarState() {
        float range = this.maxPositiveValue - this.minPositiveValue;
        SeekBarState leftSeekBarState = new SeekBarState();
        leftSeekBarState.value = -this.offsetValue + this.minPositiveValue + range * this.leftSB.currPercent;
        if (this.tickMarkNumber > 1) {
            int index = (int)Math.floor(this.leftSB.currPercent * (float)this.tickMarkNumber);
            if (this.tickMarkTextArray != null && index >= 0 && index < this.tickMarkTextArray.length) {
                leftSeekBarState.indicatorText = this.tickMarkTextArray[index].toString();
            }
            if (index == 0) {
                leftSeekBarState.isMin = true;
            } else if (index == this.tickMarkNumber) {
                leftSeekBarState.isMax = true;
            }
        } else {
            leftSeekBarState.indicatorText = new StringBuffer().append(leftSeekBarState.value).toString();
            if (Utils.compareFloat(this.leftSB.currPercent, 0.0f) == 0) {
                leftSeekBarState.isMin = true;
            } else if (Utils.compareFloat(this.leftSB.currPercent, 1.0f) == 0) {
                leftSeekBarState.isMax = true;
            }
        }
        SeekBarState rightSeekBarState = new SeekBarState();
        rightSeekBarState.value = range;
        if (this.rightSB != null) {
            if (this.tickMarkNumber > 1) {
                int index = (int)Math.floor(this.rightSB.currPercent * (float)this.tickMarkNumber);
                if (this.tickMarkTextArray != null && index >= 0 && index < this.tickMarkTextArray.length) {
                    leftSeekBarState.indicatorText = this.tickMarkTextArray[index].toString();
                }
                if (index == 0) {
                    rightSeekBarState.isMin = true;
                } else if (index == this.tickMarkNumber) {
                    rightSeekBarState.isMax = true;
                }
            } else {
                rightSeekBarState.value = -this.offsetValue + this.minPositiveValue + range * this.rightSB.currPercent;
                rightSeekBarState.indicatorText = new StringBuffer().append(rightSeekBarState.value).toString();
                if (Utils.compareFloat(this.rightSB.currPercent, 0.0f) == 0) {
                    rightSeekBarState.isMin = true;
                } else if (Utils.compareFloat(this.rightSB.currPercent, 1.0f) == 0) {
                    rightSeekBarState.isMax = true;
                }
            }
        }
        return new SeekBarState[]{leftSeekBarState, rightSeekBarState};
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.isEnable = enabled;
    }

    public void setIndicatorText(String progress) {
        if (this.leftSB != null) {
            this.leftSB.setIndicatorText(progress);
        }
        if (this.rightSB != null) {
            this.rightSB.setIndicatorText(progress);
        }
    }

    public void setIndicatorTextDecimalFormat(String formatPattern) {
        if (this.leftSB != null) {
            this.leftSB.setIndicatorTextDecimalFormat(formatPattern);
        }
        if (this.rightSB != null) {
            this.rightSB.setIndicatorTextDecimalFormat(formatPattern);
        }
    }

    public void setIndicatorTextStringFormat(String formatPattern) {
        if (this.leftSB != null) {
            this.leftSB.setIndicatorTextStringFormat(formatPattern);
        }
        if (this.rightSB != null) {
            this.rightSB.setIndicatorTextStringFormat(formatPattern);
        }
    }

    private void changeThumbActivateState(boolean hasActivate) {
        if (hasActivate && this.currTouchSB != null) {
            boolean state;
            boolean bl = state = this.currTouchSB == this.leftSB;
            if (this.leftSB != null) {
                this.leftSB.setActivate(state);
            }
            if (this.rightSB != null) {
                this.rightSB.setActivate(!state);
            }
        } else {
            if (this.leftSB != null) {
                this.leftSB.setActivate(false);
            }
            if (this.rightSB != null) {
                this.rightSB.setActivate(false);
            }
        }
    }

    protected float getEventX(MotionEvent event) {
        return event.getX();
    }

    protected float getEventY(MotionEvent event) {
        return event.getY();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnable) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.touchDownX = this.getEventX(event);
                boolean touchResult = false;
                if (this.rightSB != null && this.rightSB.currPercent >= 1.0f && this.leftSB.collide(this.getEventX(event), this.getEventY(event))) {
                    this.currTouchSB = this.leftSB;
                    touchResult = true;
                } else if (this.rightSB != null && this.rightSB.collide(this.getEventX(event), this.getEventY(event))) {
                    this.currTouchSB = this.rightSB;
                    touchResult = true;
                } else if (this.leftSB.collide(this.getEventX(event), this.getEventY(event))) {
                    this.currTouchSB = this.leftSB;
                    touchResult = true;
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback != null) {
                    this.callback.onStartTrackingTouch(this, this.currTouchSB == this.leftSB);
                }
                this.changeThumbActivateState(true);
                return touchResult;
            }
            case 2: {
                float x = this.getEventX(event);
                if (this.rightSB != null && this.leftSB.currPercent == this.rightSB.currPercent) {
                    this.currTouchSB.materialRestore();
                    if (this.callback != null) {
                        this.callback.onStopTrackingTouch(this, this.currTouchSB == this.leftSB);
                    }
                    this.currTouchSB = x - this.touchDownX > 0.0f ? this.rightSB : this.leftSB;
                    if (this.callback != null) {
                        this.callback.onStartTrackingTouch(this, this.currTouchSB == this.leftSB);
                    }
                }
                this.touchDownX = x;
                float f = this.currTouchSB.material = this.currTouchSB.material >= 1.0f ? 1.0f : this.currTouchSB.material + 0.1f;
                if (this.currTouchSB == this.leftSB) {
                    float percent;
                    if (this.tickMarkNumber > 1) {
                        percent = x < (float)this.getLineLeft() ? 0.0f : (x - (float)this.getLineLeft()) * 1.0f / (float)this.lineWidth;
                        int touchLeftCellsValue = Math.round(percent / this.cellsPercent);
                        int currRightCellsValue = this.rightSB != null ? Math.round(this.rightSB.currPercent / this.cellsPercent) : Math.round(1.0f / this.cellsPercent);
                        percent = (float)touchLeftCellsValue * this.cellsPercent;
                        while (touchLeftCellsValue > currRightCellsValue - this.reserveCount && --touchLeftCellsValue >= 0) {
                            percent = (float)touchLeftCellsValue * this.cellsPercent;
                        }
                    } else {
                        percent = x < (float)this.getLineLeft() ? 0.0f : (x - (float)this.getLineLeft()) * 1.0f / (float)this.lineWidth;
                        if (this.rightSB != null) {
                            if (percent > this.rightSB.currPercent - this.reservePercent) {
                                percent = this.rightSB.currPercent - this.reservePercent;
                            }
                        } else if (percent > 1.0f - this.reservePercent) {
                            percent = 1.0f - this.reservePercent;
                        }
                    }
                    this.leftSB.slide(percent);
                    this.leftSB.setShowIndicatorEnable(true);
                    if (this.getParent() != null) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                } else if (this.currTouchSB == this.rightSB) {
                    float percent;
                    if (this.tickMarkNumber > 1) {
                        percent = x > (float)this.getLineRight() ? 1.0f : (x - (float)this.getLineLeft()) * 1.0f / (float)this.lineWidth;
                        int touchRightCellsValue = Math.round(percent / this.cellsPercent);
                        int currLeftCellsValue = Math.round(this.leftSB.currPercent / this.cellsPercent);
                        percent = (float)touchRightCellsValue * this.cellsPercent;
                        while (touchRightCellsValue < currLeftCellsValue + this.reserveCount && !((float)(++touchRightCellsValue) > this.maxPositiveValue - this.minPositiveValue)) {
                            percent = (float)touchRightCellsValue * this.cellsPercent;
                        }
                    } else {
                        percent = x > (float)this.getLineRight() ? 1.0f : (x - (float)this.getLineLeft()) * 1.0f / (float)this.lineWidth;
                        if (percent < this.leftSB.currPercent + this.reservePercent) {
                            percent = this.leftSB.currPercent + this.reservePercent;
                        }
                    }
                    this.rightSB.slide(percent);
                    this.rightSB.setShowIndicatorEnable(true);
                }
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, true);
                }
                this.invalidate();
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.changeThumbActivateState(true);
                break;
            }
            case 3: {
                if (this.rightSB != null) {
                    this.rightSB.setShowIndicatorEnable(false);
                }
                this.leftSB.setShowIndicatorEnable(false);
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, false);
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.changeThumbActivateState(false);
                break;
            }
            case 1: {
                if (this.rightSB != null) {
                    this.rightSB.setShowIndicatorEnable(false);
                }
                this.leftSB.setShowIndicatorEnable(false);
                this.currTouchSB.materialRestore();
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, false);
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback != null) {
                    this.callback.onStopTrackingTouch(this, this.currTouchSB == this.leftSB);
                }
                this.changeThumbActivateState(false);
            }
        }
        return super.onTouchEvent(event);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.minValue = this.minPositiveValue - this.offsetValue;
        ss.maxValue = this.maxPositiveValue - this.offsetValue;
        ss.rangeInterval = this.rangeInterval;
        ss.tickNumber = this.tickMarkNumber;
        SeekBarState[] results = this.getRangeSeekBarState();
        ss.currSelectedMin = results[0].value;
        ss.currSelectedMax = results[1].value;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        float min = ss.minValue;
        float max = ss.maxValue;
        float rangeInterval = ss.rangeInterval;
        int tickNumber = ss.tickNumber;
        this.setRangeRules(min, max, rangeInterval, tickNumber);
        float currSelectedMin = ss.currSelectedMin;
        float currSelectedMax = ss.currSelectedMax;
        this.setValue(currSelectedMin, currSelectedMax);
    }

    public void setOnRangeChangedListener(OnRangeChangedListener listener) {
        this.callback = listener;
    }

    public SeekBar getLeftSeekBar() {
        return this.leftSB;
    }

    public SeekBar getRightSeekBar() {
        return this.rightSB;
    }

    public int getLineTop() {
        return this.lineTop;
    }

    public void setLineTop(int lineTop) {
        this.lineTop = lineTop;
    }

    public int getLineBottom() {
        return this.lineBottom;
    }

    public void setLineBottom(int lineBottom) {
        this.lineBottom = lineBottom;
    }

    public int getLineLeft() {
        return this.lineLeft;
    }

    public void setLineLeft(int lineLeft) {
        this.lineLeft = lineLeft;
    }

    public int getLineRight() {
        return this.lineRight;
    }

    public void setLineRight(int lineRight) {
        this.lineRight = lineRight;
    }

    public int getLinePaddingRight() {
        return this.linePaddingRight;
    }

    public int getProgressHeight() {
        return this.progressHeight;
    }

    public void setProgressHeight(int progressHeight) {
        this.progressHeight = progressHeight;
    }

    public float getMinProgress() {
        return this.minProgress;
    }

    public void setMinProgress(float minProgress) {
        this.minProgress = minProgress;
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setValue(float value) {
        this.setValue(value, this.maxProgress);
    }

    public void setProgressColor(int progressDefaultColor, int progressColor) {
        this.progressDefaultColor = progressDefaultColor;
        this.progressColor = progressColor;
    }

    public int getTickMarkTextColor() {
        return this.tickMarkTextColor;
    }

    public void setTickMarkTextColor(int tickMarkTextColor) {
        this.tickMarkTextColor = tickMarkTextColor;
    }

    public int getTickMarkInRangeTextColor() {
        return this.tickMarkInRangeTextColor;
    }

    public void setTickMarkInRangeTextColor(int tickMarkInRangeTextColor) {
        this.tickMarkInRangeTextColor = tickMarkInRangeTextColor;
    }

    public int getSeekBarMode() {
        return this.seekBarMode;
    }

    public int getTickMarkMode() {
        return this.tickMarkMode;
    }

    public int getTickMarkNumber() {
        return this.tickMarkNumber;
    }

    public int getTickMarkTextMargin() {
        return this.tickMarkTextMargin;
    }

    public void setTickMarkTextMargin(int tickMarkTextMargin) {
        this.tickMarkTextMargin = tickMarkTextMargin;
    }

    public int getTickMarkTextSize() {
        return this.tickMarkTextSize;
    }

    public void setTickMarkTextSize(int tickMarkTextSize) {
        this.tickMarkTextSize = tickMarkTextSize;
    }

    public int getTickMarkGravity() {
        return this.tickMarkGravity;
    }

    public void setTickMarkGravity(int tickMarkGravity) {
        this.tickMarkGravity = tickMarkGravity;
    }

    public CharSequence[] getTickMarkTextArray() {
        return this.tickMarkTextArray;
    }

    public void setTickMarkTextArray(CharSequence[] tickMarkTextArray) {
        this.tickMarkTextArray = tickMarkTextArray;
    }

    public float getRangeInterval() {
        return this.rangeInterval;
    }

    public void setRangeInterval(float rangeInterval) {
        this.rangeInterval = rangeInterval;
    }

    public float getProgressRadius() {
        return this.progressRadius;
    }

    public void setProgressRadius(float progressRadius) {
        this.progressRadius = progressRadius;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
    }

    public int getProgressDefaultColor() {
        return this.progressDefaultColor;
    }

    public void setProgressDefaultColor(int progressDefaultColor) {
        this.progressDefaultColor = progressDefaultColor;
    }

    public void setTickMarkNumber(int tickMarkNumber) {
        this.tickMarkNumber = tickMarkNumber;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setTickMarkMode(int tickMarkMode) {
        this.tickMarkMode = tickMarkMode;
    }

    public void setSeekBarMode(int seekBarMode) {
        this.seekBarMode = seekBarMode;
    }
}

