/*
 * Decompiled with CFR 0.152.
 */
package com.jaygoo.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.jaygoo.widget.OnRangeChangedListener;
import com.jaygoo.widget.R;
import com.jaygoo.widget.SavedState;
import com.jaygoo.widget.SeekBar;
import com.jaygoo.widget.SeekBarState;
import com.jaygoo.widget.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class RangeSeekBar
extends View {
    private static final int MIN_INTERCEPT_DISTANCE = 100;
    public static final int SEEKBAR_MODE_SINGLE = 1;
    public static final int SEEKBAR_MODE_RANGE = 2;
    public static final int TRICK_MARK_MODE_NUMBER = 0;
    public static final int TRICK_MARK_MODE_OTHER = 1;
    public static final int TICK_MARK_GRAVITY_LEFT = 0;
    public static final int TICK_MARK_GRAVITY_CENTER = 1;
    public static final int TICK_MARK_GRAVITY_RIGHT = 2;
    private int progressTop;
    private int progressBottom;
    private int progressLeft;
    private int progressRight;
    private int seekBarMode;
    private int tickMarkMode;
    private int tickMarkTextMargin;
    private int tickMarkTextSize;
    private int tickMarkGravity;
    private int tickMarkLayoutGravity;
    private int tickMarkTextColor;
    private int tickMarkInRangeTextColor;
    private CharSequence[] tickMarkTextArray;
    private float progressRadius;
    private int progressColor;
    private int progressDefaultColor;
    private int progressDrawableId;
    private int progressDefaultDrawableId;
    private int progressHeight;
    private int progressWidth;
    private float minInterval;
    private int gravity;
    private boolean enableThumbOverlap;
    private int stepsColor;
    private float stepsWidth;
    private float stepsHeight;
    private float stepsRadius;
    private int steps;
    private boolean stepsAutoBonding;
    private int stepsDrawableId;
    private float minProgress;
    private float maxProgress;
    private boolean isEnable = true;
    float touchDownX;
    float touchDownY;
    float reservePercent;
    boolean isScaleThumb = false;
    Paint paint = new Paint();
    RectF progressDefaultDstRect = new RectF();
    RectF progressDstRect = new RectF();
    Rect progressSrcRect = new Rect();
    RectF stepDivRect = new RectF();
    Rect tickMarkTextRect = new Rect();
    SeekBar leftSB;
    SeekBar rightSB;
    SeekBar currTouchSB;
    Bitmap progressBitmap;
    Bitmap progressDefaultBitmap;
    List<Bitmap> stepsBitmaps = new ArrayList<Bitmap>();
    private int progressPaddingRight;
    private OnRangeChangedListener callback;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initPaint();
        this.initSeekBar(attrs);
        this.initStepsBitmap();
    }

    private void initProgressBitmap() {
        if (this.progressBitmap == null) {
            this.progressBitmap = Utils.drawableToBitmap(this.getContext(), this.progressWidth, this.progressHeight, this.progressDrawableId);
        }
        if (this.progressDefaultBitmap == null) {
            this.progressDefaultBitmap = Utils.drawableToBitmap(this.getContext(), this.progressWidth, this.progressHeight, this.progressDefaultDrawableId);
        }
    }

    private boolean verifyStepsMode() {
        return this.steps >= 1 && !(this.stepsHeight <= 0.0f) && !(this.stepsWidth <= 0.0f);
    }

    private void initStepsBitmap() {
        if (!this.verifyStepsMode() || this.stepsDrawableId == 0) {
            return;
        }
        if (this.stepsBitmaps.isEmpty()) {
            Bitmap bitmap = Utils.drawableToBitmap(this.getContext(), (int)this.stepsWidth, (int)this.stepsHeight, this.stepsDrawableId);
            for (int i = 0; i <= this.steps; ++i) {
                this.stepsBitmaps.add(bitmap);
            }
        }
    }

    private void initSeekBar(AttributeSet attrs) {
        this.leftSB = new SeekBar(this, attrs, true);
        this.rightSB = new SeekBar(this, attrs, false);
        this.rightSB.setVisible(this.seekBarMode != 1);
    }

    private void initAttrs(AttributeSet attrs) {
        try {
            TypedArray t = this.getContext().obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
            this.seekBarMode = t.getInt(R.styleable.RangeSeekBar_rsb_mode, 2);
            this.minProgress = t.getFloat(R.styleable.RangeSeekBar_rsb_min, 0.0f);
            this.maxProgress = t.getFloat(R.styleable.RangeSeekBar_rsb_max, 100.0f);
            this.minInterval = t.getFloat(R.styleable.RangeSeekBar_rsb_min_interval, 0.0f);
            this.gravity = t.getInt(R.styleable.RangeSeekBar_rsb_gravity, 0);
            this.progressColor = t.getColor(R.styleable.RangeSeekBar_rsb_progress_color, -11806366);
            this.progressRadius = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_progress_radius, -1.0f);
            this.progressDefaultColor = t.getColor(R.styleable.RangeSeekBar_rsb_progress_default_color, -2631721);
            this.progressDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_progress_drawable, 0);
            this.progressDefaultDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_progress_drawable_default, 0);
            this.progressHeight = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_progress_height, (float)Utils.dp2px(this.getContext(), 2.0f));
            this.tickMarkMode = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_mode, 0);
            this.tickMarkGravity = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_gravity, 1);
            this.tickMarkLayoutGravity = t.getInt(R.styleable.RangeSeekBar_rsb_tick_mark_layout_gravity, 0);
            this.tickMarkTextArray = t.getTextArray(R.styleable.RangeSeekBar_rsb_tick_mark_text_array);
            this.tickMarkTextMargin = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_tick_mark_text_margin, (float)Utils.dp2px(this.getContext(), 7.0f));
            this.tickMarkTextSize = (int)t.getDimension(R.styleable.RangeSeekBar_rsb_tick_mark_text_size, (float)Utils.dp2px(this.getContext(), 12.0f));
            this.tickMarkTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_tick_mark_text_color, this.progressDefaultColor);
            this.tickMarkInRangeTextColor = t.getColor(R.styleable.RangeSeekBar_rsb_tick_mark_text_color, this.progressColor);
            this.steps = t.getInt(R.styleable.RangeSeekBar_rsb_steps, 0);
            this.stepsColor = t.getColor(R.styleable.RangeSeekBar_rsb_step_color, -6447715);
            this.stepsRadius = t.getDimension(R.styleable.RangeSeekBar_rsb_step_radius, 0.0f);
            this.stepsWidth = t.getDimension(R.styleable.RangeSeekBar_rsb_step_width, 0.0f);
            this.stepsHeight = t.getDimension(R.styleable.RangeSeekBar_rsb_step_height, 0.0f);
            this.stepsDrawableId = t.getResourceId(R.styleable.RangeSeekBar_rsb_step_drawable, 0);
            this.stepsAutoBonding = t.getBoolean(R.styleable.RangeSeekBar_rsb_step_auto_bonding, true);
            t.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onMeasureProgress(int w, int h) {
        int viewHeight = h - this.getPaddingBottom() - this.getPaddingTop();
        if (h <= 0) {
            return;
        }
        if (this.gravity == 0) {
            float maxIndicatorHeight = 0.0f;
            if (this.leftSB.getIndicatorShowMode() != 1 || this.rightSB.getIndicatorShowMode() != 1) {
                maxIndicatorHeight = Math.max(this.leftSB.getIndicatorRawHeight(), this.rightSB.getIndicatorRawHeight());
            }
            float thumbHeight = Math.max(this.leftSB.getThumbScaleHeight(), this.rightSB.getThumbScaleHeight());
            this.progressTop = (int)(maxIndicatorHeight + ((thumbHeight -= (float)this.progressHeight / 2.0f) - (float)this.progressHeight) / 2.0f);
            if (this.tickMarkTextArray != null && this.tickMarkLayoutGravity == 0) {
                this.progressTop = (int)Math.max((float)this.getTickMarkRawHeight(), maxIndicatorHeight + (thumbHeight - (float)this.progressHeight) / 2.0f);
            }
            this.progressBottom = this.progressTop + this.progressHeight;
        } else if (this.gravity == 1) {
            this.progressBottom = this.tickMarkTextArray != null && this.tickMarkLayoutGravity == 1 ? viewHeight - this.getTickMarkRawHeight() : (int)((float)viewHeight - Math.max(this.leftSB.getThumbScaleHeight(), this.rightSB.getThumbScaleHeight()) / 2.0f + (float)this.progressHeight / 2.0f);
            this.progressTop = this.progressBottom - this.progressHeight;
        } else {
            this.progressTop = (viewHeight - this.progressHeight) / 2;
            this.progressBottom = this.progressTop + this.progressHeight;
        }
        int maxThumbWidth = (int)Math.max(this.leftSB.getThumbScaleWidth(), this.rightSB.getThumbScaleWidth());
        this.progressLeft = maxThumbWidth / 2 + this.getPaddingLeft();
        this.progressRight = w - maxThumbWidth / 2 - this.getPaddingRight();
        this.progressWidth = this.progressRight - this.progressLeft;
        this.progressDefaultDstRect.set((float)this.getProgressLeft(), (float)this.getProgressTop(), (float)this.getProgressRight(), (float)this.getProgressBottom());
        this.progressPaddingRight = w - this.progressRight;
        if (this.progressRadius <= 0.0f) {
            this.progressRadius = (int)((float)(this.getProgressBottom() - this.getProgressTop()) * 0.45f);
        }
        this.initProgressBitmap();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            heightSize = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000);
        } else if (heightMode == Integer.MIN_VALUE && this.getParent() instanceof ViewGroup && heightSize == -1) {
            heightSize = View.MeasureSpec.makeMeasureSpec((int)((ViewGroup)this.getParent()).getMeasuredHeight(), (int)Integer.MIN_VALUE);
        } else {
            int heightNeeded = this.gravity == 2 ? (this.tickMarkTextArray != null && this.tickMarkLayoutGravity == 1 ? (int)(2.0f * (this.getRawHeight() - (float)this.getTickMarkRawHeight())) : (int)(2.0f * (this.getRawHeight() - Math.max(this.leftSB.getThumbScaleHeight(), this.rightSB.getThumbScaleHeight()) / 2.0f))) : (int)this.getRawHeight();
            heightSize = View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightSize);
    }

    protected int getTickMarkRawHeight() {
        if (this.tickMarkTextArray != null && this.tickMarkTextArray.length > 0) {
            return this.tickMarkTextMargin + Utils.measureText(String.valueOf(this.tickMarkTextArray[0]), this.tickMarkTextSize).height() + 3;
        }
        return 0;
    }

    protected float getRawHeight() {
        float rawHeight;
        if (this.seekBarMode == 1) {
            rawHeight = this.leftSB.getRawHeight();
            if (this.tickMarkLayoutGravity == 1 && this.tickMarkTextArray != null) {
                float h = Math.max((this.leftSB.getThumbScaleHeight() - (float)this.progressHeight) / 2.0f, (float)this.getTickMarkRawHeight());
                rawHeight = rawHeight - this.leftSB.getThumbScaleHeight() / 2.0f + (float)this.progressHeight / 2.0f + h;
            }
        } else {
            rawHeight = Math.max(this.leftSB.getRawHeight(), this.rightSB.getRawHeight());
            if (this.tickMarkLayoutGravity == 1 && this.tickMarkTextArray != null) {
                float thumbHeight = Math.max(this.leftSB.getThumbScaleHeight(), this.rightSB.getThumbScaleHeight());
                float h = Math.max((thumbHeight - (float)this.progressHeight) / 2.0f, (float)this.getTickMarkRawHeight());
                rawHeight = rawHeight - thumbHeight / 2.0f + (float)this.progressHeight / 2.0f + h;
            }
        }
        return rawHeight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onMeasureProgress(w, h);
        this.setRange(this.minProgress, this.maxProgress, this.minInterval);
        int lineCenterY = (this.getProgressBottom() + this.getProgressTop()) / 2;
        this.leftSB.onSizeChanged(this.getProgressLeft(), lineCenterY);
        if (this.seekBarMode == 2) {
            this.rightSB.onSizeChanged(this.getProgressLeft(), lineCenterY);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.onDrawTickMark(canvas, this.paint);
        this.onDrawProgressBar(canvas, this.paint);
        this.onDrawSteps(canvas, this.paint);
        this.onDrawSeekBar(canvas);
    }

    protected void onDrawTickMark(Canvas canvas, Paint paint) {
        if (this.tickMarkTextArray != null) {
            int trickPartWidth = this.progressWidth / (this.tickMarkTextArray.length - 1);
            for (int i = 0; i < this.tickMarkTextArray.length; ++i) {
                float x;
                String text2Draw = this.tickMarkTextArray[i].toString();
                if (TextUtils.isEmpty((CharSequence)text2Draw)) continue;
                paint.getTextBounds(text2Draw, 0, text2Draw.length(), this.tickMarkTextRect);
                paint.setColor(this.tickMarkTextColor);
                if (this.tickMarkMode == 1) {
                    x = this.tickMarkGravity == 2 ? (float)(this.getProgressLeft() + i * trickPartWidth - this.tickMarkTextRect.width()) : (this.tickMarkGravity == 1 ? (float)(this.getProgressLeft() + i * trickPartWidth) - (float)this.tickMarkTextRect.width() / 2.0f : (float)(this.getProgressLeft() + i * trickPartWidth));
                } else {
                    float num = Utils.parseFloat(text2Draw);
                    SeekBarState[] states = this.getRangeSeekBarState();
                    if (Utils.compareFloat(num, states[0].value) != -1 && Utils.compareFloat(num, states[1].value) != 1 && this.seekBarMode == 2) {
                        paint.setColor(this.tickMarkInRangeTextColor);
                    }
                    x = (float)this.getProgressLeft() + (float)this.progressWidth * (num - this.minProgress) / (this.maxProgress - this.minProgress) - (float)this.tickMarkTextRect.width() / 2.0f;
                }
                float y = this.tickMarkLayoutGravity == 0 ? (float)(this.getProgressTop() - this.tickMarkTextMargin) : (float)(this.getProgressBottom() + this.tickMarkTextMargin + this.tickMarkTextRect.height());
                canvas.drawText(text2Draw, x, y, paint);
            }
        }
    }

    protected void onDrawProgressBar(Canvas canvas, Paint paint) {
        if (Utils.verifyBitmap(this.progressDefaultBitmap)) {
            canvas.drawBitmap(this.progressDefaultBitmap, null, this.progressDefaultDstRect, paint);
        } else {
            paint.setColor(this.progressDefaultColor);
            canvas.drawRoundRect(this.progressDefaultDstRect, this.progressRadius, this.progressRadius, paint);
        }
        if (this.seekBarMode == 2) {
            this.progressDstRect.top = this.getProgressTop();
            this.progressDstRect.left = (float)this.leftSB.left + this.leftSB.getThumbScaleWidth() / 2.0f + (float)this.progressWidth * this.leftSB.currPercent;
            this.progressDstRect.right = (float)this.rightSB.left + this.rightSB.getThumbScaleWidth() / 2.0f + (float)this.progressWidth * this.rightSB.currPercent;
            this.progressDstRect.bottom = this.getProgressBottom();
        } else {
            this.progressDstRect.top = this.getProgressTop();
            this.progressDstRect.left = (float)this.leftSB.left + this.leftSB.getThumbScaleWidth() / 2.0f;
            this.progressDstRect.right = (float)this.leftSB.left + this.leftSB.getThumbScaleWidth() / 2.0f + (float)this.progressWidth * this.leftSB.currPercent;
            this.progressDstRect.bottom = this.getProgressBottom();
        }
        if (Utils.verifyBitmap(this.progressBitmap)) {
            this.progressSrcRect.top = 0;
            this.progressSrcRect.bottom = this.progressBitmap.getHeight();
            int bitmapWidth = this.progressBitmap.getWidth();
            if (this.seekBarMode == 2) {
                this.progressSrcRect.left = (int)((float)bitmapWidth * this.leftSB.currPercent);
                this.progressSrcRect.right = (int)((float)bitmapWidth * this.rightSB.currPercent);
            } else {
                this.progressSrcRect.left = 0;
                this.progressSrcRect.right = (int)((float)bitmapWidth * this.leftSB.currPercent);
            }
            canvas.drawBitmap(this.progressBitmap, this.progressSrcRect, this.progressDstRect, null);
        } else {
            paint.setColor(this.progressColor);
            canvas.drawRoundRect(this.progressDstRect, this.progressRadius, this.progressRadius, paint);
        }
    }

    protected void onDrawSteps(Canvas canvas, Paint paint) {
        if (!this.verifyStepsMode()) {
            return;
        }
        int stepMarks = this.getProgressWidth() / this.steps;
        float extHeight = (this.stepsHeight - (float)this.getProgressHeight()) / 2.0f;
        for (int k = 0; k <= this.steps; ++k) {
            float x = (float)(this.getProgressLeft() + k * stepMarks) - this.stepsWidth / 2.0f;
            this.stepDivRect.set(x, (float)this.getProgressTop() - extHeight, x + this.stepsWidth, (float)this.getProgressBottom() + extHeight);
            if (this.stepsBitmaps.isEmpty() || this.stepsBitmaps.size() <= k) {
                paint.setColor(this.stepsColor);
                canvas.drawRoundRect(this.stepDivRect, this.stepsRadius, this.stepsRadius, paint);
                continue;
            }
            canvas.drawBitmap(this.stepsBitmaps.get(k), null, this.stepDivRect, paint);
        }
    }

    protected void onDrawSeekBar(Canvas canvas) {
        if (this.leftSB.getIndicatorShowMode() == 3) {
            this.leftSB.setShowIndicatorEnable(true);
        }
        this.leftSB.draw(canvas);
        if (this.seekBarMode == 2) {
            if (this.rightSB.getIndicatorShowMode() == 3) {
                this.rightSB.setShowIndicatorEnable(true);
            }
            this.rightSB.draw(canvas);
        }
    }

    private void initPaint() {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.progressDefaultColor);
        this.paint.setTextSize((float)this.tickMarkTextSize);
    }

    private void changeThumbActivateState(boolean hasActivate) {
        if (hasActivate && this.currTouchSB != null) {
            boolean state = this.currTouchSB == this.leftSB;
            this.leftSB.setActivate(state);
            if (this.seekBarMode == 2) {
                this.rightSB.setActivate(!state);
            }
        } else {
            this.leftSB.setActivate(false);
            if (this.seekBarMode == 2) {
                this.rightSB.setActivate(false);
            }
        }
    }

    protected float getEventX(MotionEvent event) {
        return event.getX();
    }

    protected float getEventY(MotionEvent event) {
        return event.getY();
    }

    private void scaleCurrentSeekBarThumb() {
        if (this.currTouchSB != null && this.currTouchSB.getThumbScaleRatio() > 1.0f && !this.isScaleThumb) {
            this.isScaleThumb = true;
            this.currTouchSB.scaleThumb();
        }
    }

    private void resetCurrentSeekBarThumb() {
        if (this.currTouchSB != null && this.currTouchSB.getThumbScaleRatio() > 1.0f && this.isScaleThumb) {
            this.isScaleThumb = false;
            this.currTouchSB.resetThumb();
        }
    }

    protected float calculateCurrentSeekBarPercent(float touchDownX) {
        if (this.currTouchSB == null) {
            return 0.0f;
        }
        float percent = (touchDownX - (float)this.getProgressLeft()) * 1.0f / (float)this.progressWidth;
        if (touchDownX < (float)this.getProgressLeft()) {
            percent = 0.0f;
        } else if (touchDownX > (float)this.getProgressRight()) {
            percent = 1.0f;
        }
        if (this.seekBarMode == 2) {
            if (this.currTouchSB == this.leftSB) {
                if (percent > this.rightSB.currPercent - this.reservePercent) {
                    percent = this.rightSB.currPercent - this.reservePercent;
                }
            } else if (this.currTouchSB == this.rightSB && percent < this.leftSB.currPercent + this.reservePercent) {
                percent = this.leftSB.currPercent + this.reservePercent;
            }
        }
        return percent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnable) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.touchDownX = this.getEventX(event);
                this.touchDownY = this.getEventY(event);
                if (this.seekBarMode == 2) {
                    if (this.rightSB.currPercent >= 1.0f && this.leftSB.collide(this.getEventX(event), this.getEventY(event))) {
                        this.currTouchSB = this.leftSB;
                        this.scaleCurrentSeekBarThumb();
                    } else if (this.rightSB.collide(this.getEventX(event), this.getEventY(event))) {
                        this.currTouchSB = this.rightSB;
                        this.scaleCurrentSeekBarThumb();
                    } else {
                        float distanceRight;
                        float performClick = (this.touchDownX - (float)this.getProgressLeft()) * 1.0f / (float)this.progressWidth;
                        float distanceLeft = Math.abs(this.leftSB.currPercent - performClick);
                        this.currTouchSB = distanceLeft < (distanceRight = Math.abs(this.rightSB.currPercent - performClick)) ? this.leftSB : this.rightSB;
                        performClick = this.calculateCurrentSeekBarPercent(this.touchDownX);
                        this.currTouchSB.slide(performClick);
                    }
                } else {
                    this.currTouchSB = this.leftSB;
                    this.scaleCurrentSeekBarThumb();
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback != null) {
                    this.callback.onStartTrackingTouch(this, this.currTouchSB == this.leftSB);
                }
                this.changeThumbActivateState(true);
                return true;
            }
            case 2: {
                float x = this.getEventX(event);
                if (this.seekBarMode == 2 && this.leftSB.currPercent == this.rightSB.currPercent) {
                    this.currTouchSB.materialRestore();
                    if (this.callback != null) {
                        this.callback.onStopTrackingTouch(this, this.currTouchSB == this.leftSB);
                    }
                    if (x - this.touchDownX > 0.0f) {
                        if (this.currTouchSB != this.rightSB) {
                            this.currTouchSB.setShowIndicatorEnable(false);
                            this.resetCurrentSeekBarThumb();
                            this.currTouchSB = this.rightSB;
                        }
                    } else if (this.currTouchSB != this.leftSB) {
                        this.currTouchSB.setShowIndicatorEnable(false);
                        this.resetCurrentSeekBarThumb();
                        this.currTouchSB = this.leftSB;
                    }
                    if (this.callback != null) {
                        this.callback.onStartTrackingTouch(this, this.currTouchSB == this.leftSB);
                    }
                }
                this.scaleCurrentSeekBarThumb();
                this.currTouchSB.material = this.currTouchSB.material >= 1.0f ? 1.0f : this.currTouchSB.material + 0.1f;
                this.touchDownX = x;
                this.currTouchSB.slide(this.calculateCurrentSeekBarPercent(this.touchDownX));
                this.currTouchSB.setShowIndicatorEnable(true);
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, true);
                }
                this.invalidate();
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.changeThumbActivateState(true);
                break;
            }
            case 3: {
                if (this.seekBarMode == 2) {
                    this.rightSB.setShowIndicatorEnable(false);
                }
                if (this.currTouchSB == this.leftSB) {
                    this.resetCurrentSeekBarThumb();
                } else if (this.currTouchSB == this.rightSB) {
                    this.resetCurrentSeekBarThumb();
                }
                this.leftSB.setShowIndicatorEnable(false);
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, false);
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.changeThumbActivateState(false);
                break;
            }
            case 1: {
                if (this.verifyStepsMode() && this.stepsAutoBonding) {
                    float percent = this.calculateCurrentSeekBarPercent(this.getEventX(event));
                    float stepPercent = 1.0f / (float)this.steps;
                    int stepSelected = new BigDecimal(percent / stepPercent).setScale(0, RoundingMode.HALF_UP).intValue();
                    this.currTouchSB.slide((float)stepSelected * stepPercent);
                }
                if (this.seekBarMode == 2) {
                    this.rightSB.setShowIndicatorEnable(false);
                }
                this.leftSB.setShowIndicatorEnable(false);
                this.currTouchSB.materialRestore();
                this.resetCurrentSeekBarThumb();
                if (this.callback != null) {
                    SeekBarState[] states = this.getRangeSeekBarState();
                    this.callback.onRangeChanged(this, states[0].value, states[1].value, false);
                }
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.callback != null) {
                    this.callback.onStopTrackingTouch(this, this.currTouchSB == this.leftSB);
                }
                this.changeThumbActivateState(false);
            }
        }
        return super.onTouchEvent(event);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.minValue = this.minProgress;
        ss.maxValue = this.maxProgress;
        ss.rangeInterval = this.minInterval;
        SeekBarState[] results = this.getRangeSeekBarState();
        ss.currSelectedMin = results[0].value;
        ss.currSelectedMax = results[1].value;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        try {
            SavedState ss = (SavedState)state;
            super.onRestoreInstanceState(ss.getSuperState());
            float min = ss.minValue;
            float max = ss.maxValue;
            float rangeInterval = ss.rangeInterval;
            this.setRange(min, max, rangeInterval);
            float currSelectedMin = ss.currSelectedMin;
            float currSelectedMax = ss.currSelectedMax;
            this.setProgress(currSelectedMin, currSelectedMax);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnRangeChangedListener(OnRangeChangedListener listener) {
        this.callback = listener;
    }

    public void setProgress(float value) {
        this.setProgress(value, this.maxProgress);
    }

    public void setProgress(float leftValue, float rightValue) {
        if ((rightValue = Math.max(leftValue = Math.min(leftValue, rightValue), rightValue)) - leftValue < this.minInterval) {
            leftValue = rightValue - this.minInterval;
        }
        if (leftValue < this.minProgress) {
            throw new IllegalArgumentException("setProgress() min < (preset min - offsetValue) . #min:" + leftValue + " #preset min:" + rightValue);
        }
        if (rightValue > this.maxProgress) {
            throw new IllegalArgumentException("setProgress() max > (preset max - offsetValue) . #max:" + rightValue + " #preset max:" + rightValue);
        }
        float range = this.maxProgress - this.minProgress;
        this.leftSB.currPercent = Math.abs(leftValue - this.minProgress) / range;
        if (this.seekBarMode == 2) {
            this.rightSB.currPercent = Math.abs(rightValue - this.minProgress) / range;
        }
        if (this.callback != null) {
            this.callback.onRangeChanged(this, leftValue, rightValue, false);
        }
        this.invalidate();
    }

    public void setRange(float min, float max) {
        this.setRange(min, max, this.minInterval);
    }

    public void setRange(float min, float max, float minInterval) {
        if (max <= min) {
            throw new IllegalArgumentException("setRange() max must be greater than min ! #max:" + max + " #min:" + min);
        }
        if (minInterval < 0.0f) {
            throw new IllegalArgumentException("setRange() interval must be greater than zero ! #minInterval:" + minInterval);
        }
        if (minInterval >= max - min) {
            throw new IllegalArgumentException("setRange() interval must be less than (max - min) ! #minInterval:" + minInterval + " #max - min:" + (max - min));
        }
        this.maxProgress = max;
        this.minProgress = min;
        this.minInterval = minInterval;
        this.reservePercent = minInterval / (max - min);
        if (this.seekBarMode == 2) {
            if (this.leftSB.currPercent + this.reservePercent <= 1.0f && this.leftSB.currPercent + this.reservePercent > this.rightSB.currPercent) {
                this.rightSB.currPercent = this.leftSB.currPercent + this.reservePercent;
            } else if (this.rightSB.currPercent - this.reservePercent >= 0.0f && this.rightSB.currPercent - this.reservePercent < this.leftSB.currPercent) {
                this.leftSB.currPercent = this.rightSB.currPercent - this.reservePercent;
            }
        }
        this.invalidate();
    }

    public SeekBarState[] getRangeSeekBarState() {
        SeekBarState leftSeekBarState = new SeekBarState();
        leftSeekBarState.value = this.leftSB.getProgress();
        leftSeekBarState.indicatorText = String.valueOf(leftSeekBarState.value);
        if (Utils.compareFloat(leftSeekBarState.value, this.minProgress) == 0) {
            leftSeekBarState.isMin = true;
        } else if (Utils.compareFloat(leftSeekBarState.value, this.maxProgress) == 0) {
            leftSeekBarState.isMax = true;
        }
        SeekBarState rightSeekBarState = new SeekBarState();
        if (this.seekBarMode == 2) {
            rightSeekBarState.value = this.rightSB.getProgress();
            rightSeekBarState.indicatorText = String.valueOf(rightSeekBarState.value);
            if (Utils.compareFloat(this.rightSB.currPercent, this.minProgress) == 0) {
                rightSeekBarState.isMin = true;
            } else if (Utils.compareFloat(this.rightSB.currPercent, this.maxProgress) == 0) {
                rightSeekBarState.isMax = true;
            }
        }
        return new SeekBarState[]{leftSeekBarState, rightSeekBarState};
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.isEnable = enabled;
    }

    public void setIndicatorText(String progress) {
        this.leftSB.setIndicatorText(progress);
        if (this.seekBarMode == 2) {
            this.rightSB.setIndicatorText(progress);
        }
    }

    public void setIndicatorTextDecimalFormat(String formatPattern) {
        this.leftSB.setIndicatorTextDecimalFormat(formatPattern);
        if (this.seekBarMode == 2) {
            this.rightSB.setIndicatorTextDecimalFormat(formatPattern);
        }
    }

    public void setIndicatorTextStringFormat(String formatPattern) {
        this.leftSB.setIndicatorTextStringFormat(formatPattern);
        if (this.seekBarMode == 2) {
            this.rightSB.setIndicatorTextStringFormat(formatPattern);
        }
    }

    public SeekBar getLeftSeekBar() {
        return this.leftSB;
    }

    public SeekBar getRightSeekBar() {
        return this.rightSB;
    }

    public int getProgressTop() {
        return this.progressTop;
    }

    public int getProgressBottom() {
        return this.progressBottom;
    }

    public int getProgressLeft() {
        return this.progressLeft;
    }

    public int getProgressRight() {
        return this.progressRight;
    }

    public int getProgressPaddingRight() {
        return this.progressPaddingRight;
    }

    public int getProgressHeight() {
        return this.progressHeight;
    }

    public void setProgressHeight(int progressHeight) {
        this.progressHeight = progressHeight;
    }

    public float getMinProgress() {
        return this.minProgress;
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setProgressColor(@ColorInt int progressDefaultColor, @ColorInt int progressColor) {
        this.progressDefaultColor = progressDefaultColor;
        this.progressColor = progressColor;
    }

    public int getTickMarkTextColor() {
        return this.tickMarkTextColor;
    }

    public void setTickMarkTextColor(@ColorInt int tickMarkTextColor) {
        this.tickMarkTextColor = tickMarkTextColor;
    }

    public int getTickMarkInRangeTextColor() {
        return this.tickMarkInRangeTextColor;
    }

    public void setTickMarkInRangeTextColor(@ColorInt int tickMarkInRangeTextColor) {
        this.tickMarkInRangeTextColor = tickMarkInRangeTextColor;
    }

    public int getSeekBarMode() {
        return this.seekBarMode;
    }

    public void setSeekBarMode(int seekBarMode) {
        this.seekBarMode = seekBarMode;
        this.rightSB.setVisible(seekBarMode != 1);
    }

    public int getTickMarkMode() {
        return this.tickMarkMode;
    }

    public void setTickMarkMode(int tickMarkMode) {
        this.tickMarkMode = tickMarkMode;
    }

    public int getTickMarkTextMargin() {
        return this.tickMarkTextMargin;
    }

    public void setTickMarkTextMargin(int tickMarkTextMargin) {
        this.tickMarkTextMargin = tickMarkTextMargin;
    }

    public int getTickMarkTextSize() {
        return this.tickMarkTextSize;
    }

    public void setTickMarkTextSize(int tickMarkTextSize) {
        this.tickMarkTextSize = tickMarkTextSize;
    }

    public int getTickMarkGravity() {
        return this.tickMarkGravity;
    }

    public void setTickMarkGravity(int tickMarkGravity) {
        this.tickMarkGravity = tickMarkGravity;
    }

    public CharSequence[] getTickMarkTextArray() {
        return this.tickMarkTextArray;
    }

    public void setTickMarkTextArray(CharSequence[] tickMarkTextArray) {
        this.tickMarkTextArray = tickMarkTextArray;
    }

    public float getMinInterval() {
        return this.minInterval;
    }

    public float getProgressRadius() {
        return this.progressRadius;
    }

    public void setProgressRadius(float progressRadius) {
        this.progressRadius = progressRadius;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(@ColorInt int progressColor) {
        this.progressColor = progressColor;
    }

    public int getProgressDefaultColor() {
        return this.progressDefaultColor;
    }

    public void setProgressDefaultColor(@ColorInt int progressDefaultColor) {
        this.progressDefaultColor = progressDefaultColor;
    }

    public int getProgressDrawableId() {
        return this.progressDrawableId;
    }

    public void setProgressDrawableId(@DrawableRes int progressDrawableId) {
        this.progressDrawableId = progressDrawableId;
        this.progressBitmap = null;
        this.initProgressBitmap();
    }

    public int getProgressDefaultDrawableId() {
        return this.progressDefaultDrawableId;
    }

    public void setProgressDefaultDrawableId(@DrawableRes int progressDefaultDrawableId) {
        this.progressDefaultDrawableId = progressDefaultDrawableId;
        this.progressDefaultBitmap = null;
        this.initProgressBitmap();
    }

    public int getProgressWidth() {
        return this.progressWidth;
    }

    public void setProgressWidth(int progressWidth) {
        this.progressWidth = progressWidth;
    }

    public void setTypeface(Typeface typeFace) {
        this.paint.setTypeface(typeFace);
    }

    public boolean isEnableThumbOverlap() {
        return this.enableThumbOverlap;
    }

    public void setEnableThumbOverlap(boolean enableThumbOverlap) {
        this.enableThumbOverlap = enableThumbOverlap;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getStepsColor() {
        return this.stepsColor;
    }

    public void setStepsColor(@ColorInt int stepsColor) {
        this.stepsColor = stepsColor;
    }

    public float getStepsWidth() {
        return this.stepsWidth;
    }

    public void setStepsWidth(float stepsWidth) {
        this.stepsWidth = stepsWidth;
    }

    public float getStepsHeight() {
        return this.stepsHeight;
    }

    public void setStepsHeight(float stepsHeight) {
        this.stepsHeight = stepsHeight;
    }

    public float getStepsRadius() {
        return this.stepsRadius;
    }

    public void setStepsRadius(float stepsRadius) {
        this.stepsRadius = stepsRadius;
    }

    public void setProgressTop(int progressTop) {
        this.progressTop = progressTop;
    }

    public void setProgressBottom(int progressBottom) {
        this.progressBottom = progressBottom;
    }

    public void setProgressLeft(int progressLeft) {
        this.progressLeft = progressLeft;
    }

    public void setProgressRight(int progressRight) {
        this.progressRight = progressRight;
    }

    public int getTickMarkLayoutGravity() {
        return this.tickMarkLayoutGravity;
    }

    public void setTickMarkLayoutGravity(int tickMarkLayoutGravity) {
        this.tickMarkLayoutGravity = tickMarkLayoutGravity;
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public boolean isStepsAutoBonding() {
        return this.stepsAutoBonding;
    }

    public void setStepsAutoBonding(boolean stepsAutoBonding) {
        this.stepsAutoBonding = stepsAutoBonding;
    }

    public int getStepsDrawableId() {
        return this.stepsDrawableId;
    }

    public void setStepsDrawableId(@DrawableRes int stepsDrawableId) {
        this.stepsBitmaps.clear();
        this.stepsDrawableId = stepsDrawableId;
        this.initStepsBitmap();
    }

    public List<Bitmap> getStepsBitmaps() {
        return this.stepsBitmaps;
    }

    public void setStepsBitmaps(List<Bitmap> stepsBitmaps) {
        if (stepsBitmaps == null || stepsBitmaps.isEmpty() || stepsBitmaps.size() <= this.steps) {
            throw new IllegalArgumentException("stepsBitmaps must > steps !");
        }
        this.stepsBitmaps.clear();
        this.stepsBitmaps.addAll(stepsBitmaps);
    }

    public void setStepsDrawable(List<Integer> stepsDrawableIds) {
        if (stepsDrawableIds == null || stepsDrawableIds.isEmpty() || stepsDrawableIds.size() <= this.steps) {
            throw new IllegalArgumentException("stepsDrawableIds must > steps !");
        }
        if (!this.verifyStepsMode()) {
            throw new IllegalArgumentException("stepsWidth must > 0, stepsHeight must > 0,steps must > 0 First!!");
        }
        ArrayList<Bitmap> stepsBitmaps = new ArrayList<Bitmap>();
        for (int i = 0; i < stepsDrawableIds.size(); ++i) {
            stepsBitmaps.add(Utils.drawableToBitmap(this.getContext(), (int)this.stepsWidth, (int)this.stepsHeight, stepsDrawableIds.get(i)));
        }
        this.setStepsBitmaps(stepsBitmaps);
    }

    public static class Gravity {
        public static final int TOP = 0;
        public static final int BOTTOM = 1;
        public static final int CENTER = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityDef {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TickMarkLayoutGravityDef {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TickMarkGravityDef {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TickMarkModeDef {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeekBarModeDef {
    }
}

