/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.widget.TextView;
import com.noober.background.R;
import com.noober.background.drawable.ITextViewOperator;

public class TextViewGradientColor
implements ITextViewOperator {
    private int endColor = -1;
    private int startColor = -1;
    private int orientation = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Context context, AttributeSet attrs, final TextView textView) {
        TypedArray textTa = context.obtainStyledAttributes(attrs, R.styleable.bl_text);
        try {
            if (textTa.getIndexCount() == 0) {
                return;
            }
            for (int i = 0; i < textTa.getIndexCount(); ++i) {
                int attr2 = textTa.getIndex(i);
                if (attr2 == R.styleable.bl_text_bl_text_gradient_endColor) {
                    this.endColor = textTa.getColor(attr2, -1);
                    continue;
                }
                if (attr2 == R.styleable.bl_text_bl_text_gradient_startColor) {
                    this.startColor = textTa.getColor(attr2, -1);
                    continue;
                }
                if (attr2 != R.styleable.bl_text_bl_text_gradient_orientation) continue;
                this.orientation = textTa.getInt(attr2, 0);
            }
            if (this.endColor == -1 && this.startColor != -1) {
                textView.setTextColor(this.startColor);
            } else if (this.startColor == -1 && this.endColor != -1) {
                textView.setTextColor(this.endColor);
            } else if (this.endColor != -1 && this.startColor != -1) {
                if (this.orientation == 0) {
                    textView.post(new Runnable(){

                        @Override
                        public void run() {
                            textView.getPaint().setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, textView.getPaint().descent() - textView.getPaint().ascent(), TextViewGradientColor.this.startColor, TextViewGradientColor.this.endColor, Shader.TileMode.REPEAT));
                            textView.invalidate();
                        }
                    });
                } else {
                    textView.post(new Runnable(){

                        @Override
                        public void run() {
                            textView.getPaint().setShader((Shader)new LinearGradient(0.0f, 0.0f, (float)textView.getMeasuredWidth(), 0.0f, TextViewGradientColor.this.startColor, TextViewGradientColor.this.endColor, Shader.TileMode.REPEAT));
                            textView.invalidate();
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            textTa.recycle();
        }
    }
}

