/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import com.noober.background.R;
import com.noober.background.common.MultiSelector;
import com.noober.background.common.ResourceUtils;
import com.noober.background.drawable.ICreateColorState;

public class MultiTextColorSelectorColorCreator
implements ICreateColorState {
    private TypedArray selectorTa;
    private Context context;
    private int[][] states = new int[0][];
    private int[] colors = new int[0];
    private int index;

    public MultiTextColorSelectorColorCreator(Context context, TypedArray selectorTa) {
        this.selectorTa = selectorTa;
        this.context = context;
    }

    @Override
    public ColorStateList create() {
        this.states = new int[this.selectorTa.getIndexCount()][];
        this.colors = new int[this.selectorTa.getIndexCount()];
        for (int i = 0; i < this.selectorTa.getIndexCount(); ++i) {
            int attr2 = this.selectorTa.getIndex(i);
            if (attr2 == R.styleable.background_multi_selector_text_bl_multi_text_selector1) {
                this.addState(attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_text_bl_multi_text_selector2) {
                this.addState(attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_text_bl_multi_text_selector3) {
                this.addState(attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_text_bl_multi_text_selector4) {
                this.addState(attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_text_bl_multi_text_selector5) {
                this.addState(attr2);
                continue;
            }
            if (attr2 != R.styleable.background_multi_selector_text_bl_multi_text_selector6) continue;
            this.addState(attr2);
        }
        return new ColorStateList(this.states, this.colors);
    }

    private void addState(int attr2) {
        String value = this.selectorTa.getString(attr2);
        if (value != null) {
            String[] vArray = value.split(",");
            if (vArray.length < 2) {
                throw new IllegalArgumentException("Attributes and drawable must be set at the same time");
            }
            int color = 0;
            int[] attrId = new int[vArray.length - 1];
            for (int p = 0; p < vArray.length; ++p) {
                String attrStr = vArray[p];
                if (p == vArray.length - 1) {
                    color = ResourceUtils.getColor(this.context, attrStr);
                    if (color != -1) continue;
                    throw new IllegalArgumentException("cannot find color from the last attribute");
                }
                MultiSelector multiSelector = MultiSelector.getMultiAttr(attrStr.replace("-", ""));
                if (multiSelector == null) {
                    throw new IllegalArgumentException("the attribute of bl_multi_selector only support state_checkable, state_checked, state_enabled, state_selected, state_pressed, state_focused, state_hovered, state_activated");
                }
                attrId[p] = attrStr.contains("-") ? -multiSelector.id : multiSelector.id;
            }
            this.states[this.index] = attrId;
            this.colors[this.index] = color;
            ++this.index;
        }
    }
}

