/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import androidx.annotation.AttrRes;
import com.noober.background.R;
import com.noober.background.drawable.ICreateDrawable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawableCreator
implements ICreateDrawable {
    private TypedArray typedArray;
    private int gradientState = -1;

    GradientDrawableCreator(TypedArray typedArray) {
        this.typedArray = typedArray;
    }

    GradientDrawableCreator(TypedArray typedArray, @AttrRes int gradientState) {
        this.typedArray = typedArray;
        this.gradientState = gradientState;
    }

    public GradientDrawable create() throws XmlPullParserException {
        Object color;
        ArrayList<Integer> colorList;
        int start;
        GradientDrawable drawable = new GradientDrawable();
        float[] cornerRadius = new float[8];
        float sizeWidth = 0.0f;
        float sizeHeight = 0.0f;
        float strokeWidth = -1.0f;
        float strokeDashWidth = 0.0f;
        int strokeColor = 0;
        int solidColor = 0;
        float strokeGap = 0.0f;
        float centerX = 0.0f;
        float centerY = 0.0f;
        int centerColor = 0;
        int startColor = 0;
        int endColor = 0;
        int gradientType = 0;
        int gradientAngle = 0;
        Rect padding = new Rect();
        for (int i = 0; i < this.typedArray.getIndexCount(); ++i) {
            int attr2 = this.typedArray.getIndex(i);
            if (attr2 == R.styleable.background_bl_shape) {
                drawable.setShape(this.typedArray.getInt(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.background_bl_solid_color) {
                solidColor = this.typedArray.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_radius) {
                drawable.setCornerRadius(this.typedArray.getDimension(attr2, 0.0f));
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_bottomLeftRadius) {
                cornerRadius[6] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[7] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_bottomRightRadius) {
                cornerRadius[4] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[5] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_topLeftRadius) {
                cornerRadius[0] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[1] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_topRightRadius) {
                cornerRadius[2] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[3] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_leftRadius) {
                cornerRadius[0] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[1] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[6] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[7] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_topRadius) {
                cornerRadius[0] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[1] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[2] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[3] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_rightRadius) {
                cornerRadius[2] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[3] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[4] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[5] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_corners_bottomRadius) {
                cornerRadius[4] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[5] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[6] = this.typedArray.getDimension(attr2, 0.0f);
                cornerRadius[7] = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_angle || attr2 == R.styleable.background_bl_checkable_gradient_angle || attr2 == R.styleable.background_bl_unCheckable_gradient_angle || attr2 == R.styleable.background_bl_checked_gradient_angle || attr2 == R.styleable.background_bl_unChecked_gradient_angle || attr2 == R.styleable.background_bl_enabled_gradient_angle || attr2 == R.styleable.background_bl_unEnabled_gradient_angle || attr2 == R.styleable.background_bl_selected_gradient_angle || attr2 == R.styleable.background_bl_unSelected_gradient_angle || attr2 == R.styleable.background_bl_pressed_gradient_angle || attr2 == R.styleable.background_bl_unPressed_gradient_angle || attr2 == R.styleable.background_bl_focused_gradient_angle || attr2 == R.styleable.background_bl_unFocused_gradient_angle) {
                if (this.gradientState == -1) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_angle) {
                    gradientAngle = this.typedArray.getInteger(attr2, 0);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_angle) continue;
                gradientAngle = this.typedArray.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_centerX || attr2 == R.styleable.background_bl_checkable_gradient_centerX || attr2 == R.styleable.background_bl_unCheckable_gradient_centerX || attr2 == R.styleable.background_bl_checked_gradient_centerX || attr2 == R.styleable.background_bl_unChecked_gradient_centerX || attr2 == R.styleable.background_bl_enabled_gradient_centerX || attr2 == R.styleable.background_bl_unEnabled_gradient_centerX || attr2 == R.styleable.background_bl_selected_gradient_centerX || attr2 == R.styleable.background_bl_unSelected_gradient_centerX || attr2 == R.styleable.background_bl_pressed_gradient_centerX || attr2 == R.styleable.background_bl_unPressed_gradient_centerX || attr2 == R.styleable.background_bl_focused_gradient_centerX || attr2 == R.styleable.background_bl_unFocused_gradient_centerX) {
                if (this.gradientState == -1) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_centerX) {
                    centerX = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_centerX) continue;
                centerX = this.typedArray.getFloat(attr2, -1.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_centerY || attr2 == R.styleable.background_bl_checkable_gradient_centerY || attr2 == R.styleable.background_bl_unCheckable_gradient_centerY || attr2 == R.styleable.background_bl_checked_gradient_centerY || attr2 == R.styleable.background_bl_unChecked_gradient_centerY || attr2 == R.styleable.background_bl_enabled_gradient_centerY || attr2 == R.styleable.background_bl_unEnabled_gradient_centerY || attr2 == R.styleable.background_bl_selected_gradient_centerY || attr2 == R.styleable.background_bl_unSelected_gradient_centerY || attr2 == R.styleable.background_bl_pressed_gradient_centerY || attr2 == R.styleable.background_bl_unPressed_gradient_centerY || attr2 == R.styleable.background_bl_focused_gradient_centerY || attr2 == R.styleable.background_bl_unFocused_gradient_centerY) {
                if (this.gradientState == -1) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_centerY) {
                    centerY = this.typedArray.getFloat(attr2, -1.0f);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_centerY) continue;
                centerY = this.typedArray.getFloat(attr2, -1.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_centerColor || attr2 == R.styleable.background_bl_checkable_gradient_centerColor || attr2 == R.styleable.background_bl_unCheckable_gradient_centerColor || attr2 == R.styleable.background_bl_checked_gradient_centerColor || attr2 == R.styleable.background_bl_unChecked_gradient_centerColor || attr2 == R.styleable.background_bl_enabled_gradient_centerColor || attr2 == R.styleable.background_bl_unEnabled_gradient_centerColor || attr2 == R.styleable.background_bl_selected_gradient_centerColor || attr2 == R.styleable.background_bl_unSelected_gradient_centerColor || attr2 == R.styleable.background_bl_pressed_gradient_centerColor || attr2 == R.styleable.background_bl_unPressed_gradient_centerColor || attr2 == R.styleable.background_bl_focused_gradient_centerColor || attr2 == R.styleable.background_bl_unFocused_gradient_centerColor) {
                if (this.gradientState == -1) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_centerColor) {
                    centerColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_centerColor) continue;
                centerColor = this.typedArray.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_endColor || attr2 == R.styleable.background_bl_checkable_gradient_endColor || attr2 == R.styleable.background_bl_unCheckable_gradient_endColor || attr2 == R.styleable.background_bl_checked_gradient_endColor || attr2 == R.styleable.background_bl_unChecked_gradient_endColor || attr2 == R.styleable.background_bl_enabled_gradient_endColor || attr2 == R.styleable.background_bl_unEnabled_gradient_endColor || attr2 == R.styleable.background_bl_selected_gradient_endColor || attr2 == R.styleable.background_bl_unSelected_gradient_endColor || attr2 == R.styleable.background_bl_pressed_gradient_endColor || attr2 == R.styleable.background_bl_unPressed_gradient_endColor || attr2 == R.styleable.background_bl_focused_gradient_endColor || attr2 == R.styleable.background_bl_unFocused_gradient_endColor) {
                if (this.gradientState == -1) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_endColor) {
                    endColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_endColor) continue;
                endColor = this.typedArray.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_startColor || attr2 == R.styleable.background_bl_checkable_gradient_startColor || attr2 == R.styleable.background_bl_unCheckable_gradient_startColor || attr2 == R.styleable.background_bl_checked_gradient_startColor || attr2 == R.styleable.background_bl_unChecked_gradient_startColor || attr2 == R.styleable.background_bl_enabled_gradient_startColor || attr2 == R.styleable.background_bl_unEnabled_gradient_startColor || attr2 == R.styleable.background_bl_selected_gradient_startColor || attr2 == R.styleable.background_bl_unSelected_gradient_startColor || attr2 == R.styleable.background_bl_pressed_gradient_startColor || attr2 == R.styleable.background_bl_unPressed_gradient_startColor || attr2 == R.styleable.background_bl_focused_gradient_startColor || attr2 == R.styleable.background_bl_unFocused_gradient_startColor) {
                if (this.gradientState == -1) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_startColor) {
                    startColor = this.typedArray.getColor(attr2, 0);
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_startColor) continue;
                startColor = this.typedArray.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_gradientRadius || attr2 == R.styleable.background_bl_checkable_gradient_gradientRadius || attr2 == R.styleable.background_bl_unCheckable_gradient_gradientRadius || attr2 == R.styleable.background_bl_checked_gradient_gradientRadius || attr2 == R.styleable.background_bl_unChecked_gradient_gradientRadius || attr2 == R.styleable.background_bl_enabled_gradient_gradientRadius || attr2 == R.styleable.background_bl_unEnabled_gradient_gradientRadius || attr2 == R.styleable.background_bl_selected_gradient_gradientRadius || attr2 == R.styleable.background_bl_unSelected_gradient_gradientRadius || attr2 == R.styleable.background_bl_pressed_gradient_gradientRadius || attr2 == R.styleable.background_bl_unPressed_gradient_gradientRadius || attr2 == R.styleable.background_bl_focused_gradient_gradientRadius || attr2 == R.styleable.background_bl_unFocused_gradient_gradientRadius) {
                if (this.gradientState == -1) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_gradientRadius) {
                    drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_gradientRadius) continue;
                drawable.setGradientRadius(this.typedArray.getDimension(attr2, 0.0f));
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_type || attr2 == R.styleable.background_bl_checkable_gradient_type || attr2 == R.styleable.background_bl_unCheckable_gradient_type || attr2 == R.styleable.background_bl_checked_gradient_type || attr2 == R.styleable.background_bl_unChecked_gradient_type || attr2 == R.styleable.background_bl_enabled_gradient_type || attr2 == R.styleable.background_bl_unEnabled_gradient_type || attr2 == R.styleable.background_bl_selected_gradient_type || attr2 == R.styleable.background_bl_unSelected_gradient_type || attr2 == R.styleable.background_bl_pressed_gradient_type || attr2 == R.styleable.background_bl_unPressed_gradient_type || attr2 == R.styleable.background_bl_focused_gradient_type || attr2 == R.styleable.background_bl_unFocused_gradient_type) {
                if (this.gradientState == -1) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                } else if (this.gradientState == -16842908 && attr2 == R.styleable.background_bl_unFocused_gradient_type) {
                    gradientType = this.typedArray.getInt(attr2, 0);
                }
                drawable.setGradientType(gradientType);
                continue;
            }
            if (attr2 == R.styleable.background_bl_gradient_useLevel || attr2 == R.styleable.background_bl_checkable_gradient_useLevel || attr2 == R.styleable.background_bl_unCheckable_gradient_useLevel || attr2 == R.styleable.background_bl_checked_gradient_useLevel || attr2 == R.styleable.background_bl_unChecked_gradient_useLevel || attr2 == R.styleable.background_bl_enabled_gradient_useLevel || attr2 == R.styleable.background_bl_unEnabled_gradient_useLevel || attr2 == R.styleable.background_bl_selected_gradient_useLevel || attr2 == R.styleable.background_bl_unSelected_gradient_useLevel || attr2 == R.styleable.background_bl_pressed_gradient_useLevel || attr2 == R.styleable.background_bl_unPressed_gradient_useLevel || attr2 == R.styleable.background_bl_focused_gradient_useLevel || attr2 == R.styleable.background_bl_unFocused_gradient_useLevel) {
                if (this.gradientState == -1) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 16842911 && attr2 == R.styleable.background_bl_checkable_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == -16842911 && attr2 == R.styleable.background_bl_unCheckable_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 0x10100A0 && attr2 == R.styleable.background_bl_checked_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == -16842912 && attr2 == R.styleable.background_bl_unChecked_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 16842910 && attr2 == R.styleable.background_bl_enabled_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == -16842910 && attr2 == R.styleable.background_bl_unEnabled_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 0x10100A1 && attr2 == R.styleable.background_bl_selected_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == -16842913 && attr2 == R.styleable.background_bl_unSelected_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 16842919 && attr2 == R.styleable.background_bl_pressed_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == -16842919 && attr2 == R.styleable.background_bl_unPressed_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState == 16842908 && attr2 == R.styleable.background_bl_focused_gradient_useLevel) {
                    drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                    continue;
                }
                if (this.gradientState != -16842908 || attr2 != R.styleable.background_bl_unFocused_gradient_useLevel) continue;
                drawable.setUseLevel(this.typedArray.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.background_bl_padding_left) {
                padding.left = (int)this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_padding_top) {
                padding.top = (int)this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_padding_right) {
                padding.right = (int)this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_padding_bottom) {
                padding.bottom = (int)this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_size_width) {
                sizeWidth = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_size_height) {
                sizeHeight = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_stroke_width) {
                strokeWidth = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 == R.styleable.background_bl_stroke_color) {
                strokeColor = this.typedArray.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.background_bl_stroke_dashWidth) {
                strokeDashWidth = this.typedArray.getDimension(attr2, 0.0f);
                continue;
            }
            if (attr2 != R.styleable.background_bl_stroke_dashGap) continue;
            strokeGap = this.typedArray.getDimension(attr2, 0.0f);
        }
        if (this.hasSetRadius(cornerRadius)) {
            drawable.setCornerRadii(cornerRadius);
        }
        if (this.typedArray.hasValue(R.styleable.background_bl_size_width) && this.typedArray.hasValue(R.styleable.background_bl_size_height)) {
            drawable.setSize((int)sizeWidth, (int)sizeHeight);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            start = 0;
            ArrayList<Integer> stateList = new ArrayList<Integer>();
            colorList = new ArrayList<Integer>();
            if (this.typedArray.hasValue(R.styleable.background_bl_pressed_solid_color)) {
                stateList.add(16842919);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_pressed_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unPressed_solid_color)) {
                stateList.add(-16842919);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unPressed_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_checkable_solid_color)) {
                stateList.add(16842911);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_checkable_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unCheckable_solid_color)) {
                stateList.add(-16842911);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unCheckable_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_checked_solid_color)) {
                stateList.add(0x10100A0);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_checked_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unChecked_solid_color)) {
                stateList.add(-16842912);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unChecked_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_enabled_solid_color)) {
                stateList.add(16842910);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_enabled_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unEnabled_solid_color)) {
                stateList.add(-16842910);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unEnabled_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_selected_solid_color)) {
                stateList.add(0x10100A1);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_selected_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unSelected_solid_color)) {
                stateList.add(-16842913);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unSelected_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_focused_solid_color)) {
                stateList.add(16842908);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_focused_solid_color, 0));
            }
            if (this.typedArray.hasValue(R.styleable.background_bl_unFocused_solid_color)) {
                stateList.add(-16842908);
                colorList.add(this.typedArray.getColor(R.styleable.background_bl_unFocused_solid_color, 0));
            }
            if (stateList.size() > 0) {
                int size = stateList.size();
                if (this.typedArray.hasValue(R.styleable.background_bl_solid_color)) {
                    ++size;
                }
                int[][] state = new int[size][];
                color = new int[size];
                Iterator iterator = stateList.iterator();
                while (iterator.hasNext()) {
                    int iState = (Integer)iterator.next();
                    state[start] = new int[]{iState};
                    color[start] = (Integer)colorList.get(start);
                    ++start;
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_solid_color)) {
                    state[start] = new int[0];
                    color[start] = solidColor;
                }
                ColorStateList colorStateList = new ColorStateList((int[][])state, (int[])color);
                drawable.setColor(colorStateList);
            } else if (this.typedArray.hasValue(R.styleable.background_bl_solid_color)) {
                drawable.setColor(solidColor);
            }
            stateList = null;
            colorList = null;
        } else if (this.typedArray.hasValue(R.styleable.background_bl_solid_color)) {
            drawable.setColor(solidColor);
        }
        if (this.typedArray.hasValue(R.styleable.background_bl_stroke_width)) {
            if (Build.VERSION.SDK_INT >= 21) {
                start = 0;
                ArrayList<Integer> stateList = new ArrayList<Integer>();
                colorList = new ArrayList();
                if (this.typedArray.hasValue(R.styleable.background_bl_pressed_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unPressed_stroke_color)) {
                    stateList.add(16842919);
                    stateList.add(-16842919);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_pressed_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unPressed_stroke_color, 0));
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_checkable_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unCheckable_stroke_color)) {
                    stateList.add(16842911);
                    stateList.add(-16842911);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_checkable_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unCheckable_stroke_color, 0));
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_checked_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unChecked_stroke_color)) {
                    stateList.add(0x10100A0);
                    stateList.add(-16842912);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_checked_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unChecked_stroke_color, 0));
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_enabled_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unEnabled_stroke_color)) {
                    stateList.add(16842910);
                    stateList.add(-16842910);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_enabled_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unEnabled_stroke_color, 0));
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_selected_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unSelected_stroke_color)) {
                    stateList.add(0x10100A1);
                    stateList.add(-16842913);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_selected_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unSelected_stroke_color, 0));
                }
                if (this.typedArray.hasValue(R.styleable.background_bl_focused_stroke_color) && this.typedArray.hasValue(R.styleable.background_bl_unFocused_stroke_color)) {
                    stateList.add(16842908);
                    stateList.add(-16842908);
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_focused_stroke_color, 0));
                    colorList.add(this.typedArray.getColor(R.styleable.background_bl_unFocused_stroke_color, 0));
                }
                if (stateList.size() > 0) {
                    int[][] state = new int[stateList.size()][];
                    int[] color2 = new int[stateList.size()];
                    color = stateList.iterator();
                    while (color.hasNext()) {
                        int iState = (Integer)color.next();
                        state[start] = new int[]{iState};
                        color2[start] = (Integer)colorList.get(start);
                        ++start;
                    }
                    ColorStateList colorStateList = new ColorStateList((int[][])state, color2);
                    drawable.setStroke((int)strokeWidth, colorStateList, strokeDashWidth, strokeGap);
                } else if (this.typedArray.hasValue(R.styleable.background_bl_stroke_color)) {
                    drawable.setStroke((int)strokeWidth, strokeColor, strokeDashWidth, strokeGap);
                }
                stateList = null;
                colorList = null;
            } else if (this.typedArray.hasValue(R.styleable.background_bl_stroke_color)) {
                drawable.setStroke((int)strokeWidth, strokeColor, strokeDashWidth, strokeGap);
            }
        }
        if (this.typedArray.hasValue(R.styleable.background_bl_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_checkable_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unCheckable_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_checked_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unChecked_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_enabled_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unEnabled_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_selected_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unSelected_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_pressed_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unPressed_gradient_centerY) || this.typedArray.hasValue(R.styleable.background_bl_focused_gradient_centerX) && this.typedArray.hasValue(R.styleable.background_bl_unFocused_gradient_centerY)) {
            drawable.setGradientCenter(centerX, centerY);
        }
        if (this.typedArray.hasValue(R.styleable.background_bl_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_checkable_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unCheckable_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_checked_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unChecked_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_enabled_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unEnabled_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_selected_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unSelected_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_pressed_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unPressed_gradient_endColor) || this.typedArray.hasValue(R.styleable.background_bl_focused_gradient_startColor) && this.typedArray.hasValue(R.styleable.background_bl_unFocused_gradient_endColor) && Build.VERSION.SDK_INT >= 16) {
            int[] colors = this.typedArray.hasValue(R.styleable.background_bl_gradient_centerColor) ? new int[]{startColor, centerColor, endColor} : new int[]{startColor, endColor};
            drawable.setColors(colors);
        }
        if (gradientType == 0 && Build.VERSION.SDK_INT >= 16 && (this.typedArray.hasValue(R.styleable.background_bl_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_checkable_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_checked_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_enabled_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_selected_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_pressed_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_focused_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unCheckable_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unChecked_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unEnabled_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unSelected_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unPressed_gradient_angle) || this.typedArray.hasValue(R.styleable.background_bl_unFocused_gradient_angle))) {
            if ((gradientAngle %= 360) % 45 != 0) {
                throw new XmlPullParserException(this.typedArray.getPositionDescription() + "<gradient> tag requires 'angle' attribute to be a multiple of 45");
            }
            GradientDrawable.Orientation mOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
            switch (gradientAngle) {
                case 0: {
                    mOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
                    break;
                }
                case 45: {
                    mOrientation = GradientDrawable.Orientation.BL_TR;
                    break;
                }
                case 90: {
                    mOrientation = GradientDrawable.Orientation.BOTTOM_TOP;
                    break;
                }
                case 135: {
                    mOrientation = GradientDrawable.Orientation.BR_TL;
                    break;
                }
                case 180: {
                    mOrientation = GradientDrawable.Orientation.RIGHT_LEFT;
                    break;
                }
                case 225: {
                    mOrientation = GradientDrawable.Orientation.TR_BL;
                    break;
                }
                case 270: {
                    mOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
                    break;
                }
                case 315: {
                    mOrientation = GradientDrawable.Orientation.TL_BR;
                }
            }
            drawable.setOrientation(mOrientation);
        }
        if (this.typedArray.hasValue(R.styleable.background_bl_padding_left) && this.typedArray.hasValue(R.styleable.background_bl_padding_top) && this.typedArray.hasValue(R.styleable.background_bl_padding_right) && this.typedArray.hasValue(R.styleable.background_bl_padding_bottom)) {
            if (Build.VERSION.SDK_INT >= 29) {
                drawable.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            } else {
                try {
                    Field paddingField = drawable.getClass().getDeclaredField("mPadding");
                    paddingField.setAccessible(true);
                    paddingField.set(drawable, padding);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return drawable;
    }

    private boolean hasSetRadius(float[] radius) {
        boolean hasSet = false;
        for (float f : radius) {
            if (f == 0.0f) continue;
            hasSet = true;
            break;
        }
        return hasSet;
    }
}

