/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import androidx.annotation.AttrRes;
import com.noober.background.drawable.AnimationDrawableCreator;
import com.noober.background.drawable.ButtonDrawableCreator;
import com.noober.background.drawable.ColorStateCreator;
import com.noober.background.drawable.GradientDrawableCreator;
import com.noober.background.drawable.GradientStateDrawableCreator;
import com.noober.background.drawable.MultiSelectorDrawableCreator;
import com.noober.background.drawable.MultiTextColorSelectorColorCreator;
import com.noober.background.drawable.PressDrawableCreator;
import com.noober.background.drawable.SelectorDrawableCreator;
import com.noober.background.drawable.SelectorPre21DrawableCreator;
import org.xmlpull.v1.XmlPullParserException;

public class DrawableFactory {
    public static GradientDrawable getDrawable(TypedArray typedArray) throws XmlPullParserException {
        return new GradientDrawableCreator(typedArray).create();
    }

    public static GradientDrawable getDrawable(TypedArray typedArray, @AttrRes int gradientState) throws XmlPullParserException {
        return new GradientDrawableCreator(typedArray, gradientState).create();
    }

    public static StateListDrawable getStateGradientDrawable(TypedArray typedArray) throws Exception {
        return new GradientStateDrawableCreator(typedArray).create();
    }

    public static StateListDrawable getSelectorDrawable(TypedArray typedArray, TypedArray selectorTa) throws Exception {
        return (StateListDrawable)new SelectorDrawableCreator(typedArray, selectorTa).create();
    }

    public static StateListDrawable getSelectorPre21Drawable(TypedArray typedArray) throws Exception {
        return new SelectorPre21DrawableCreator(typedArray).create();
    }

    public static StateListDrawable getButtonDrawable(TypedArray typedArray, TypedArray buttonTa) throws Exception {
        return (StateListDrawable)new ButtonDrawableCreator(typedArray, buttonTa).create();
    }

    public static ColorStateList getTextSelectorColor(TypedArray textTa) {
        return new ColorStateCreator(textTa).create();
    }

    public static StateListDrawable getPressDrawable(GradientDrawable drawable, TypedArray typedArray, TypedArray pressTa) throws Exception {
        return (StateListDrawable)new PressDrawableCreator(drawable, typedArray, pressTa).create();
    }

    public static AnimationDrawable getAnimationDrawable(TypedArray animTa) throws Exception {
        return (AnimationDrawable)new AnimationDrawableCreator(animTa).create();
    }

    public static StateListDrawable getMultiSelectorDrawable(Context context, TypedArray selectorTa, TypedArray typedArray) {
        return (StateListDrawable)new MultiSelectorDrawableCreator(context, selectorTa, typedArray).create();
    }

    public static ColorStateList getMultiTextColorSelectorColorCreator(Context context, TypedArray selectorTa) {
        return new MultiTextColorSelectorColorCreator(context, selectorTa).create();
    }
}

