/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.noober.background.R;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.TextViewFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BackgroundFactory
implements LayoutInflater.Factory2 {
    private LayoutInflater.Factory mViewCreateFactory;
    private LayoutInflater.Factory2 mViewCreateFactory2;
    private static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final Object[] mConstructorArgs = new Object[2];
    private static final Map<String, Constructor<? extends View>> sConstructorMap = new ArrayMap();
    private static final HashMap<String, HashMap<String, Method>> methodMap = new HashMap();

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        if (name.startsWith("com.noober.background.view")) {
            return null;
        }
        View view = null;
        if (this.mViewCreateFactory2 != null) {
            view = this.mViewCreateFactory2.onCreateView(name, context, attrs);
            if (view == null) {
                view = this.mViewCreateFactory2.onCreateView(null, name, context, attrs);
            }
        } else if (this.mViewCreateFactory != null) {
            view = this.mViewCreateFactory.onCreateView(name, context, attrs);
        }
        return BackgroundFactory.setViewBackground(name, context, attrs, view);
    }

    @Nullable
    public static View setViewBackground(Context context, AttributeSet attrs, View view) {
        return BackgroundFactory.setViewBackground(null, context, attrs, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static View setViewBackground(String name, Context context, AttributeSet attrs, View view) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.background);
        TypedArray pressTa = context.obtainStyledAttributes(attrs, R.styleable.background_press);
        TypedArray selectorTa = context.obtainStyledAttributes(attrs, R.styleable.background_selector);
        TypedArray textTa = context.obtainStyledAttributes(attrs, R.styleable.text_selector);
        TypedArray buttonTa = context.obtainStyledAttributes(attrs, R.styleable.background_button_drawable);
        TypedArray otherTa = context.obtainStyledAttributes(attrs, R.styleable.bl_other);
        TypedArray animTa = context.obtainStyledAttributes(attrs, R.styleable.bl_anim);
        TypedArray multiSelTa = context.obtainStyledAttributes(attrs, R.styleable.background_multi_selector);
        TypedArray multiTextTa = context.obtainStyledAttributes(attrs, R.styleable.background_multi_selector_text);
        TypedArray textViewTa = context.obtainStyledAttributes(attrs, R.styleable.bl_text);
        TypedArray selectorPre21Ta = null;
        if (Build.VERSION.SDK_INT < 21) {
            selectorPre21Ta = context.obtainStyledAttributes(attrs, R.styleable.background_selector_pre_21);
        }
        try {
            Context currentContext;
            Class<?> parentClass;
            Method method;
            String methodName;
            if (typedArray.getIndexCount() == 0 && selectorTa.getIndexCount() == 0 && pressTa.getIndexCount() == 0 && textTa.getIndexCount() == 0 && buttonTa.getIndexCount() == 0 && animTa.getIndexCount() == 0 && multiSelTa.getIndexCount() == 0 && multiTextTa.getIndexCount() == 0 && textViewTa.getIndexCount() == 0) {
                View view2 = view;
                return view2;
            }
            if (view == null) {
                view = BackgroundFactory.createViewFromTag(context, name, attrs);
            }
            if (view == null) {
                View view3 = null;
                return view3;
            }
            if (selectorTa.getIndexCount() > 0 && multiSelTa.getIndexCount() > 0) {
                throw new IllegalArgumentException("Background_selector and background_multi_selector cannot be used simultaneously");
            }
            if (textTa.getIndexCount() > 0 && multiTextTa.getIndexCount() > 0) {
                throw new IllegalArgumentException("text_selector and background_multi_selector_text cannot be used simultaneously");
            }
            GradientDrawable drawable = null;
            StateListDrawable stateListDrawable = null;
            if (buttonTa.getIndexCount() > 0 && view instanceof CompoundButton) {
                ((CompoundButton)view).setButtonDrawable((Drawable)DrawableFactory.getButtonDrawable(typedArray, buttonTa));
            } else if (selectorTa.getIndexCount() > 0) {
                stateListDrawable = DrawableFactory.getSelectorDrawable(typedArray, selectorTa);
                BackgroundFactory.setDrawable((Drawable)stateListDrawable, view, otherTa, typedArray);
            } else if (pressTa.getIndexCount() > 0) {
                drawable = DrawableFactory.getDrawable(typedArray);
                stateListDrawable = DrawableFactory.getPressDrawable(drawable, typedArray, pressTa);
                BackgroundFactory.setDrawable((Drawable)stateListDrawable, view, otherTa, typedArray);
            } else if (multiSelTa.getIndexCount() > 0) {
                stateListDrawable = DrawableFactory.getMultiSelectorDrawable(context, multiSelTa, typedArray);
                BackgroundFactory.setBackground((Drawable)stateListDrawable, view, typedArray);
            } else if (typedArray.getIndexCount() > 0) {
                if (selectorPre21Ta != null && selectorPre21Ta.getIndexCount() > 0) {
                    stateListDrawable = DrawableFactory.getSelectorPre21Drawable(typedArray);
                    BackgroundFactory.setDrawable((Drawable)stateListDrawable, view, otherTa, typedArray);
                } else if (BackgroundFactory.hasGradientState(typedArray)) {
                    stateListDrawable = DrawableFactory.getStateGradientDrawable(typedArray);
                    BackgroundFactory.setDrawable((Drawable)stateListDrawable, view, otherTa, typedArray);
                } else {
                    drawable = DrawableFactory.getDrawable(typedArray);
                    BackgroundFactory.setDrawable((Drawable)drawable, view, otherTa, typedArray);
                }
            } else if (animTa.getIndexCount() > 0) {
                AnimationDrawable animationDrawable = DrawableFactory.getAnimationDrawable(animTa);
                BackgroundFactory.setBackground((Drawable)animationDrawable, view, typedArray);
                if (animTa.getBoolean(R.styleable.bl_anim_bl_anim_auto_start, false)) {
                    animationDrawable.start();
                }
            }
            if (view instanceof TextView && textTa.getIndexCount() > 0) {
                ((TextView)view).setTextColor(DrawableFactory.getTextSelectorColor(textTa));
            } else if (view instanceof TextView && multiTextTa.getIndexCount() > 0) {
                ((TextView)view).setTextColor(DrawableFactory.getMultiTextColorSelectorColorCreator(context, multiTextTa));
            } else if (view instanceof TextView && textViewTa.getIndexCount() > 0) {
                TextViewFactory.setTextGradientColor(context, attrs, (TextView)view);
            }
            if (typedArray.getBoolean(R.styleable.background_bl_ripple_enable, false) && typedArray.hasValue(R.styleable.background_bl_ripple_color)) {
                int color = typedArray.getColor(R.styleable.background_bl_ripple_color, 0);
                if (Build.VERSION.SDK_INT >= 21) {
                    GradientDrawable contentDrawable = stateListDrawable == null ? drawable : stateListDrawable;
                    RippleDrawable rippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)color), (Drawable)contentDrawable, (Drawable)contentDrawable);
                    BackgroundFactory.setBackground((Drawable)rippleDrawable, view, typedArray);
                } else if (stateListDrawable == null) {
                    StateListDrawable tmpDrawable = new StateListDrawable();
                    GradientDrawable unPressDrawable = DrawableFactory.getDrawable(typedArray);
                    unPressDrawable.setColor(color);
                    tmpDrawable.addState(new int[]{-16842919}, (Drawable)drawable);
                    tmpDrawable.addState(new int[]{16842919}, (Drawable)unPressDrawable);
                    BackgroundFactory.setDrawable((Drawable)tmpDrawable, view, otherTa, typedArray);
                }
            }
            if (otherTa.hasValue(R.styleable.bl_other_bl_function) && !TextUtils.isEmpty((CharSequence)(methodName = otherTa.getString(R.styleable.bl_other_bl_function))) && (method = BackgroundFactory.getMethod(parentClass = (currentContext = view.getContext()).getClass(), methodName)) != null) {
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        try {
                            method.invoke((Object)currentContext, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            View view4 = view;
            return view4;
        }
        catch (Exception e) {
            e.printStackTrace();
            View view5 = view;
            return view5;
        }
        finally {
            typedArray.recycle();
            pressTa.recycle();
            selectorTa.recycle();
            textTa.recycle();
            buttonTa.recycle();
            otherTa.recycle();
            animTa.recycle();
            multiSelTa.recycle();
            multiTextTa.recycle();
            textViewTa.recycle();
            if (selectorPre21Ta != null) {
                selectorPre21Ta.recycle();
            }
        }
    }

    private static Method getMethod(Class clazz, String methodName) {
        Method method = null;
        HashMap<String, Method> methodHashMap = methodMap.get(clazz.getCanonicalName());
        if (methodHashMap != null) {
            method = methodMap.get(clazz.getCanonicalName()).get(methodName);
        } else {
            methodHashMap = new HashMap();
            methodMap.put(clazz.getCanonicalName(), methodHashMap);
        }
        if (method == null && (method = BackgroundFactory.findMethod(clazz, methodName)) != null) {
            methodHashMap.put(methodName, method);
        }
        return method;
    }

    private static Method findMethod(Class clazz, String methodName) {
        Method method;
        try {
            method = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = BackgroundFactory.findDeclaredMethod(clazz, methodName);
        }
        return method;
    }

    private static Method findDeclaredMethod(Class clazz, String methodName) {
        Method method;
        block2: {
            method = null;
            try {
                method = clazz.getDeclaredMethod(methodName, new Class[0]);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                if (clazz.getSuperclass() == null) break block2;
                method = BackgroundFactory.findDeclaredMethod(clazz.getSuperclass(), methodName);
            }
        }
        return method;
    }

    private static void setDrawable(Drawable drawable, View view, TypedArray otherTa, TypedArray typedArray) {
        if (view instanceof TextView) {
            if (otherTa.hasValue(R.styleable.bl_other_bl_position)) {
                if (otherTa.getInt(R.styleable.bl_other_bl_position, 0) == 1) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(drawable, null, null, null);
                } else if (otherTa.getInt(R.styleable.bl_other_bl_position, 0) == 2) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, drawable, null, null);
                } else if (otherTa.getInt(R.styleable.bl_other_bl_position, 0) == 4) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, null, drawable, null);
                } else if (otherTa.getInt(R.styleable.bl_other_bl_position, 0) == 8) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, null, null, drawable);
                }
            } else {
                BackgroundFactory.setBackground(drawable, view, typedArray);
            }
        } else {
            BackgroundFactory.setBackground(drawable, view, typedArray);
        }
    }

    private static void setBackground(Drawable drawable, View view, TypedArray typedArray) {
        if (typedArray.hasValue(R.styleable.background_bl_stroke_width) && typedArray.hasValue(R.styleable.background_bl_stroke_position)) {
            int left = 2;
            int top = 4;
            int right = 8;
            int bottom = 16;
            float width = typedArray.getDimension(R.styleable.background_bl_stroke_width, 0.0f);
            int position = typedArray.getInt(R.styleable.background_bl_stroke_position, 0);
            float leftValue = BackgroundFactory.hasStatus(position, left) ? 0.0f : -width;
            float topValue = BackgroundFactory.hasStatus(position, top) ? 0.0f : -width;
            float rightValue = BackgroundFactory.hasStatus(position, right) ? 0.0f : -width;
            float bottomValue = BackgroundFactory.hasStatus(position, bottom) ? 0.0f : -width;
            drawable = new LayerDrawable(new Drawable[]{drawable});
            ((LayerDrawable)drawable).setLayerInset(0, (int)leftValue, (int)topValue, (int)rightValue, (int)bottomValue);
        }
        if (typedArray.hasValue(R.styleable.background_bl_shape_alpha)) {
            float alpha = typedArray.getFloat(R.styleable.background_bl_shape_alpha, 0.0f);
            alpha = alpha >= 1.0f ? 255.0f : (alpha <= 0.0f ? 0.0f : (alpha *= 255.0f));
            drawable.setAlpha((int)alpha);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    private static boolean hasStatus(int flag, int status) {
        return (flag & status) == status;
    }

    public void setInterceptFactory(LayoutInflater.Factory factory) {
        this.mViewCreateFactory = factory;
    }

    public void setInterceptFactory2(LayoutInflater.Factory2 factory) {
        this.mViewCreateFactory2 = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            BackgroundFactory.mConstructorArgs[0] = context;
            BackgroundFactory.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                View view = null;
                if ("View".equals(name)) {
                    view = BackgroundFactory.createView(context, name, "android.view.");
                }
                if (view == null) {
                    view = BackgroundFactory.createView(context, name, "android.widget.");
                }
                if (view == null) {
                    view = BackgroundFactory.createView(context, name, "android.webkit.");
                }
                View view2 = view;
                return view2;
            }
            View view = BackgroundFactory.createView(context, name, null);
            return view;
        }
        catch (Exception e) {
            Log.w((String)"BackgroundLibrary", (String)("cannot create \u3010" + name + "\u3011 : "));
            View view = null;
            return view;
        }
        finally {
            BackgroundFactory.mConstructorArgs[0] = null;
            BackgroundFactory.mConstructorArgs[1] = null;
        }
    }

    private static View createView(Context context, String name, String prefix) throws InflateException {
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<View> clazz = context.getClassLoader().loadClass(prefix != null ? prefix + name : name).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put(name, constructor);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(mConstructorArgs);
        }
        catch (Exception e) {
            Log.w((String)"BackgroundLibrary", (String)("cannot create \u3010" + name + "\u3011 : "));
            return null;
        }
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        return this.onCreateView(name, context, attrs);
    }

    private static boolean hasGradientState(TypedArray typedArray) {
        return typedArray.hasValue(R.styleable.background_bl_checkable_gradient_startColor) || typedArray.hasValue(R.styleable.background_bl_checked_gradient_startColor) || typedArray.hasValue(R.styleable.background_bl_enabled_gradient_startColor) || typedArray.hasValue(R.styleable.background_bl_selected_gradient_startColor) || typedArray.hasValue(R.styleable.background_bl_pressed_gradient_startColor) || typedArray.hasValue(R.styleable.background_bl_focused_gradient_startColor);
    }
}

