/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog.parseltongue;

import com.caseyjbrooks.clog.ClogFormatter;
import com.caseyjbrooks.clog.parseltongue.ParseltonguePair;
import com.caseyjbrooks.clog.parseltongue.Spell;
import com.caseyjbrooks.clog.parseltongue.TheStandardBookOfSpells;
import com.caseyjbrooks.clog.parseltongue.Token;
import com.caseyjbrooks.clog.parseltongue.TokenStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Parseltongue
implements ClogFormatter {
    private List<ParseltonguePair<String, Method>> spells = new ArrayList<ParseltonguePair<String, Method>>();
    boolean privateFieldsAccessible = false;

    public Parseltongue() {
        this.findSpells(TheStandardBookOfSpells.class);
    }

    public void findSpells(Class c) {
        for (Method method : c.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Spell.class)) continue;
            Spell methodAnnotation = method.getAnnotation(Spell.class);
            String spellName = methodAnnotation.name();
            if (spellName.length() == 0) {
                spellName = method.getName();
            }
            this.spells.add(new ParseltonguePair<String, Method>(spellName, method));
        }
    }

    public boolean arePrivateFieldsAccessible() {
        return this.privateFieldsAccessible;
    }

    public void setPrivateFieldsAccessible(boolean privateFieldsAccessible) {
        this.privateFieldsAccessible = privateFieldsAccessible;
    }

    @Override
    public String format(String messagae, Object ... params) {
        if (params != null && params.length > 0) {
            return new Parser().parse(messagae, params);
        }
        return new Parser().parse(messagae, null);
    }

    public Object transfigureObject(String key, Object reagent, Object ... reagents) {
        for (ParseltonguePair<String, Method> method : this.spells) {
            if (!((String)method.first).equals(key)) continue;
            Class<?>[] parameterTypes = ((Method)method.second).getParameterTypes();
            ArrayList<Object> params = new ArrayList<Object>();
            if (reagent != null) {
                params.add(reagent);
            } else {
                params.add(new NullObject());
            }
            if (reagents != null && reagents.length > 0) {
                for (int i = 0; i < reagents.length; ++i) {
                    if (reagents[i] != null) {
                        params.add(reagents[i]);
                        continue;
                    }
                    params.add(new NullObject());
                }
            }
            if (parameterTypes.length != params.size()) continue;
            boolean methodMatch = true;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof NullObject || parameterTypes[i].equals(Byte.TYPE) && params.get(i).getClass().equals(Byte.class) || parameterTypes[i].equals(Short.TYPE) && params.get(i).getClass().equals(Short.class) || parameterTypes[i].equals(Integer.TYPE) && params.get(i).getClass().equals(Integer.class) || parameterTypes[i].equals(Long.TYPE) && params.get(i).getClass().equals(Long.class) || parameterTypes[i].equals(Float.TYPE) && params.get(i).getClass().equals(Float.class) || parameterTypes[i].equals(Double.TYPE) && params.get(i).getClass().equals(Double.class) || parameterTypes[i].equals(Boolean.TYPE) && params.get(i).getClass().equals(Boolean.class) || parameterTypes[i].isAssignableFrom(params.get(i).getClass())) continue;
                methodMatch = false;
                break;
            }
            if (!methodMatch) continue;
            Object[] objects = new Object[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                objects[i] = params.get(i) instanceof NullObject ? null : params.get(i);
            }
            try {
                return ((Method)method.second).invoke(null, objects);
            }
            catch (Exception exception) {
                break;
            }
        }
        return null;
    }

    private class NullObject {
        private NullObject() {
        }
    }

    private class Parser {
        private ArrayList<Object> params;
        private ArrayList<Object> results;
        TokenStream ts;
        String input;
        String output;
        private int autoParamCounter;
        private ArrayList<String> messages;

        private Parser() {
        }

        public String parse(String input, Object[] params) {
            this.params = params != null && params.length > 0 ? new ArrayList<Object>(Arrays.asList(params)) : new ArrayList();
            this.results = new ArrayList();
            this.messages = new ArrayList();
            this.input = input;
            this.output = "";
            this.ts = new TokenStream(input);
            this.autoParamCounter = 0;
            while (this.ts.hasTokens()) {
                this.any();
                if (!this.ts.hasTokens()) continue;
                this.clog();
            }
            return this.output;
        }

        private void any() {
            Token t = this.ts.getAny();
            this.output = this.output + t.getStringValue();
        }

        private void clog() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.CLOG_START)) {
                ParseltonguePair<Boolean, Object> object = this.reagent();
                if (((Boolean)object.first).booleanValue()) {
                    ParseltonguePair<Boolean, Object> spellbookResult = this.spellbook(object.second);
                    this.results.add(spellbookResult.second);
                    if (((Boolean)spellbookResult.first).booleanValue()) {
                        Token b = this.ts.get();
                        if (b != null && b.equals(Token.Type.RCURLYBRACE)) {
                            if (spellbookResult.second != null) {
                                this.output = this.output + spellbookResult.second.toString();
                            }
                        } else {
                            this.ts.unget(b);
                            if (b != null) {
                                this.messages.add("Expecting '}' after clog, got '" + b.getStringValue() + "' (at column " + this.ts.getColumn() + ")");
                            } else {
                                this.messages.add("Expecting '}' after clog, got 'null' (at column " + this.ts.getColumn() + ")");
                            }
                            this.unclog();
                        }
                    } else {
                        this.unclog();
                    }
                } else {
                    this.unclog();
                    this.results.add(null);
                }
            } else if (a != null && a.equals(Token.Type.CLOG_SIMPLE)) {
                ParseltonguePair<Boolean, Object> object = this.autoParam();
                if (((Boolean)object.first).booleanValue()) {
                    Token b = this.ts.get();
                    if (b != null && b.equals(Token.Type.RCURLYBRACE)) {
                        if (object.second != null) {
                            this.output = this.output + object.second.toString();
                        }
                    } else {
                        this.ts.unget(b);
                        if (b != null) {
                            this.messages.add("Expecting '}' after simple clog, got '" + b.getStringValue() + "' (at column " + this.ts.getColumn() + ")");
                        } else {
                            this.messages.add("Expecting '}' after simple clog, got 'null' (at column " + this.ts.getColumn() + ")");
                        }
                        this.unclog();
                    }
                } else {
                    this.unclog();
                    this.results.add(null);
                }
            }
        }

        private ParseltonguePair<Boolean, Object> spellbook(Object initialReagent) {
            Token a;
            Object pipelineObject = initialReagent;
            while ((a = this.ts.get()) != null && a.equals(Token.Type.PIPE)) {
                ParseltonguePair<Boolean, Object> spellResult = this.castSpell(pipelineObject);
                if (((Boolean)spellResult.first).booleanValue()) {
                    ParseltonguePair<Boolean, Object> indexedSpell = this.indexer(spellResult);
                    if (((Boolean)indexedSpell.first).booleanValue()) {
                        pipelineObject = indexedSpell.second;
                        continue;
                    }
                    pipelineObject = spellResult.second;
                    continue;
                }
                return new ParseltonguePair<Boolean, Object>(false, null);
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(true, pipelineObject);
        }

        private ParseltonguePair<Boolean, Object> castSpell(Object reagent) {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.WORD)) {
                Token b = this.ts.get();
                if (b != null && b.equals(Token.Type.LPAREN)) {
                    ParseltonguePair<Boolean, Object[]> reagents = this.reagentList();
                    if (((Boolean)reagents.first).booleanValue()) {
                        Token c = this.ts.get();
                        if (c != null && c.equals(Token.Type.RPAREN)) {
                            return new ParseltonguePair<Boolean, Object>(true, Parseltongue.this.transfigureObject(a.getStringValue(), reagent, (Object[])reagents.second));
                        }
                        this.ts.unget(c);
                        this.ts.unget(b);
                        this.ts.unget(a);
                        if (c != null) {
                            this.messages.add("Expecting ')' after param list, got '" + c.getStringValue() + "' (at column " + this.ts.getColumn() + ")");
                        } else {
                            this.messages.add("Expecting ')' after param list, got 'null' (at column " + this.ts.getColumn() + ")");
                        }
                        return new ParseltonguePair<Boolean, Object>(false, null);
                    }
                    return new ParseltonguePair<Boolean, Object>(false, null);
                }
                this.ts.unget(b);
                return new ParseltonguePair<Boolean, Object>(true, Parseltongue.this.transfigureObject(a.getStringValue(), reagent, new Object[0]));
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Object[]> reagentList() {
            ArrayList reagents = new ArrayList();
            ParseltonguePair<Boolean, Object> reagent = this.reagent();
            if (((Boolean)reagent.first).booleanValue()) {
                Token a;
                reagents.add(reagent.second);
                while ((a = this.ts.get()) != null && a.equals(Token.Type.COMMA)) {
                    ParseltonguePair<Boolean, Object> otherReagent = this.reagent();
                    if (((Boolean)otherReagent.first).booleanValue()) {
                        reagents.add(otherReagent.second);
                        continue;
                    }
                    return new ParseltonguePair<Boolean, Object>(false, null);
                }
                this.ts.unget(a);
                Object[] reagentsList = new Object[reagents.size()];
                reagents.toArray(reagentsList);
                return new ParseltonguePair<Boolean, Object[]>(true, reagentsList);
            }
            return new ParseltonguePair<Boolean, Object>(true, null);
        }

        private ParseltonguePair<Boolean, Object> reagent() {
            ParseltonguePair<Boolean, Object> param = this.param();
            if (((Boolean)param.first).booleanValue()) {
                return this.indexer(param);
            }
            ParseltonguePair<Boolean, Object> result = this.result();
            if (((Boolean)result.first).booleanValue()) {
                return this.indexer(result);
            }
            ParseltonguePair<Boolean, Boolean> booleanLit = this.booleanLit();
            if (((Boolean)booleanLit.first).booleanValue()) {
                return new ParseltonguePair<Boolean, Object>(true, booleanLit.second);
            }
            ParseltonguePair<Boolean, Double> doubleLit = this.doubleLit();
            if (((Boolean)doubleLit.first).booleanValue()) {
                return new ParseltonguePair<Boolean, Object>(true, doubleLit.second);
            }
            ParseltonguePair<Boolean, Integer> integerLit = this.integerLit();
            if (((Boolean)integerLit.first).booleanValue()) {
                return new ParseltonguePair<Boolean, Object>(true, integerLit.second);
            }
            ParseltonguePair<Boolean, String> stringLit = this.stringLit();
            if (((Boolean)stringLit.first).booleanValue()) {
                return new ParseltonguePair<Boolean, Object>(true, stringLit.second);
            }
            ParseltonguePair<Boolean, NullObject> nullLit = this.nullLit();
            if (((Boolean)nullLit.first).booleanValue()) {
                return new ParseltonguePair<Boolean, Object>(true, nullLit.second);
            }
            ParseltonguePair<Boolean, Object> autoParam = this.autoParam();
            if (((Boolean)autoParam.first).booleanValue()) {
                return autoParam;
            }
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Object> param() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.DOLLARSIGN)) {
                Token b = this.ts.get();
                if (b != null && b.equals(Token.Type.NUMBER)) {
                    int index = b.getIntValue();
                    if (index > 0 && index - 1 < this.params.size()) {
                        return new ParseltonguePair<Boolean, Object>(true, this.params.get(index - 1));
                    }
                    return new ParseltonguePair<Boolean, Object>(true, null);
                }
                this.ts.unget(b);
                this.ts.unget(a);
                if (b != null) {
                    this.messages.add("Expecting a number after '$', got '" + b.getStringValue() + "' (at column " + this.ts.getColumn() + ")");
                } else {
                    this.messages.add("Expecting a number after '$', got 'null' (at column " + this.ts.getColumn() + ")");
                }
                return new ParseltonguePair<Boolean, Object>(false, null);
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Object> result() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.AT)) {
                Token b = this.ts.get();
                if (b != null && b.equals(Token.Type.NUMBER)) {
                    int index = b.getIntValue();
                    if (index > 0 && index - 1 < this.results.size()) {
                        return new ParseltonguePair<Boolean, Object>(true, this.results.get(index - 1));
                    }
                    return new ParseltonguePair<Boolean, Object>(true, null);
                }
                this.ts.unget(b);
                this.ts.unget(a);
                if (b != null) {
                    this.messages.add("Expecting a number after '@', got '" + b.getStringValue() + "' (at column " + this.ts.getColumn() + ")");
                } else {
                    this.messages.add("Expecting a number after '@', got 'null' (at column " + this.ts.getColumn() + ")");
                }
                return new ParseltonguePair<Boolean, Object>(false, null);
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Boolean> booleanLit() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.WORD)) {
                if (a.getStringValue().equalsIgnoreCase("true")) {
                    return new ParseltonguePair<Boolean, Boolean>(true, true);
                }
                if (a.getStringValue().equalsIgnoreCase("false")) {
                    return new ParseltonguePair<Boolean, Boolean>(true, false);
                }
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Boolean>(false, false);
        }

        private ParseltonguePair<Boolean, Double> doubleLit() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.NUMBER)) {
                Token b = this.ts.get();
                if (b != null && b.equals(Token.Type.DOT)) {
                    Token c = this.ts.get();
                    if (c != null && c.equals(Token.Type.NUMBER)) {
                        return new ParseltonguePair<Boolean, Double>(true, Double.parseDouble(a.getIntValue() + "." + c.getIntValue()));
                    }
                    this.ts.unget(c);
                    this.ts.unget(b);
                    this.ts.unget(a);
                } else {
                    this.ts.unget(b);
                    this.ts.unget(a);
                }
            } else {
                this.ts.unget(a);
            }
            return new ParseltonguePair<Boolean, Double>(false, 0.0);
        }

        private ParseltonguePair<Boolean, Integer> integerLit() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.NUMBER)) {
                return new ParseltonguePair<Boolean, Integer>(true, a.getIntValue());
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Integer>(false, 0);
        }

        private ParseltonguePair<Boolean, String> stringLit() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.QUOTE)) {
                Token b = this.ts.getString();
                if (b != null) {
                    Token c = this.ts.get();
                    if (c != null && c.equals(Token.Type.QUOTE)) {
                        return new ParseltonguePair<Boolean, String>(true, b.getStringValue());
                    }
                    this.ts.unget(c);
                    this.ts.unget(b);
                    this.ts.unget(a);
                    this.messages.add("String literal is never closed (at column " + this.ts.getColumn() + ")");
                    this.unclogString();
                } else {
                    this.ts.unget(b);
                    this.ts.unget(a);
                    this.messages.add("String literal is never closed (at column " + this.ts.getColumn() + ")");
                    this.unclogString();
                }
            } else {
                this.ts.unget(a);
            }
            return new ParseltonguePair<Boolean, String>(false, "");
        }

        private ParseltonguePair<Boolean, NullObject> nullLit() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.WORD) && a.getStringValue().equalsIgnoreCase("null")) {
                return new ParseltonguePair<Boolean, NullObject>(true, new NullObject());
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Object> autoParam() {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.RCURLYBRACE)) {
                this.ts.unget(a);
                ++this.autoParamCounter;
                if (this.autoParamCounter > 0 && this.autoParamCounter - 1 < this.params.size()) {
                    return new ParseltonguePair<Boolean, Object>(true, this.params.get(this.autoParamCounter - 1));
                }
                return new ParseltonguePair<Boolean, Object>(true, null);
            }
            this.ts.unget(a);
            return new ParseltonguePair<Boolean, Object>(false, null);
        }

        private ParseltonguePair<Boolean, Object> indexer(ParseltonguePair<Boolean, Object> object) {
            Token a = this.ts.get();
            if (a != null && a.equals(Token.Type.LBRACKET)) {
                Token b = this.ts.get();
                if (b != null && b.equals(Token.Type.NUMBER)) {
                    Token c = this.ts.get();
                    if (c != null && c.equals(Token.Type.RBRACKET)) {
                        return new ParseltonguePair<Boolean, Object>(true, this.arrayIndexer(object.second, b.getIntValue()));
                    }
                    this.ts.unget(c);
                    this.ts.unget(b);
                    this.ts.unget(a);
                    return new ParseltonguePair<Boolean, Object>(false, null);
                }
                if (b != null && b.equals(Token.Type.WORD)) {
                    Token c = this.ts.get();
                    if (c != null && c.equals(Token.Type.RBRACKET)) {
                        return new ParseltonguePair<Boolean, Object>(true, this.propertyIndexer(object.second, b.getStringValue()));
                    }
                    this.ts.unget(c);
                    this.ts.unget(b);
                    this.ts.unget(a);
                    return new ParseltonguePair<Boolean, Object>(false, null);
                }
                if (b != null && b.equals(Token.Type.QUOTE)) {
                    this.ts.unget(b);
                    ParseltonguePair<Boolean, String> stringKey = this.stringLit();
                    if (((Boolean)stringKey.first).booleanValue()) {
                        Token c = this.ts.get();
                        if (c != null && c.equals(Token.Type.RBRACKET)) {
                            return new ParseltonguePair<Boolean, Object>(true, this.mapIndexer(object.second, (String)stringKey.second));
                        }
                        this.ts.unget(c);
                        this.ts.unget(b);
                        this.ts.unget(a);
                        return new ParseltonguePair<Boolean, Object>(false, null);
                    }
                    return new ParseltonguePair<Boolean, Object>(false, null);
                }
                this.ts.unget(b);
                this.ts.unget(a);
                return new ParseltonguePair<Boolean, Object>(false, null);
            }
            this.ts.unget(a);
            return object;
        }

        private void unclog() {
            this.ts.unclog();
        }

        private void unclogString() {
        }

        private Object arrayIndexer(Object object, int index) {
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (index >= 0 && index < array.length) {
                    return array[index];
                }
                return null;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (index >= 0 && index < list.size()) {
                    return list.get(index);
                }
                return null;
            }
            return null;
        }

        private Object propertyIndexer(Object object, String property) {
            try {
                Class<?> c = object.getClass();
                Field field = c.getField(property);
                return field.get(object);
            }
            catch (Exception e) {
                if (Parseltongue.this.privateFieldsAccessible) {
                    try {
                        Class<?> c = object.getClass();
                        Field field = c.getDeclaredField(property);
                        field.setAccessible(Parseltongue.this.privateFieldsAccessible);
                        return field.get(object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        private Object mapIndexer(Object object, String key) {
            if (object instanceof Map) {
                Map map = (Map)object;
                if (map.containsKey(key)) {
                    return map.get(key);
                }
                return null;
            }
            try {
                Method method = object.getClass().getMethod("get", String.class);
                return method.invoke(object, key);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

