/*
 * Decompiled with CFR 0.152.
 */
package com.caseyjbrooks.clog;

import com.caseyjbrooks.clog.ClogFormatter;
import com.caseyjbrooks.clog.ClogLogger;
import com.caseyjbrooks.clog.DefaultLogger;
import com.caseyjbrooks.clog.parseltongue.Parseltongue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class Clog {
    public static final String KEY_V = "v";
    public static final String KEY_D = "d";
    public static final String KEY_I = "i";
    public static final String KEY_W = "w";
    public static final String KEY_E = "e";
    public static final String KEY_WTF = "wtf";
    private static final String CLASS_NAME = Clog.class.getName();
    private static HashMap<String, Clog> profiles = new HashMap();
    private static Clog instance;
    private HashMap<String, ClogLogger> loggers;
    private ClogFormatter formatter;
    private String lastTag;
    private String lastLog;
    private Stack<String> tagStack = new Stack();
    private List<String> tagWhitelist;
    private List<String> tagBlacklist;
    private List<String> loggerWhitelist;
    private List<String> loggerBlacklist;
    private Priority minPriority;
    private Priority maxPriority;

    public static Clog getInstance() {
        if (instance == null) {
            instance = profiles == null || profiles.get(null) == null ? new Clog() : profiles.get(null);
        }
        return instance;
    }

    private Clog() {
        this.loggers = new HashMap();
        this.loggers.put(null, new DefaultLogger(Priority.DEFAULT));
        this.loggers.put(KEY_V, new DefaultLogger(Priority.VERBOSE));
        this.loggers.put(KEY_D, new DefaultLogger(Priority.DEBUG));
        this.loggers.put(KEY_I, new DefaultLogger(Priority.INFO));
        this.loggers.put(KEY_W, new DefaultLogger(Priority.WARNING));
        this.loggers.put(KEY_E, new DefaultLogger(Priority.ERROR));
        this.loggers.put(KEY_WTF, new DefaultLogger(Priority.FATAL));
        this.formatter = new Parseltongue();
        this.tagWhitelist = new ArrayList<String>();
        this.tagBlacklist = new ArrayList<String>();
        this.loggerWhitelist = new ArrayList<String>();
        this.loggerBlacklist = new ArrayList<String>();
        this.minPriority = null;
        this.maxPriority = null;
    }

    public Clog(HashMap<String, ClogLogger> loggers, ClogFormatter formatter) {
        this.loggers = loggers;
        this.formatter = formatter;
        this.tagWhitelist = new ArrayList<String>();
        this.tagBlacklist = new ArrayList<String>();
        this.loggerWhitelist = new ArrayList<String>();
        this.loggerBlacklist = new ArrayList<String>();
        this.minPriority = null;
        this.maxPriority = null;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String format(String message, Object ... args) {
        return Clog.getInstance().formatter.format(message, args);
    }

    public static int logger(String logger, Throwable throwable) {
        return Clog.getInstance().loggerInternal(logger, null, null, throwable);
    }

    public static int logger(String logger, String message, Object ... args) {
        return Clog.getInstance().loggerInternal(logger, message, null, args);
    }

    public static int logger(String logger, String message, Throwable throwable, Object ... args) {
        return Clog.getInstance().loggerInternal(logger, message, throwable, args);
    }

    public static int log(Throwable throwable) {
        return Clog.logger(null, throwable);
    }

    public static int log(String message, Object ... args) {
        return Clog.logger(null, message, args);
    }

    public static int log(String message, Throwable throwable, Object ... args) {
        return Clog.logger(null, message, throwable, args);
    }

    public static int v(Throwable throwable) {
        return Clog.logger(KEY_V, throwable);
    }

    public static int v(String message, Object ... args) {
        return Clog.logger(KEY_V, message, args);
    }

    public static int v(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_V, message, throwable, args);
    }

    public static int d(Throwable throwable) {
        return Clog.logger(KEY_D, throwable);
    }

    public static int d(String message, Object ... args) {
        return Clog.logger(KEY_D, message, args);
    }

    public static int d(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_D, message, throwable, args);
    }

    public static int i(Throwable throwable) {
        return Clog.logger(KEY_I, throwable);
    }

    public static int i(String message, Object ... args) {
        return Clog.logger(KEY_I, message, args);
    }

    public static int i(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_I, message, throwable, args);
    }

    public static int w(Throwable throwable) {
        return Clog.logger(KEY_W, throwable);
    }

    public static int w(String message, Object ... args) {
        return Clog.logger(KEY_W, message, args);
    }

    public static int w(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_W, message, throwable, args);
    }

    public static int e(Throwable throwable) {
        return Clog.logger(KEY_E, throwable);
    }

    public static int e(String message, Object ... args) {
        return Clog.logger(KEY_E, message, args);
    }

    public static int e(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_E, message, throwable, args);
    }

    public static int wtf(Throwable throwable) {
        return Clog.logger(KEY_WTF, throwable);
    }

    public static int wtf(String message, Object ... args) {
        return Clog.logger(KEY_WTF, message, args);
    }

    public static int wtf(String message, Throwable throwable, Object ... args) {
        return Clog.logger(KEY_WTF, message, throwable, args);
    }

    private int loggerInternal(String logger, String message, Throwable throwable, Object ... args) {
        ClogLogger currentLogger = null;
        String currentTag = Clog.getTag();
        boolean inWhitelist = false;
        for (String whiteListedTag : this.tagWhitelist) {
            if (!currentTag.equals(whiteListedTag)) continue;
            inWhitelist = true;
            break;
        }
        boolean inBlacklist = false;
        for (String blackListedTag : this.tagBlacklist) {
            if (!currentTag.equals(blackListedTag)) continue;
            inBlacklist = true;
            break;
        }
        if (this.tagWhitelist.size() > 0 && !inWhitelist || this.tagBlacklist.size() > 0 && inBlacklist) {
            return 0;
        }
        if (this.loggers != null) {
            if (this.loggers.containsKey(logger)) {
                currentLogger = this.loggers.get(logger);
            }
            if (currentLogger == null && this.loggers.containsKey(null)) {
                currentLogger = this.loggers.get(null);
            }
            if (currentLogger == null) {
                currentLogger = new DefaultLogger();
            }
        } else {
            currentLogger = new DefaultLogger();
        }
        inWhitelist = false;
        for (String whiteListedLogger : this.loggerWhitelist) {
            if (!logger.equals(whiteListedLogger)) continue;
            inWhitelist = true;
            break;
        }
        inBlacklist = false;
        for (String blackListedLogger : this.loggerBlacklist) {
            if (!logger.equals(blackListedLogger)) continue;
            inBlacklist = true;
            break;
        }
        if (this.loggerWhitelist.size() > 0 && !inWhitelist || this.loggerBlacklist.size() > 0 && inBlacklist) {
            return 0;
        }
        if (this.minPriority != null && currentLogger.priority().getPriority() < this.minPriority.getPriority()) {
            return 0;
        }
        if (this.maxPriority != null && currentLogger.priority().getPriority() > this.maxPriority.getPriority()) {
            return 0;
        }
        if (currentLogger.isActive()) {
            currentTag = Clog.getTag();
            String currentMessage = message != null ? this.formatter.format(message, args) : (throwable != null ? Clog.getStackTraceString(throwable) : "");
            if (throwable == null) {
                this.lastTag = currentTag;
                this.lastLog = currentMessage;
                return currentLogger.log(currentTag, currentMessage);
            }
            this.lastTag = currentTag;
            this.lastLog = currentMessage;
            return currentLogger.log(currentTag, currentMessage, throwable);
        }
        return 0;
    }

    public static void addProfile(String key, Clog clog) {
        profiles.put(key, clog);
    }

    public static void removeProfile(String key) {
        profiles.remove(key);
    }

    public static void setCurrentProfile(String key) {
        instance = profiles.get(key);
    }

    public static void setCurrentProfile(String key, Clog clog) {
        Clog.addProfile(key, clog);
        Clog.setCurrentProfile(key);
    }

    public static HashMap<String, Clog> getProfiles() {
        return profiles;
    }

    public static void setAllProfiles(HashMap<String, Clog> profiles) {
        Clog.profiles = profiles;
    }

    public static HashMap<String, ClogLogger> getLoggers() {
        return Clog.getInstance().loggers;
    }

    public static ArrayList<String> getLoggerKeys() {
        return new ArrayList<String>(Clog.getInstance().loggers.keySet());
    }

    public static void setLoggers(HashMap<String, ClogLogger> loggers) {
        Clog.getInstance().loggers = loggers;
    }

    public static void addLogger(String key, ClogLogger logger) {
        Clog.getInstance().loggers.put(key, logger);
    }

    public static void setDefaultLogger(ClogLogger logger) {
        Clog.getInstance().loggers.put(null, logger);
    }

    public static void removeLogger(String key) {
        Clog.getInstance().loggers.remove(key);
    }

    public static void setFormatter(ClogFormatter formatter) {
        Clog.getInstance().formatter = formatter;
    }

    public static ClogFormatter getFormatter() {
        return Clog.getInstance().formatter;
    }

    public static String getLastTag() {
        return Clog.getInstance().lastTag;
    }

    public static String getLastLog() {
        return Clog.getInstance().lastLog;
    }

    public static void flush() {
        Clog.getInstance().lastTag = null;
        Clog.getInstance().lastLog = null;
    }

    public static void addTagToWhitelist(String tag) {
        Clog.getInstance().tagWhitelist.add(tag);
    }

    public static void addTagToBlacklist(String tag) {
        Clog.getInstance().tagBlacklist.add(tag);
    }

    public static void clearTagWhitelist() {
        Clog.getInstance().tagWhitelist.clear();
    }

    public static void clearTagBlacklist() {
        Clog.getInstance().tagBlacklist.clear();
    }

    public static void addLoggerToWhitelist(String tag) {
        Clog.getInstance().loggerWhitelist.add(tag);
    }

    public static void addLoggerToBlacklist(String tag) {
        Clog.getInstance().loggerBlacklist.add(tag);
    }

    public static void clearLoggerWhitelist() {
        Clog.getInstance().loggerWhitelist.clear();
    }

    public static void clearLoggerBlacklist() {
        Clog.getInstance().loggerBlacklist.clear();
    }

    public static void setMinPriority(Priority minPriority) {
        Clog.getInstance().minPriority = minPriority;
    }

    public static void setMaxPriority(Priority maxPriority) {
        Clog.getInstance().maxPriority = maxPriority;
    }

    public static void pushTag(String tag) {
        Clog.getInstance().tagStack.push(tag);
    }

    public static void popTag() {
        Clog.getInstance().tagStack.pop();
    }

    public static String getCurrentTag() {
        return Clog.getTag();
    }

    private static String getTag() {
        if (Clog.getInstance().tagStack.size() > 0) {
            return Clog.getInstance().tagStack.peek();
        }
        return Clog.findCallerClassName();
    }

    private static String findCallerClassName() {
        return Clog.findCallerClassName(null);
    }

    private static String findCallerClassName(Throwable t) {
        StackTraceElement[] frames;
        String className = "Unknown";
        if (t == null) {
            t = new Throwable();
        }
        if ((frames = t.getStackTrace()).length == 0) {
            return className;
        }
        for (int f = 0; f < frames.length && (className = frames[f].getClassName()).equals(CLASS_NAME); ++f) {
        }
        return Clog.parseClassName(className);
    }

    private static String parseClassName(String fullName) {
        int lastdollar;
        int lastdot = fullName.lastIndexOf(46);
        String simpleName = fullName;
        if (lastdot != -1) {
            simpleName = fullName.substring(lastdot + 1);
        }
        if ((lastdollar = simpleName.lastIndexOf(36)) != -1) {
            simpleName = simpleName.substring(0, lastdollar);
        }
        return simpleName;
    }

    static {
        profiles.put(null, new Clog());
    }

    public static enum Priority {
        VERBOSE("v", 1),
        DEBUG("d", 2),
        INFO("i", 3),
        DEFAULT(null, 4),
        WARNING("e", 5),
        ERROR("e", 6),
        FATAL("wtf", 7);

        private final int priority;
        private final String key;

        private Priority(String key, int priority) {
            this.key = key;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getKey() {
            return this.key;
        }

        public static Priority getByKey(String key) {
            for (Priority priority : Priority.values()) {
                if (!priority.toString().equalsIgnoreCase(key) && (priority.getKey() != null || key != null) && (priority.getKey() == null || !priority.getKey().equalsIgnoreCase(key))) continue;
                return priority;
            }
            return DEFAULT;
        }
    }
}

