/*
 * Decompiled with CFR 0.152.
 */
package com.github.JanLoebel.jsonschemavalidation;

import com.networknt.schema.ValidationMessage;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

public class JsonSchemaValidationException
extends ResponseStatusException {
    private final Collection<ValidationMessage> validationMessages;

    public JsonSchemaValidationException(Collection<ValidationMessage> validationMessages) {
        super(HttpStatus.BAD_REQUEST, JsonSchemaValidationException.buildMessage(validationMessages));
        this.validationMessages = validationMessages;
    }

    private static String buildMessage(Collection<ValidationMessage> validationMessages) {
        String prefix = "JsonSchemaValidation failed: ";
        return "JsonSchemaValidation failed: " + validationMessages.stream().map(ValidationMessage::toString).collect(Collectors.joining(", "));
    }

    public Collection<ValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public String toString() {
        return "JsonSchemaValidationException{validationMessages=" + this.validationMessages + '}';
    }
}

