/*
 * Decompiled with CFR 0.152.
 */
package com.devzone.fillprogresslayout;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.devzone.fillprogresslayout.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 Q2\u00020\u0001:\u0001QB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0012\u0010+\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\b\u0010,\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020\tH\u0002J\b\u0010.\u001a\u00020(H\u0002J\u001a\u0010/\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\tH\u0002J\b\u00102\u001a\u00020(H\u0014J\u0012\u00103\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0014J(\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\tH\u0014J\u0012\u00109\u001a\u00020(2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\tH\u0016J\u0012\u0010>\u001a\u00020(2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\tH\u0016J\u000e\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020\u0014J\u000e\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\tJ\u000e\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020\tJ\u0010\u0010J\u001a\u00020(2\b\b\u0001\u0010K\u001a\u00020\tJ\u0010\u0010L\u001a\u00020(2\b\b\u0001\u0010K\u001a\u00020\tJ\u000e\u0010M\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010N\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u0019J\u0010\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020\fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/devzone/fillprogresslayout/FillProgressLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backRectF", "Landroid/graphics/RectF;", "backgroundPaint", "Landroid/graphics/Paint;", "clipPath", "Landroid/graphics/Path;", "currentProgress", "defBackgroundColor", "defCornerRadius", "", "defDirection", "defDuration", "defDurationFactor", "defIsRestart", "", "defIsRounded", "defProgressColor", "isRestart", "isRounded", "mBackgroundColor", "mCornerRadius", "mDirection", "mDurationFactor", "mProgressColor", "maxProgress", "oldProgress", "progressPaint", "progressRectF", "drawNormalProgress", "", "canvas", "Landroid/graphics/Canvas;", "drawRoundedProgress", "getProgress", "getSize", "initPaint", "initUI", "isValidRes", "res", "onDetachedFromWindow", "onDraw", "onSizeChanged", "w", "h", "oldw", "oldh", "setBackground", "background", "Landroid/graphics/drawable/Drawable;", "setBackgroundColor", "color", "setBackgroundDrawable", "setBackgroundResource", "resid", "setCornerRadius", "radius", "setDirection", "direction", "setDuration", "duration", "", "setProgress", "p", "setProgressBackgroundColor", "resId", "setProgressColor", "setRoundedCorners", "shouldStartFromZero", "updateRect", "rectF", "Companion", "fillprogresslayout_release"})
public final class FillProgressLayout
extends LinearLayout {
    private final int maxProgress = 100;
    private final int defDurationFactor = 30;
    private final int defDuration = 3000;
    private final float defCornerRadius = 20.0f;
    private final int defDirection = 0;
    private final int defBackgroundColor = -3355444;
    private final int defProgressColor = -7829368;
    private final boolean defIsRestart = false;
    private final boolean defIsRounded = false;
    private boolean isRounded;
    private boolean isRestart;
    private int mDurationFactor;
    private int mDirection;
    private float mCornerRadius;
    private int mBackgroundColor;
    private int mProgressColor;
    private int oldProgress;
    private int currentProgress;
    private Paint progressPaint;
    private Paint backgroundPaint;
    private final Path clipPath;
    private RectF progressRectF;
    private RectF backRectF;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int TOP_TO_BOTTOM = 2;
    public static final int BOTTOM_TO_TOP = 3;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void initUI(Context context, AttributeSet attrs) {
        this.setWillNotDraw(false);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.FillProgressLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026eable.FillProgressLayout)");
            TypedArray array = typedArray;
            if (array.length() > 0) {
                this.mBackgroundColor = array.getColor(R.styleable.FillProgressLayout_fpl_backgroundColor, this.defBackgroundColor);
                this.mProgressColor = array.getColor(R.styleable.FillProgressLayout_fpl_progressColor, this.defProgressColor);
                boolean restart = array.getBoolean(R.styleable.FillProgressLayout_fpl_shouldRestart, this.defIsRestart);
                this.shouldStartFromZero(restart);
                float cornerRadius = array.getFloat(R.styleable.FillProgressLayout_fpl_roundedCornerRadius, this.defCornerRadius);
                this.setCornerRadius(cornerRadius);
                boolean isRounded = array.getBoolean(R.styleable.FillProgressLayout_fpl_isRounded, this.defIsRounded);
                this.setRoundedCorners(isRounded);
                int duration = array.getInt(R.styleable.FillProgressLayout_fpl_progressDuration, this.defDuration);
                this.setDuration(duration);
                int direction = array.getInt(R.styleable.FillProgressLayout_fpl_progressDirection, this.defDirection);
                this.setDirection(direction);
                int progress = array.getInt(R.styleable.FillProgressLayout_fpl_progress, this.currentProgress);
                this.setProgress(progress);
            }
            array.recycle();
        }
        this.initPaint();
    }

    private final void initPaint() {
        Paint paint = this.backgroundPaint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.mBackgroundColor);
        paint = this.progressPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.mProgressColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.backRectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.progressRectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.progressRectF.bottom = h;
        this.updateRect(this.progressRectF);
        if (this.isRounded) {
            this.clipPath.addRoundRect(this.backRectF, this.mCornerRadius, this.mCornerRadius, Path.Direction.CW);
            this.clipPath.close();
        }
    }

    private final int getProgress() {
        return this.getSize() * this.currentProgress / 100;
    }

    private final int getSize() {
        return this.mDirection == 0 || this.mDirection == 1 ? this.getWidth() : this.getHeight();
    }

    private final void updateRect(RectF rectF) {
        switch (this.mDirection) {
            case 0: {
                rectF.right = this.getProgress();
                break;
            }
            case 1: {
                rectF.left = (float)this.getSize() - (float)this.getProgress();
                break;
            }
            case 2: {
                rectF.bottom = this.getProgress();
                break;
            }
            case 3: {
                rectF.top = (float)this.getSize() - (float)this.getProgress();
            }
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        if (this.isRounded) {
            this.drawRoundedProgress(canvas);
        } else {
            this.drawNormalProgress(canvas);
        }
        super.onDraw(canvas);
    }

    private final void drawNormalProgress(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas $this$apply = canvas3;
            boolean bl3 = false;
            $this$apply.drawRect(this.backRectF, this.backgroundPaint);
            $this$apply.drawRect(this.progressRectF, this.progressPaint);
        }
    }

    private final void drawRoundedProgress(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas $this$apply = canvas3;
            boolean bl3 = false;
            $this$apply.save();
            $this$apply.drawRoundRect(this.backRectF, this.mCornerRadius, this.mCornerRadius, this.backgroundPaint);
            $this$apply.clipPath(this.clipPath);
            $this$apply.drawRect(this.progressRectF, this.progressPaint);
            $this$apply.restore();
        }
    }

    private final boolean isValidRes(int res) {
        return res != -1;
    }

    protected void onDetachedFromWindow() {
        this.clearAnimation();
        super.onDetachedFromWindow();
    }

    public final void setProgress(int p) {
        int n = p;
        if (0 <= n && this.maxProgress >= n) {
            Animator $receiver$iv;
            ValueAnimator animator;
            this.clearAnimation();
            ValueAnimator valueAnimator = animator = ValueAnimator.ofInt((int[])new int[]{this.oldProgress, p});
            Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
            valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ FillProgressLayout this$0;

                public final void onAnimationUpdate(ValueAnimator anm) {
                    ValueAnimator valueAnimator = anm;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"anm");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    FillProgressLayout.access$setCurrentProgress$p(this.this$0, (Integer)object);
                    FillProgressLayout.access$updateRect(this.this$0, FillProgressLayout.access$getProgressRectF$p(this.this$0));
                    ViewCompat.postInvalidateOnAnimation((View)((View)this.this$0));
                }
                {
                    this.this$0 = fillProgressLayout;
                }
            });
            Animator $receiver$iv$iv = $receiver$iv = (Animator)animator;
            Animator.AnimatorListener listener$iv$iv = new Animator.AnimatorListener(this, p){
                final /* synthetic */ FillProgressLayout this$0;
                final /* synthetic */ int $p$inlined;
                {
                    this.this$0 = fillProgressLayout;
                    this.$p$inlined = n;
                }

                public void onAnimationRepeat(@NotNull Animator animator) {
                    Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                    Animator it = animator;
                }

                public void onAnimationEnd(@NotNull Animator animator) {
                    Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                    Animator it = animator;
                    boolean bl = false;
                    if (!FillProgressLayout.access$isRestart$p(this.this$0)) {
                        FillProgressLayout.access$setOldProgress$p(this.this$0, this.$p$inlined);
                    }
                }

                public void onAnimationCancel(@NotNull Animator animator) {
                    Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                    Animator it = animator;
                }

                public void onAnimationStart(@NotNull Animator animator) {
                    Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                    Animator it = animator;
                }
            };
            $receiver$iv$iv.addListener(listener$iv$iv);
            int n2 = p - this.oldProgress;
            ValueAnimator valueAnimator2 = animator;
            boolean bl = false;
            int n3 = Math.abs(n2);
            valueAnimator2.setDuration((long)(n3 * this.mDurationFactor)).start();
        }
    }

    public final void setProgressBackgroundColor(@ColorRes int resId) {
        if (this.isValidRes(resId)) {
            this.mBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)resId);
        }
    }

    public final void setProgressColor(@ColorRes int resId) {
        if (this.isValidRes(resId)) {
            this.mProgressColor = ContextCompat.getColor((Context)this.getContext(), (int)resId);
        }
    }

    public final void setCornerRadius(float radius) {
        float f = this.maxProgress;
        float f2 = radius;
        if (f2 >= 0.0f && f2 <= f) {
            this.setRoundedCorners(true);
            this.mCornerRadius = radius;
        }
    }

    public final void setRoundedCorners(boolean isRounded) {
        this.isRounded = isRounded;
    }

    public final void setDuration(long duration) {
        if ((int)duration == 0 || duration < 0L) {
            return;
        }
        this.mDurationFactor = (int)(duration / (long)100);
    }

    public final void shouldStartFromZero(boolean isRestart) {
        this.isRestart = isRestart;
    }

    public final void setDirection(int direction) {
        int n = direction;
        this.mDirection = 0 <= n && 3 >= n ? direction : this.defDirection;
    }

    public void setBackground(@Nullable Drawable background) {
    }

    public void setBackgroundColor(int color) {
    }

    public void setBackgroundResource(int resid) {
    }

    public void setBackgroundDrawable(@Nullable Drawable background) {
    }

    public FillProgressLayout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, null);
    }

    public FillProgressLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, attrs);
    }

    public FillProgressLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxProgress = 100;
        this.defDurationFactor = 30;
        this.defDuration = this.defDurationFactor * 100;
        this.defCornerRadius = 20.0f;
        this.defBackgroundColor = -3355444;
        this.defProgressColor = -7829368;
        this.isRounded = this.defIsRounded;
        this.isRestart = this.defIsRestart;
        this.mDurationFactor = this.defDurationFactor;
        this.mDirection = this.defDirection;
        this.mCornerRadius = this.defCornerRadius;
        this.mBackgroundColor = this.defBackgroundColor;
        this.mProgressColor = this.defProgressColor;
        this.progressPaint = new Paint(1);
        this.backgroundPaint = new Paint(1);
        this.clipPath = new Path();
        this.progressRectF = new RectF();
        this.backRectF = new RectF();
        this.initUI(context, attrs);
    }

    public static final /* synthetic */ int access$getCurrentProgress$p(FillProgressLayout $this) {
        return $this.currentProgress;
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(FillProgressLayout $this, int n) {
        $this.currentProgress = n;
    }

    public static final /* synthetic */ void access$updateRect(FillProgressLayout $this, RectF rectF) {
        $this.updateRect(rectF);
    }

    public static final /* synthetic */ RectF access$getProgressRectF$p(FillProgressLayout $this) {
        return $this.progressRectF;
    }

    public static final /* synthetic */ void access$setProgressRectF$p(FillProgressLayout $this, RectF rectF) {
        $this.progressRectF = rectF;
    }

    public static final /* synthetic */ boolean access$isRestart$p(FillProgressLayout $this) {
        return $this.isRestart;
    }

    public static final /* synthetic */ void access$setRestart$p(FillProgressLayout $this, boolean bl) {
        $this.isRestart = bl;
    }

    public static final /* synthetic */ int access$getOldProgress$p(FillProgressLayout $this) {
        return $this.oldProgress;
    }

    public static final /* synthetic */ void access$setOldProgress$p(FillProgressLayout $this, int n) {
        $this.oldProgress = n;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/devzone/fillprogresslayout/FillProgressLayout$Companion;", "", "()V", "BOTTOM_TO_TOP", "", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "TOP_TO_BOTTOM", "fillprogresslayout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

