/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.sectionedrecyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.intrusoft.sectionedrecyclerview.Section;
import com.intrusoft.sectionedrecyclerview.SectionWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class SectionRecyclerViewAdapter<S extends Section<C>, C, SVH extends RecyclerView.ViewHolder, CVH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<S> sectionItemList;
    private int SECTION_VIEW_TYPE = 1;
    private int CHILD_VIEW_TYPE = 2;
    private List<SectionWrapper<S, C>> flatItemList;

    public SectionRecyclerViewAdapter(Context context, List<S> sectionItemList) {
        this.sectionItemList = sectionItemList;
        this.flatItemList = this.generateFlatItemList(sectionItemList);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (this.isSectionViewType(viewType)) {
            SVH sectionViewHolder = this.onCreateSectionViewHolder(viewGroup, viewType);
            return sectionViewHolder;
        }
        CVH childViewHolder = this.onCreateChildViewHolder(viewGroup, viewType);
        return childViewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int flatPosition) {
        if (flatPosition > this.flatItemList.size()) {
            throw new IllegalStateException("Trying to bind item out of bounds, size " + this.flatItemList.size() + " flatPosition " + flatPosition + ". Was the data changed without a call to notify...()?");
        }
        SectionWrapper<S, C> sectionWrapper = this.flatItemList.get(flatPosition);
        if (sectionWrapper.isSection()) {
            RecyclerView.ViewHolder sectionViewHolder = holder;
            this.onBindSectionViewHolder(sectionViewHolder, sectionWrapper.getSectionPosition(), sectionWrapper.getSection());
        } else {
            RecyclerView.ViewHolder childViewHolder = holder;
            this.onBindChildViewHolder(childViewHolder, sectionWrapper.getSectionPosition(), sectionWrapper.getChildPosition(), sectionWrapper.getChild());
        }
    }

    public abstract SVH onCreateSectionViewHolder(ViewGroup var1, int var2);

    public abstract CVH onCreateChildViewHolder(ViewGroup var1, int var2);

    public abstract void onBindSectionViewHolder(SVH var1, int var2, S var3);

    public abstract void onBindChildViewHolder(CVH var1, int var2, int var3, C var4);

    private void generateSectionWrapper(List<SectionWrapper<S, C>> flatItemList, S section, int sectionPosition) {
        SectionWrapper sectionWrapper = new SectionWrapper(section, sectionPosition);
        flatItemList.add(sectionWrapper);
        List childList = section.getChildItems();
        for (int i = 0; i < childList.size(); ++i) {
            SectionWrapper childWrapper = new SectionWrapper(childList.get(i), sectionPosition, i);
            flatItemList.add(childWrapper);
        }
    }

    private List<SectionWrapper<S, C>> generateFlatItemList(List<S> sectionItemList) {
        ArrayList<SectionWrapper<S, C>> flatItemList = new ArrayList<SectionWrapper<S, C>>();
        for (int i = 0; i < sectionItemList.size(); ++i) {
            Section section = (Section)sectionItemList.get(i);
            this.generateSectionWrapper(flatItemList, section, i);
        }
        return flatItemList;
    }

    public int getItemCount() {
        return this.flatItemList.size();
    }

    public int getItemViewType(int position) {
        return this.flatItemList.get(position).isSection() ? this.SECTION_VIEW_TYPE : this.CHILD_VIEW_TYPE;
    }

    public boolean isSectionViewType(int viewType) {
        return viewType == this.SECTION_VIEW_TYPE;
    }

    public void insertNewSection(S section) {
        this.insertNewSection(section, this.sectionItemList.size());
    }

    public void insertNewSection(S section, int sectionPosition) {
        if (sectionPosition > this.sectionItemList.size() || sectionPosition < 0) {
            throw new IndexOutOfBoundsException("sectionPosition =  " + sectionPosition + " , Size is " + this.sectionItemList.size());
        }
        this.notifyDataChanged(this.sectionItemList);
    }

    public void removeSection(int sectionPosition) {
        if (sectionPosition > this.sectionItemList.size() - 1 || sectionPosition < 0) {
            throw new IndexOutOfBoundsException("sectionPosition =  " + sectionPosition + " , Size is " + this.sectionItemList.size());
        }
        this.sectionItemList.remove(sectionPosition);
        this.notifyDataChanged(this.sectionItemList);
    }

    public void insertNewChild(C child, int sectionPosition) {
        if (sectionPosition > this.sectionItemList.size() - 1 || sectionPosition < 0) {
            throw new IndexOutOfBoundsException("Invalid sectionPosition =  " + sectionPosition + " , Size is " + this.sectionItemList.size());
        }
        this.insertNewChild(child, sectionPosition, ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().size());
    }

    public void insertNewChild(C child, int sectionPosition, int childPosition) {
        if (sectionPosition > this.sectionItemList.size() - 1 || sectionPosition < 0) {
            throw new IndexOutOfBoundsException("Invalid sectionPosition =  " + sectionPosition + " , Size is " + this.sectionItemList.size());
        }
        if (childPosition > ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().size() || childPosition < 0) {
            throw new IndexOutOfBoundsException("Invalid childPosition =  " + childPosition + " , Size is " + ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().size());
        }
        ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().add(childPosition, child);
        this.notifyDataChanged(this.sectionItemList);
    }

    public void removeChild(int sectionPosition, int childPosition) {
        if (sectionPosition > this.sectionItemList.size() - 1 || sectionPosition < 0) {
            throw new IndexOutOfBoundsException("Invalid sectionPosition =  " + sectionPosition + " , Size is " + this.sectionItemList.size());
        }
        if (childPosition > ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().size() - 1 || childPosition < 0) {
            throw new IndexOutOfBoundsException("Invalid childPosition =  " + childPosition + " , Size is " + ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().size());
        }
        ((Section)this.sectionItemList.get(sectionPosition)).getChildItems().remove(childPosition);
        this.notifyDataChanged(this.sectionItemList);
    }

    public void notifyDataChanged(List<S> sectionItemList) {
        this.flatItemList = new ArrayList<SectionWrapper<S, C>>();
        this.flatItemList = this.generateFlatItemList(sectionItemList);
        this.notifyDataSetChanged();
    }
}

