/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.content.Context;
import android.os.AsyncTask;
import com.infomaniak.lib.pdfview.DisplayOptions;
import com.infomaniak.lib.pdfview.PDFSpacing;
import com.infomaniak.lib.pdfview.PDFView;
import com.infomaniak.lib.pdfview.PdfFile;
import com.infomaniak.lib.pdfview.source.DocumentSource;
import com.infomaniak.lib.pdfview.util.FitPolicy;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;
import java.lang.ref.WeakReference;

class DecodingAsyncTask
extends AsyncTask<Void, Void, Throwable> {
    private boolean cancelled;
    private WeakReference<PDFView> pdfViewReference;
    private WeakReference<Context> contextReference;
    private int pageSeparatorSpacing;
    private int startSpacing;
    private int endSpacing;
    private boolean isAutoSpacingEnabled;
    private boolean isSwipeVertical;
    private boolean isFitEachPage;
    private FitPolicy pageFitPolicy;
    private PdfiumCore pdfiumCore;
    private String password;
    private DocumentSource docSource;
    private int[] userPages;
    private PdfFile pdfFile;

    DecodingAsyncTask(DocumentSource docSource, String password, int[] userPages, PDFView pdfView, PdfiumCore pdfiumCore) {
        this.docSource = docSource;
        this.password = password;
        this.userPages = userPages;
        this.pdfiumCore = pdfiumCore;
        this.cancelled = false;
        this.pdfViewReference = new WeakReference<PDFView>(pdfView);
        this.contextReference = new WeakReference<Context>(pdfView.getContext());
        this.pageSeparatorSpacing = pdfView.getPageSeparatorSpacing();
        this.startSpacing = pdfView.getStartSpacing();
        this.endSpacing = pdfView.getEndSpacing();
        this.isAutoSpacingEnabled = pdfView.isAutoSpacingEnabled();
        this.isSwipeVertical = pdfView.isSwipeVertical();
        this.isFitEachPage = pdfView.isFitEachPage();
        this.pageFitPolicy = pdfView.getPageFitPolicy();
    }

    protected Throwable doInBackground(Void ... params) {
        try {
            PDFView pdfView = (PDFView)((Object)this.pdfViewReference.get());
            if (pdfView != null) {
                PdfDocument pdfDocument = this.docSource.createDocument((Context)this.contextReference.get(), this.pdfiumCore, this.password);
                PDFSpacing pdfSpacing = new PDFSpacing(this.pageSeparatorSpacing, this.startSpacing, this.endSpacing, this.isAutoSpacingEnabled);
                DisplayOptions displayOptions = new DisplayOptions(this.isSwipeVertical, pdfSpacing, this.isFitEachPage, this.getViewSize(pdfView), this.pageFitPolicy);
                this.pdfFile = new PdfFile(this.pdfiumCore, pdfDocument, this.userPages, displayOptions);
                return null;
            }
            return new NullPointerException("pdfView == null");
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Size getViewSize(PDFView pdfView) {
        return new Size(pdfView.getWidth(), pdfView.getHeight());
    }

    protected void onPostExecute(Throwable t) {
        PDFView pdfView = (PDFView)((Object)this.pdfViewReference.get());
        if (pdfView != null) {
            if (t != null) {
                pdfView.loadError(t);
                return;
            }
            if (!this.cancelled) {
                pdfView.loadComplete(this.pdfFile);
            }
        }
    }

    protected void onCancelled() {
        this.cancelled = true;
    }
}

